/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.bdb;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.tree.DuplicateEntryException;
import io.leopard.bdb.Bdb;

public class BdbDatabaseImpl
implements Bdb {
    private Database database;
    private Transaction transaction;

    public BdbDatabaseImpl(Environment environment, String databaseName) throws DatabaseException {
        DatabaseConfig dbConfig = new DatabaseConfig();
        dbConfig.setAllowCreate(true);
        dbConfig.setSortedDuplicates(true);
        this.database = environment.openDatabase(this.transaction, databaseName, dbConfig);
    }

    @Override
    public boolean put(String key, String value) throws DatabaseException {
        this.database.put(this.transaction, new DatabaseEntry(key.getBytes()), new DatabaseEntry(value.getBytes()));
        return true;
    }

    @Override
    public boolean putNoDupData(String key, String value) throws DatabaseException {
        OperationStatus status = this.database.putNoDupData(this.transaction, new DatabaseEntry(key.getBytes()), new DatabaseEntry(value.getBytes()));
        String result = status.toString();
        if (result.endsWith(".KEYEXIST")) {
            throw new DuplicateEntryException("key[" + key + "]\u5df2\u5b58\u5728.");
        }
        return true;
    }

    @Override
    public String getString(String key) throws DatabaseException {
        DatabaseEntry data = new DatabaseEntry();
        this.database.get(this.transaction, new DatabaseEntry(key.getBytes()), data, LockMode.DEFAULT);
        byte[] bytes = data.getData();
        if (bytes == null) {
            return null;
        }
        return new String(bytes);
    }

    @Override
    public boolean delete(String key) throws DatabaseException {
        this.database.delete(this.transaction, new DatabaseEntry(key.getBytes()));
        return true;
    }

    public void destroy() throws DatabaseException {
        if (this.database != null) {
            this.database.close();
        }
    }

    @Override
    public long count() throws DatabaseException {
        return this.database.count();
    }

    @Override
    public boolean sync() throws DatabaseException {
        this.database.sync();
        return true;
    }
}

