/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.bdb;

import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentLockedException;
import com.sleepycat.je.Transaction;
import io.leopard.bdb.Bdb;
import io.leopard.bdb.BdbDatabaseImpl;
import java.io.File;

public class BdbImpl
implements Bdb {
    protected Environment environment;
    private BdbDatabaseImpl bdb;
    protected File dataDir;
    protected Transaction transaction;

    public File getDataDir() {
        return this.dataDir;
    }

    public void setDataDir(File dataDir) {
        this.dataDir = dataDir;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void init() throws EnvironmentLockedException, DatabaseException {
        EnvironmentConfig environmentConfig = new EnvironmentConfig();
        DatabaseConfig dbConfig = new DatabaseConfig();
        dbConfig.setAllowCreate(true);
        dbConfig.setSortedDuplicates(true);
        environmentConfig.setReadOnly(false);
        environmentConfig.setAllowCreate(true);
        if (!this.dataDir.exists()) {
            this.dataDir.mkdirs();
        }
        this.environment = new Environment(this.dataDir, environmentConfig);
        this.bdb = new BdbDatabaseImpl(this.environment, "DEFAULT");
    }

    @Override
    public boolean put(String key, String value) throws DatabaseException {
        return this.bdb.put(key, value);
    }

    @Override
    public boolean putNoDupData(String key, String value) throws DatabaseException {
        return this.bdb.putNoDupData(key, value);
    }

    @Override
    public String getString(String key) throws DatabaseException {
        return this.bdb.getString(key);
    }

    @Override
    public boolean delete(String key) throws DatabaseException {
        return this.bdb.delete(key);
    }

    public void destroy() throws DatabaseException {
        this.bdb.destroy();
        if (this.environment != null) {
            this.environment.close();
        }
    }

    @Override
    public long count() throws DatabaseException {
        return this.bdb.count();
    }

    @Override
    public boolean sync() throws DatabaseException {
        this.environment.sync();
        return true;
    }
}

