/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.chart.line;

import io.leopard.burrow.util.DateUtil;
import io.leopard.chart.line.LineData;
import io.leopard.chart.line.LineDataProvider;
import io.leopard.chart.line.LineDayVO;
import io.leopard.lang.datatype.TimeRange;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class LineChartBuilder {
    private List<LineData> list = new ArrayList<LineData>();

    public void add(String label, String color, LineDataProvider provider) {
        this.add(label, color, provider, null);
    }

    public void add(String label, String color, LineDataProvider provider, String format) {
        LineData line = new LineData();
        line.setLabel(label);
        line.setColor(color);
        try {
            line.setData(this.toData(provider.execute(), format));
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        this.list.add(line);
    }

    protected List<Object[]> toData(List<?> dataList, String format) throws Exception {
        if (dataList == null) {
            return null;
        }
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        for (Object obj : dataList) {
            Field[] fields = obj.getClass().getDeclaredFields();
            Object[] data = new Object[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                field.setAccessible(true);
                data[i] = field.get(obj);
                if (i != 0 || format == null || !(data[i] instanceof Date)) continue;
                data[i] = new SimpleDateFormat(format).format((Date)data[i]);
            }
            list.add(data);
        }
        return list;
    }

    public List<LineData> build() {
        return this.list;
    }

    public static List<LineDayVO> fill(List<LineDayVO> list, TimeRange range) {
        if (range == null || range.getStartTime() == null || range.getEndTime() == null) {
            return list;
        }
        Date startTime = range.getStartTime();
        int dayCount = Math.abs(DateUtil.getDayCount((Date)range.getStartTime(), (Date)range.getEndTime()));
        for (int i = 0; i < dayCount; ++i) {
            Date curdate = DateUtil.addDate((Date)startTime, (int)i);
            LineDayVO dayVO = null;
            Date postdate = null;
            if (list.size() - 1 >= i) {
                dayVO = list.get(i);
                postdate = dayVO.getPostdate();
            }
            if (curdate.equals(postdate)) continue;
            LineDayVO dayVO2 = new LineDayVO();
            dayVO2.setPostdate(curdate);
            list.add(i, dayVO2);
        }
        return list;
    }
}

