/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.email;

import io.leopard.email.MailClient;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.apache.commons.mail.SimpleEmail;
import org.springframework.beans.factory.annotation.Value;

public class MailClientImpl
implements MailClient {
    @Value(value="${mail.host}")
    private String host;
    @Value(value="${mail.user}")
    private String user;
    @Value(value="${mail.from}")
    private String from;
    @Value(value="${mail.port}")
    private int port;
    @Value(value="${mail.password}")
    private String password;

    @Override
    public boolean sendText(String to, String subject, String content) throws EmailException {
        SimpleEmail email = new SimpleEmail();
        email.setHostName(this.host);
        email.addTo(to);
        email.setAuthentication(this.user, this.password);
        email.setFrom(this.from);
        email.setSubject(subject);
        email.setMsg(content);
        if (this.port == 465) {
            email.setSSLOnConnect(true);
            email.setSslSmtpPort(Integer.toString(this.port));
        } else {
            email.setSmtpPort(this.port);
        }
        email.send();
        return true;
    }

    @Override
    public boolean sendHtml(String to, String subject, String content) throws EmailException {
        HtmlEmail email = new HtmlEmail();
        email.setHostName(this.host);
        email.addTo(to);
        email.setAuthentication(this.user, this.password);
        email.setFrom(this.user);
        email.setSubject(subject);
        email.setMsg(content);
        email.setSSLOnConnect(true);
        email.setSslSmtpPort("465");
        email.send();
        return true;
    }
}

