/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.web.servlet;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CookieBuilder {
    private String name;
    private String value;
    private String domain;
    private int maxAge = -1;
    private boolean httpOnly;
    private HttpServletResponse response;

    public CookieBuilder(String name, long value, HttpServletResponse response) {
        this(name, Long.toString(value), response);
    }

    public CookieBuilder(String name, int value, HttpServletResponse response) {
        this(name, Integer.toString(value), response);
    }

    public CookieBuilder(String name, String value, HttpServletResponse response) {
        this.name = name;
        this.value = value;
        this.response = response;
    }

    public CookieBuilder setMaxAge(int maxAge, boolean remember) {
        if (remember) {
            this.maxAge = maxAge;
        }
        return this;
    }

    public CookieBuilder setMaxAge(int maxAge) {
        this.maxAge = maxAge;
        return this;
    }

    public CookieBuilder setDomain(String domain) {
        this.domain = domain;
        return this;
    }

    public CookieBuilder setTopLevelDomain(HttpServletRequest request) {
        String domain;
        String serverName = request.getServerName();
        if ("localhost".equals(serverName)) {
            return this;
        }
        this.domain = domain = CookieBuilder.parseTopLevelDomain(serverName);
        return this;
    }

    public static String parseTopLevelDomain(String serverName) {
        String regex = "[a-z0-9\\-_]+\\.[a-z]+$";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(serverName);
        if (m.find()) {
            return m.group();
        }
        return serverName;
    }

    public CookieBuilder setHttpOnly(boolean httpOnly) {
        this.httpOnly = httpOnly;
        return this;
    }

    public CookieBuilder build() {
        if (this.name == null || this.name.length() == 0) {
            throw new IllegalArgumentException("cookie\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a.");
        }
        if (this.value == null) {
            throw new IllegalArgumentException("cookie[" + this.name + "]\u503c\u4e0d\u80fd\u4e3a\u7a7a.");
        }
        Cookie cookie = new Cookie(this.name, this.value);
        if (this.maxAge > -1) {
            cookie.setMaxAge(this.maxAge);
        }
        if (this.domain != null && this.domain.length() > 0) {
            cookie.setDomain(this.domain);
        }
        cookie.setPath("/");
        if (this.httpOnly) {
            cookie.setHttpOnly(true);
        }
        this.response.addCookie(cookie);
        return this;
    }
}

