/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.web.servlet;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CookieUtil {
    public static void setCookie(String name, String value, HttpServletRequest request, HttpServletResponse response) {
        int maxAge = -1;
        CookieUtil.setCookie(name, value, maxAge, request, response);
    }

    public static void setCookie(String name, String value, HttpServletResponse response) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("cookie\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a.");
        }
        Cookie cookie = new Cookie(name, value);
        response.addCookie(cookie);
    }

    public static void setCookie(String name, String value, int maxAge, HttpServletRequest request, HttpServletResponse response) {
        boolean httpOnly = false;
        CookieUtil.setCookie(name, value, maxAge, httpOnly, request, response);
    }

    public static void setCookie(String name, String value, int maxAge, boolean httpOnly, HttpServletRequest request, HttpServletResponse response) {
        String domain = request.getServerName();
        CookieUtil.setCookie(name, value, maxAge, httpOnly, domain, response);
    }

    public static void setCookie(String name, String value, int maxAge, boolean httpOnly, String domain, HttpServletResponse response) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("cookie\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a.");
        }
        Cookie cookie = new Cookie(name, value);
        cookie.setDomain(domain);
        cookie.setMaxAge(maxAge);
        if (httpOnly) {
            cookie.setPath("/");
            cookie.setHttpOnly(true);
        } else {
            cookie.setPath("/");
        }
        response.addHeader("P3P", "CP=\"CURa ADMa DEVa PSAo PSDo OUR BUS UNI PUR INT DEM STA PRE COM NAV OTC NOI DSP COR\"");
        response.addCookie(cookie);
    }

    public static String getCookie(String name, HttpServletRequest request) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("cookie\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a.");
        }
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return null;
        }
        for (int i = 0; i < cookies.length; ++i) {
            if (!name.equalsIgnoreCase(cookies[i].getName())) continue;
            return cookies[i].getValue();
        }
        return null;
    }

    public static void deleteCookie(String name, HttpServletRequest request, HttpServletResponse response) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("cookie\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a.");
        }
        CookieUtil.setCookie(name, "", -1, false, request, response);
    }

    public static void deleteCookie(String name, String domain, HttpServletResponse response) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("cookie\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a.");
        }
        CookieUtil.setCookie(name, "", -1, false, domain, response);
    }

    public static void deleteCookie(String name, HttpServletResponse response) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("cookie\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a.");
        }
        CookieUtil.setCookie(name, "", response);
    }
}

