/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.web.servlet;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.BeansException;
import org.springframework.beans.Mergeable;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public abstract class RegisterHandlerInterceptor
implements HandlerInterceptor,
BeanFactoryAware,
BeanPostProcessor,
Mergeable {
    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
    }

    protected boolean isHandlerMapping(BeanDefinition beanDefinition) {
        Class<?> clazz;
        String beanClassName = beanDefinition.getBeanClassName();
        if (beanClassName == null) {
            return false;
        }
        try {
            clazz = Class.forName(beanClassName);
        }
        catch (NoClassDefFoundError e) {
            e.printStackTrace();
            return false;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return RequestMappingHandlerMapping.class.isAssignableFrom(clazz);
    }

    protected boolean isRegister() {
        return true;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (!this.isRegister()) {
            return;
        }
        ConfigurableListableBeanFactory factory = (ConfigurableListableBeanFactory)beanFactory;
        for (String beanName : factory.getBeanDefinitionNames()) {
            BeanDefinition beanDefinition = factory.getBeanDefinition(beanName);
            boolean isHandlerMapping = this.isHandlerMapping(beanDefinition);
            if (!isHandlerMapping) continue;
            MutablePropertyValues propertyValues = beanDefinition.getPropertyValues();
            propertyValues.addPropertyValue("interceptors", (Object)this);
        }
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public boolean isMergeEnabled() {
        return true;
    }

    public Object merge(Object parent) {
        if (parent instanceof Object[]) {
            Object[] interceptors = (Object[])parent;
            Object[] args = new Object[interceptors.length + 1];
            System.arraycopy(interceptors, 0, args, 1, interceptors.length);
            args[0] = this;
            return args;
        }
        return new Object[]{this, parent};
    }
}

