/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.web.servlet;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class UriListChecker {
    private Set<String> uris = new HashSet<String>();
    private List<String> folders = new ArrayList<String>();

    public UriListChecker() {
    }

    public UriListChecker(List<String> uriList) {
        this.uris = this.getUris(uriList);
        this.folders = this.getFolders(uriList);
    }

    protected Set<String> getUris(List<String> uriList) {
        HashSet<String> set = new HashSet<String>();
        if (uriList != null) {
            for (String uri : uriList) {
                if (uri.endsWith("/")) continue;
                set.add(uri);
            }
        }
        return set;
    }

    protected List<String> getFolders(List<String> uriList) {
        ArrayList<String> list = new ArrayList<String>();
        if (uriList != null) {
            for (String uri : uriList) {
                if (!uri.endsWith("/")) continue;
                list.add(uri);
            }
        }
        return list;
    }

    public boolean exists(String uri) {
        if (this.uris.contains(uri)) {
            return true;
        }
        for (String folder : this.folders) {
            if (!uri.startsWith(folder)) continue;
            return true;
        }
        return false;
    }
}

