/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.treedata;

import io.leopard.treedata.Children;
import io.leopard.treedata.Row;
import io.leopard.treedata.TreeDataManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.core.io.ClassPathResource;

public class TreeDataManagerImpl
implements TreeDataManager {
    @Override
    public List<Children> parse(String path) throws IOException {
        List<Row> rows = this.load(path);
        ArrayList<Children> list = new ArrayList<Children>();
        for (Row row : rows) {
            if (row.getFloor() != 0) continue;
            Children children = new Children(row.getData(0), row.getData(1), row.getLine());
            list.add(children);
        }
        int preFloor = 0;
        Children preChildren = null;
        HashMap<Integer, Children> parentMap = new HashMap<Integer, Children>();
        int index = 0;
        for (Row row : rows) {
            Children c;
            if (row.getFloor() <= 0) {
                parentMap.clear();
                preChildren = (Children)list.get(index);
                parentMap.put(0, preChildren);
                ++index;
                continue;
            }
            System.out.println("row:" + row.getLine());
            String name = row.getData(0);
            String colour = row.getData(1);
            String line = row.getLine();
            int floor = row.getFloor();
            int diff = row.getFloor() - preFloor;
            preFloor = row.getFloor();
            if (diff > 0) {
                c = preChildren.add(name, colour, line);
                parentMap.put(floor, c);
                preChildren = c;
                continue;
            }
            if (diff < 0) {
                c = (Children)parentMap.get(floor - 1);
                preChildren = c.add(name, colour, line);
                parentMap.put(floor, preChildren);
                continue;
            }
            c = (Children)parentMap.get(floor - 1);
            Children current = c.add(name, colour, line);
            parentMap.put(floor, current);
            preChildren = current;
        }
        return list;
    }

    @Override
    public List<Row> load(String path) throws IOException {
        ClassPathResource resource = new ClassPathResource(path);
        InputStream is = resource.getInputStream();
        String content = IOUtils.toString((InputStream)is);
        is.close();
        content = content.replace("\r", "");
        String[] lines = content.split("\n");
        ArrayList<Row> list = new ArrayList<Row>();
        for (String line : lines) {
            if (StringUtils.isBlank((String)line)) continue;
            int floor = this.floor(line);
            Row row = new Row(floor, line);
            list.add(row);
        }
        return list;
    }

    protected int floor(String line) {
        int floor = 0;
        for (char c : line.toCharArray()) {
            if (c != '\t') break;
            ++floor;
        }
        return floor;
    }
}

