/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.RedisChannelHandler;
import io.lettuce.core.RedisConnectionStateListener;
import io.netty.util.internal.ConcurrentSet;
import java.net.SocketAddress;
import java.util.Set;

public class ConnectionEvents {
    private final Set<RedisConnectionStateListener> listeners = new ConcurrentSet();

    void fireEventRedisConnected(RedisChannelHandler<?, ?> connection, SocketAddress socketAddress) {
        for (RedisConnectionStateListener listener : this.listeners) {
            listener.onRedisConnected(connection, socketAddress);
        }
    }

    void fireEventRedisDisconnected(RedisChannelHandler<?, ?> connection) {
        for (RedisConnectionStateListener listener : this.listeners) {
            listener.onRedisDisconnected(connection);
        }
    }

    void fireEventRedisExceptionCaught(RedisChannelHandler<?, ?> connection, Throwable cause) {
        for (RedisConnectionStateListener listener : this.listeners) {
            listener.onRedisExceptionCaught(connection, cause);
        }
    }

    public void addListener(RedisConnectionStateListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(RedisConnectionStateListener listener) {
        this.listeners.remove(listener);
    }

    public static class Reconnect {
        private final int attempt;

        public Reconnect(int attempt) {
            this.attempt = attempt;
        }

        public int getAttempt() {
            return this.attempt;
        }
    }

    public static class Activated {
    }

    public static class Reset {
    }
}

