/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.internal.LettuceClassUtils;
import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.reflect.Constructor;
import java.net.SocketAddress;
import java.util.Locale;
import java.util.concurrent.ThreadFactory;

public class EpollProvider {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(EpollProvider.class);
    private static final String EPOLL_ENABLED_KEY = "io.lettuce.core.epoll";
    private static final boolean EPOLL_ENABLED = Boolean.parseBoolean(SystemPropertyUtil.get((String)"io.lettuce.core.epoll", (String)"true"));
    private static final boolean EPOLL_COMPATIBLE = SystemPropertyUtil.get((String)"os.name").toLowerCase(Locale.UK).trim().startsWith("linux");
    private static final Class<EventLoopGroup> epollEventLoopGroupClass = EpollProvider.getClass("io.netty.channel.epoll.EpollEventLoopGroup");
    private static final Class<Channel> epollDomainSocketChannelClass = EpollProvider.getClass("io.netty.channel.epoll.EpollDomainSocketChannel");
    private static final Class<Channel> epollSocketChannelClass = EpollProvider.getClass("io.netty.channel.epoll.EpollSocketChannel");
    private static final Class<SocketAddress> domainSocketAddressClass = EpollProvider.getClass("io.netty.channel.unix.DomainSocketAddress");

    public static boolean isEventLoopGroup(Class<? extends EventExecutorGroup> type) {
        LettuceAssert.notNull(type, "EventLoopGroup type must not be null");
        return type.equals(epollEventLoopGroupClass);
    }

    public static EventLoopGroup newEventLoopGroup(int nThreads, ThreadFactory threadFactory) {
        try {
            Constructor<EventLoopGroup> constructor = epollEventLoopGroupClass.getConstructor(Integer.TYPE, ThreadFactory.class);
            return constructor.newInstance(nThreads, threadFactory);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static boolean isAvailable() {
        return domainSocketAddressClass != null && epollDomainSocketChannelClass != null && EPOLL_ENABLED && EPOLL_COMPATIBLE;
    }

    static Class<? extends Channel> domainSocketChannelClass() {
        return epollDomainSocketChannelClass;
    }

    static Class<? extends Channel> socketChannelClass() {
        return epollSocketChannelClass;
    }

    static Class<? extends EventLoopGroup> eventLoopGroupClass() {
        return epollEventLoopGroupClass;
    }

    static void checkForEpollLibrary() {
        LettuceAssert.assertState(EPOLL_ENABLED && EPOLL_COMPATIBLE, String.format("epoll use is disabled via System properties (%s)", EPOLL_ENABLED_KEY));
        LettuceAssert.assertState(EpollProvider.isAvailable(), "Cannot connect using sockets without the optional netty-transport-native-epoll library on the class path");
    }

    static SocketAddress newSocketAddress(String socketPath) {
        try {
            Constructor<SocketAddress> constructor = domainSocketAddressClass.getConstructor(String.class);
            return constructor.newInstance(socketPath);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static <T> Class<T> getClass(String className) {
        try {
            return LettuceClassUtils.forName(className);
        }
        catch (ClassNotFoundException e) {
            logger.debug("Cannot load class " + className, (Throwable)e);
            return null;
        }
    }

    static {
        if (epollDomainSocketChannelClass == null || epollEventLoopGroupClass == null || epollSocketChannelClass == null) {
            logger.debug("Starting without optional Epoll library");
        } else {
            logger.debug("Starting with Epoll library");
            if (!EPOLL_COMPATIBLE) {
                logger.debug(String.format("Epoll not compatible with %s", SystemPropertyUtil.get((String)"os.name")));
            }
        }
    }
}

