/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.cluster;

import io.lettuce.core.ClientOptions;
import io.lettuce.core.ReadFrom;
import io.lettuce.core.RedisChannelHandler;
import io.lettuce.core.RedisChannelWriter;
import io.lettuce.core.RedisException;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.cluster.AsyncClusterConnectionProvider;
import io.lettuce.core.cluster.ClusterClientOptions;
import io.lettuce.core.cluster.ClusterCommand;
import io.lettuce.core.cluster.ClusterConnectionProvider;
import io.lettuce.core.cluster.ClusterEventListener;
import io.lettuce.core.cluster.ReadOnlyCommands;
import io.lettuce.core.cluster.SlotHash;
import io.lettuce.core.cluster.models.partitions.Partitions;
import io.lettuce.core.internal.HostAndPort;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CommandKeyword;
import io.lettuce.core.protocol.ConnectionFacade;
import io.lettuce.core.protocol.ProtocolKeyword;
import io.lettuce.core.protocol.RedisCommand;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.IntStream;

class ClusterDistributionChannelWriter
implements RedisChannelWriter {
    private final RedisChannelWriter defaultWriter;
    private final ClusterEventListener clusterEventListener;
    private final int executionLimit;
    private ClusterConnectionProvider clusterConnectionProvider;
    private AsyncClusterConnectionProvider asyncClusterConnectionProvider;
    private boolean closed = false;
    private volatile Partitions partitions;

    ClusterDistributionChannelWriter(ClientOptions clientOptions, RedisChannelWriter defaultWriter, ClusterEventListener clusterEventListener) {
        this.executionLimit = clientOptions instanceof ClusterClientOptions ? ((ClusterClientOptions)clientOptions).getMaxRedirects() : 5;
        this.defaultWriter = defaultWriter;
        this.clusterEventListener = clusterEventListener;
    }

    @Override
    public <K, V, T> RedisCommand<K, V, T> write(RedisCommand<K, V, T> command) {
        ByteBuffer encodedKey;
        ClusterCommand clusterCommand;
        LettuceAssert.notNull(command, "Command must not be null");
        if (this.closed) {
            throw new RedisException("Connection is closed");
        }
        if (command instanceof ClusterCommand && !command.isDone() && ((clusterCommand = (ClusterCommand)command).isMoved() || clusterCommand.isAsk())) {
            boolean asking;
            HostAndPort target;
            if (clusterCommand.isMoved()) {
                target = ClusterDistributionChannelWriter.getMoveTarget(clusterCommand.getError());
                this.clusterEventListener.onMovedRedirection();
                asking = false;
            } else {
                target = ClusterDistributionChannelWriter.getAskTarget(clusterCommand.getError());
                asking = true;
                this.clusterEventListener.onAskRedirection();
            }
            command.getOutput().setError((String)null);
            CompletableFuture connectFuture = this.asyncClusterConnectionProvider.getConnectionAsync(ClusterConnectionProvider.Intent.WRITE, target.getHostText(), target.getPort());
            if (ClusterDistributionChannelWriter.isSuccessfullyCompleted(connectFuture)) {
                ClusterDistributionChannelWriter.writeCommand(command, asking, connectFuture.join(), null);
            } else {
                connectFuture.whenComplete((connection, throwable) -> ClusterDistributionChannelWriter.writeCommand(command, asking, connection, throwable));
            }
            return command;
        }
        ClusterCommand commandToSend = this.getCommandToSend(command);
        CommandArgs<K, V> args = command.getArgs();
        if (args != null && (encodedKey = args.getFirstEncodedKey()) != null) {
            int hash = SlotHash.getSlot(encodedKey);
            ClusterConnectionProvider.Intent intent = ClusterDistributionChannelWriter.getIntent(command.getType());
            CompletableFuture connectFuture = ((AsyncClusterConnectionProvider)((Object)this.clusterConnectionProvider)).getConnectionAsync(intent, hash);
            if (ClusterDistributionChannelWriter.isSuccessfullyCompleted(connectFuture)) {
                ClusterDistributionChannelWriter.writeCommand(commandToSend, false, connectFuture.join(), null);
            } else {
                connectFuture.whenComplete((connection, throwable) -> ClusterDistributionChannelWriter.writeCommand(commandToSend, false, connection, throwable));
            }
            return commandToSend;
        }
        ClusterDistributionChannelWriter.writeCommand(commandToSend, this.defaultWriter);
        return commandToSend;
    }

    private static boolean isSuccessfullyCompleted(CompletableFuture<?> connectFuture) {
        return connectFuture.isDone() && !connectFuture.isCompletedExceptionally();
    }

    private <K, V, T> ClusterCommand<K, V, T> getCommandToSend(RedisCommand<K, V, T> command) {
        if (command instanceof ClusterCommand) {
            return (ClusterCommand)command;
        }
        return new ClusterCommand<K, V, T>(command, this, this.executionLimit);
    }

    private static <K, V> void writeCommand(RedisCommand<K, V, ?> command, boolean asking, StatefulRedisConnection<K, V> connection, Throwable throwable) {
        if (throwable != null) {
            command.completeExceptionally(throwable);
            return;
        }
        try {
            if (asking) {
                StatefulRedisConnection<K, V> statefulRedisConnection = connection;
                statefulRedisConnection.async().asking();
            }
            ClusterDistributionChannelWriter.writeCommand(command, ((RedisChannelHandler)((Object)connection)).getChannelWriter());
        }
        catch (Exception e) {
            command.completeExceptionally(e);
        }
    }

    private static <K, V> void writeCommand(RedisCommand<K, V, ?> command, RedisChannelWriter writer) {
        try {
            ClusterDistributionChannelWriter.getWriterToUse(writer).write(command);
        }
        catch (Exception e) {
            command.completeExceptionally(e);
        }
    }

    private static RedisChannelWriter getWriterToUse(RedisChannelWriter writer) {
        RedisChannelWriter writerToUse = writer;
        if (writer instanceof ClusterDistributionChannelWriter) {
            writerToUse = ((ClusterDistributionChannelWriter)writer).defaultWriter;
        }
        return writerToUse;
    }

    @Override
    public <K, V> Collection<RedisCommand<K, V, ?>> write(Collection<? extends RedisCommand<K, V, ?>> commands) {
        LettuceAssert.notNull(commands, "Commands must not be null");
        if (this.closed) {
            throw new RedisException("Connection is closed");
        }
        ArrayList<ClusterCommand> clusterCommands = new ArrayList<ClusterCommand>(commands.size());
        ArrayList defaultCommands = new ArrayList(commands.size());
        HashMap<SlotIntent, List> partitions = new HashMap<SlotIntent, List>();
        ClusterConnectionProvider.Intent intent = ClusterDistributionChannelWriter.getIntent(commands);
        for (RedisCommand<K, V, ?> redisCommand : commands) {
            ByteBuffer firstEncodedKey;
            if (redisCommand instanceof ClusterCommand) {
                clusterCommands.add((ClusterCommand)redisCommand);
                continue;
            }
            CommandArgs<K, V> args = redisCommand.getArgs();
            ByteBuffer byteBuffer = firstEncodedKey = args != null ? args.getFirstEncodedKey() : null;
            if (firstEncodedKey == null) {
                defaultCommands.add(new ClusterCommand(redisCommand, this, this.executionLimit));
                continue;
            }
            int hash = SlotHash.getSlot(args.getFirstEncodedKey());
            List commandPartition = partitions.computeIfAbsent(SlotIntent.of(intent, hash), slotIntent -> new ArrayList());
            commandPartition.add(new ClusterCommand(redisCommand, this, this.executionLimit));
        }
        for (Map.Entry entry : partitions.entrySet()) {
            SlotIntent slotIntent2 = (SlotIntent)entry.getKey();
            RedisChannelHandler connection = (RedisChannelHandler)((Object)this.clusterConnectionProvider.getConnection(slotIntent2.intent, slotIntent2.slotHash));
            RedisChannelWriter channelWriter = connection.getChannelWriter();
            if (channelWriter instanceof ClusterDistributionChannelWriter) {
                ClusterDistributionChannelWriter writer = (ClusterDistributionChannelWriter)channelWriter;
                channelWriter = writer.defaultWriter;
            }
            if (channelWriter == null || channelWriter == this || channelWriter == this.defaultWriter) continue;
            channelWriter.write((Collection)entry.getValue());
        }
        clusterCommands.forEach(this::write);
        defaultCommands.forEach(this.defaultWriter::write);
        return commands;
    }

    static ClusterConnectionProvider.Intent getIntent(Collection<? extends RedisCommand<?, ?, ?>> commands) {
        boolean w = false;
        boolean r = false;
        ClusterConnectionProvider.Intent singleIntent = ClusterConnectionProvider.Intent.WRITE;
        for (RedisCommand<?, ?, ?> command : commands) {
            if (command instanceof ClusterCommand) continue;
            singleIntent = ClusterDistributionChannelWriter.getIntent(command.getType());
            if (singleIntent == ClusterConnectionProvider.Intent.READ) {
                r = true;
            }
            if (singleIntent == ClusterConnectionProvider.Intent.WRITE) {
                w = true;
            }
            if (!r || !w) continue;
            return ClusterConnectionProvider.Intent.WRITE;
        }
        return singleIntent;
    }

    private static ClusterConnectionProvider.Intent getIntent(ProtocolKeyword type) {
        return ReadOnlyCommands.isReadOnlyCommand(type) ? ClusterConnectionProvider.Intent.READ : ClusterConnectionProvider.Intent.WRITE;
    }

    static HostAndPort getMoveTarget(String errorMessage) {
        LettuceAssert.notEmpty(errorMessage, "ErrorMessage must not be empty");
        LettuceAssert.isTrue(errorMessage.startsWith(CommandKeyword.MOVED.name()), "ErrorMessage must start with " + CommandKeyword.MOVED);
        String[] movedMessageParts = errorMessage.split(" ");
        LettuceAssert.isTrue(movedMessageParts.length >= 3, "ErrorMessage must consist of 3 tokens (" + errorMessage + ")");
        return HostAndPort.parseCompat(movedMessageParts[2]);
    }

    static HostAndPort getAskTarget(String errorMessage) {
        LettuceAssert.notEmpty(errorMessage, "ErrorMessage must not be empty");
        LettuceAssert.isTrue(errorMessage.startsWith(CommandKeyword.ASK.name()), "ErrorMessage must start with " + CommandKeyword.ASK);
        String[] movedMessageParts = errorMessage.split(" ");
        LettuceAssert.isTrue(movedMessageParts.length >= 3, "ErrorMessage must consist of 3 tokens (" + errorMessage + ")");
        return HostAndPort.parseCompat(movedMessageParts[2]);
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.defaultWriter != null) {
            this.defaultWriter.close();
        }
        if (this.clusterConnectionProvider != null) {
            this.clusterConnectionProvider.close();
            this.clusterConnectionProvider = null;
        }
    }

    @Override
    public void setConnectionFacade(ConnectionFacade redisChannelHandler) {
        this.defaultWriter.setConnectionFacade(redisChannelHandler);
    }

    @Override
    public void setAutoFlushCommands(boolean autoFlush) {
        this.getClusterConnectionProvider().setAutoFlushCommands(autoFlush);
    }

    @Override
    public void flushCommands() {
        this.getClusterConnectionProvider().flushCommands();
    }

    public ClusterConnectionProvider getClusterConnectionProvider() {
        return this.clusterConnectionProvider;
    }

    @Override
    public void reset() {
        this.defaultWriter.reset();
        this.clusterConnectionProvider.reset();
    }

    public void setClusterConnectionProvider(ClusterConnectionProvider clusterConnectionProvider) {
        this.clusterConnectionProvider = clusterConnectionProvider;
        this.asyncClusterConnectionProvider = (AsyncClusterConnectionProvider)((Object)clusterConnectionProvider);
    }

    public void setPartitions(Partitions partitions) {
        this.partitions = partitions;
        if (this.clusterConnectionProvider != null) {
            this.clusterConnectionProvider.setPartitions(partitions);
        }
    }

    public Partitions getPartitions() {
        return this.partitions;
    }

    public void setReadFrom(ReadFrom readFrom) {
        this.clusterConnectionProvider.setReadFrom(readFrom);
    }

    public ReadFrom getReadFrom() {
        return this.clusterConnectionProvider.getReadFrom();
    }

    static class SlotIntent {
        final int slotHash;
        final ClusterConnectionProvider.Intent intent;
        private static final SlotIntent[] READ = new SlotIntent[16384];
        private static final SlotIntent[] WRITE = new SlotIntent[16384];

        private SlotIntent(int slotHash, ClusterConnectionProvider.Intent intent) {
            this.slotHash = slotHash;
            this.intent = intent;
        }

        public static SlotIntent of(ClusterConnectionProvider.Intent intent, int slot) {
            if (intent == ClusterConnectionProvider.Intent.READ) {
                return READ[slot];
            }
            return WRITE[slot];
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SlotIntent)) {
                return false;
            }
            SlotIntent that = (SlotIntent)o;
            if (this.slotHash != that.slotHash) {
                return false;
            }
            return this.intent == that.intent;
        }

        public int hashCode() {
            int result = this.slotHash;
            result = 31 * result + this.intent.hashCode();
            return result;
        }

        static {
            IntStream.range(0, 16384).forEach(i -> {
                SlotIntent.READ[i] = new SlotIntent(i, ClusterConnectionProvider.Intent.READ);
                SlotIntent.WRITE[i] = new SlotIntent(i, ClusterConnectionProvider.Intent.WRITE);
            });
        }
    }
}

