/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.cluster;

import io.lettuce.core.LettuceFutures;
import io.lettuce.core.RedisChannelHandler;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.cluster.AbstractNodeSelection;
import io.lettuce.core.cluster.ClusterConnectionProvider;
import io.lettuce.core.cluster.DynamicNodeSelection;
import io.lettuce.core.cluster.NodeSelectionInvocationHandler;
import io.lettuce.core.cluster.StatefulRedisClusterConnectionImpl;
import io.lettuce.core.cluster.StatefulRedisClusterPubSubConnectionImpl;
import io.lettuce.core.cluster.StaticNodeSelection;
import io.lettuce.core.cluster.api.NodeSelectionSupport;
import io.lettuce.core.cluster.api.StatefulRedisClusterConnection;
import io.lettuce.core.cluster.api.sync.RedisClusterCommands;
import io.lettuce.core.cluster.models.partitions.RedisClusterNode;
import io.lettuce.core.internal.AbstractInvocationHandler;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;

class ClusterFutureSyncInvocationHandler<K, V>
extends AbstractInvocationHandler {
    private final StatefulConnection<K, V> connection;
    private final Class<?> asyncCommandsInterface;
    private final Class<?> nodeSelectionInterface;
    private final Class<?> nodeSelectionCommandsInterface;
    private final Object asyncApi;
    private final Map<Method, Method> apiMethodCache = new ConcurrentHashMap<Method, Method>(RedisClusterCommands.class.getMethods().length, 1.0f);
    private final Map<Method, Method> connectionMethodCache = new ConcurrentHashMap<Method, Method>(5, 1.0f);
    private static final Constructor<MethodHandles.Lookup> LOOKUP_CONSTRUCTOR;

    ClusterFutureSyncInvocationHandler(StatefulConnection<K, V> connection, Class<?> asyncCommandsInterface, Class<?> nodeSelectionInterface, Class<?> nodeSelectionCommandsInterface, Object asyncApi) {
        this.connection = connection;
        this.asyncCommandsInterface = asyncCommandsInterface;
        this.nodeSelectionInterface = nodeSelectionInterface;
        this.nodeSelectionCommandsInterface = nodeSelectionCommandsInterface;
        this.asyncApi = asyncApi;
    }

    @Override
    protected Object handleInvocation(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            Object result;
            Method targetMethod;
            if (method.isDefault()) {
                return ClusterFutureSyncInvocationHandler.getDefaultMethodHandle(method).bindTo(proxy).invokeWithArguments(args);
            }
            if (method.getName().equals("getConnection") && args.length > 0) {
                targetMethod = this.connectionMethodCache.computeIfAbsent(method, key -> {
                    try {
                        return this.connection.getClass().getMethod(key.getName(), key.getParameterTypes());
                    }
                    catch (NoSuchMethodException e) {
                        throw new IllegalStateException(e);
                    }
                });
                result = targetMethod.invoke(this.connection, args);
                if (result instanceof StatefulRedisClusterConnection) {
                    StatefulRedisClusterConnection connection = (StatefulRedisClusterConnection)result;
                    return connection.sync();
                }
                if (result instanceof StatefulRedisConnection) {
                    StatefulRedisConnection connection = (StatefulRedisConnection)result;
                    return connection.sync();
                }
            }
            if (method.getName().equals("readonly") && args.length == 1) {
                return this.nodes((Predicate)args[0], ClusterConnectionProvider.Intent.READ, false);
            }
            if (method.getName().equals("nodes") && args.length == 1) {
                return this.nodes((Predicate)args[0], ClusterConnectionProvider.Intent.WRITE, false);
            }
            if (method.getName().equals("nodes") && args.length == 2) {
                return this.nodes((Predicate)args[0], ClusterConnectionProvider.Intent.WRITE, (Boolean)args[1]);
            }
            targetMethod = this.apiMethodCache.computeIfAbsent(method, key -> {
                try {
                    return this.asyncApi.getClass().getMethod(key.getName(), key.getParameterTypes());
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalStateException(e);
                }
            });
            result = targetMethod.invoke(this.asyncApi, args);
            if (result instanceof RedisFuture) {
                RedisFuture command = (RedisFuture)result;
                if (!method.getName().equals("exec") && !method.getName().equals("multi") && this.connection instanceof StatefulRedisConnection && ((StatefulRedisConnection)this.connection).isMulti()) {
                    return null;
                }
                return LettuceFutures.awaitOrCancel(command, this.connection.getTimeout(), this.connection.getTimeoutUnit());
            }
            return result;
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    protected Object nodes(Predicate<RedisClusterNode> predicate, ClusterConnectionProvider.Intent intent, boolean dynamic) {
        RedisChannelHandler impl;
        AbstractNodeSelection selection = null;
        if (this.connection instanceof StatefulRedisClusterConnectionImpl) {
            impl = (StatefulRedisClusterConnectionImpl)this.connection;
            selection = dynamic ? new DynamicNodeSelection(((StatefulRedisClusterConnectionImpl)impl).getClusterDistributionChannelWriter(), predicate, intent, StatefulRedisConnection::sync) : new StaticNodeSelection(((StatefulRedisClusterConnectionImpl)impl).getClusterDistributionChannelWriter(), predicate, intent, StatefulRedisConnection::sync);
        }
        if (this.connection instanceof StatefulRedisClusterPubSubConnectionImpl) {
            impl = (StatefulRedisClusterPubSubConnectionImpl)this.connection;
            selection = new StaticNodeSelection(((StatefulRedisClusterPubSubConnectionImpl)impl).getClusterDistributionChannelWriter(), predicate, intent, StatefulRedisConnection::sync);
        }
        NodeSelectionInvocationHandler h = new NodeSelectionInvocationHandler(selection, this.asyncCommandsInterface, this.connection.getTimeout(), this.connection.getTimeoutUnit());
        return Proxy.newProxyInstance(NodeSelectionSupport.class.getClassLoader(), new Class[]{this.nodeSelectionCommandsInterface, this.nodeSelectionInterface}, (InvocationHandler)h);
    }

    private static MethodHandle getDefaultMethodHandle(Method method) {
        Class<?> declaringClass = method.getDeclaringClass();
        try {
            if (LOOKUP_CONSTRUCTOR.isAccessible()) {
                MethodHandles.Lookup result = LOOKUP_CONSTRUCTOR.newInstance(declaringClass, 2);
                return result.unreflectSpecial(method, declaringClass);
            }
            return MethodHandles.lookup().findSpecial(method.getDeclaringClass(), method.getName(), MethodType.methodType(method.getReturnType(), method.getParameterTypes()), method.getDeclaringClass());
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException("Did not pass in an interface method: " + method, e);
        }
    }

    static {
        try {
            LOOKUP_CONSTRUCTOR = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class, Integer.TYPE);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        try {
            if (!LOOKUP_CONSTRUCTOR.isAccessible()) {
                LOOKUP_CONSTRUCTOR.setAccessible(true);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

