/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.cluster;

import io.lettuce.core.cluster.api.reactive.ReactiveExecutions;
import io.lettuce.core.cluster.models.partitions.RedisClusterNode;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class ReactiveExecutionsImpl<T>
implements ReactiveExecutions<T> {
    private Map<RedisClusterNode, CompletableFuture<? extends Publisher<T>>> executions;

    public ReactiveExecutionsImpl(Map<RedisClusterNode, CompletableFuture<? extends Publisher<T>>> executions) {
        this.executions = executions;
    }

    @Override
    public Flux<T> flux() {
        return Flux.fromIterable(this.executions.values()).flatMap(Mono::fromCompletionStage).flatMap(f -> f);
    }

    @Override
    public Collection<RedisClusterNode> nodes() {
        return this.executions.keySet();
    }
}

