/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.dynamic;

import io.lettuce.core.LettuceFutures;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.dynamic.CommandFactory;
import io.lettuce.core.dynamic.CommandMethod;
import io.lettuce.core.dynamic.ExecutableCommand;
import io.lettuce.core.dynamic.domain.Timeout;
import io.lettuce.core.dynamic.parameter.ExecutionSpecificParameters;
import io.lettuce.core.protocol.AsyncCommand;
import io.lettuce.core.protocol.RedisCommand;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

class AsyncExecutableCommand
implements ExecutableCommand {
    private final CommandMethod commandMethod;
    private final CommandFactory commandFactory;
    private final StatefulConnection<Object, Object> connection;

    AsyncExecutableCommand(CommandMethod commandMethod, CommandFactory commandFactory, StatefulConnection<Object, Object> connection) {
        this.commandMethod = commandMethod;
        this.commandFactory = commandFactory;
        this.connection = connection;
    }

    @Override
    public Object execute(Object[] parameters) throws ExecutionException, InterruptedException {
        RedisCommand<Object, Object, Object> command = this.commandFactory.createCommand(parameters);
        return this.dispatchCommand(parameters, command);
    }

    protected Object dispatchCommand(Object[] arguments, RedisCommand<Object, Object, Object> command) throws InterruptedException, ExecutionException {
        Timeout timeoutArg;
        ExecutionSpecificParameters executionSpecificParameters;
        AsyncCommand<Object, Object, Object> asyncCommand = new AsyncCommand<Object, Object, Object>(command);
        if (this.commandMethod.isFutureExecution()) {
            return this.connection.dispatch(asyncCommand);
        }
        this.connection.dispatch(asyncCommand);
        long timeout = this.connection.getTimeout();
        TimeUnit unit = this.connection.getTimeoutUnit();
        if (this.commandMethod.getParameters() instanceof ExecutionSpecificParameters && (executionSpecificParameters = (ExecutionSpecificParameters)this.commandMethod.getParameters()).hasTimeoutIndex() && (timeoutArg = (Timeout)arguments[executionSpecificParameters.getTimeoutIndex()]) != null) {
            timeout = timeoutArg.getTimeout();
            unit = timeoutArg.getTimeUnit();
        }
        LettuceFutures.awaitAll(timeout, unit, asyncCommand);
        return asyncCommand.get();
    }

    @Override
    public CommandMethod getCommandMethod() {
        return this.commandMethod;
    }
}

