/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.dynamic;

import io.lettuce.core.LettuceFutures;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.dynamic.BatchTasks;
import io.lettuce.core.dynamic.Batcher;
import io.lettuce.core.dynamic.CommandFactory;
import io.lettuce.core.dynamic.CommandMethod;
import io.lettuce.core.dynamic.ExecutableCommand;
import io.lettuce.core.dynamic.batch.BatchException;
import io.lettuce.core.dynamic.batch.CommandBatching;
import io.lettuce.core.dynamic.parameter.ExecutionSpecificParameters;
import io.lettuce.core.protocol.AsyncCommand;
import io.lettuce.core.protocol.RedisCommand;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

class BatchExecutableCommand
implements ExecutableCommand {
    private final CommandMethod commandMethod;
    private final CommandFactory commandFactory;
    private final Batcher batcher;
    private final StatefulConnection<Object, Object> connection;
    private final ExecutionSpecificParameters parameters;
    private final boolean async;

    BatchExecutableCommand(CommandMethod commandMethod, CommandFactory commandFactory, Batcher batcher, StatefulConnection<Object, Object> connection) {
        this.commandMethod = commandMethod;
        this.commandFactory = commandFactory;
        this.batcher = batcher;
        this.parameters = (ExecutionSpecificParameters)commandMethod.getParameters();
        this.async = commandMethod.isFutureExecution();
        this.connection = connection;
    }

    @Override
    public Object execute(Object[] parameters) throws ExecutionException, InterruptedException {
        RedisCommand<Object, Object, Object> command = this.commandFactory.createCommand(parameters);
        CommandBatching batching = null;
        if (this.parameters.hasCommandBatchingIndex()) {
            batching = (CommandBatching)parameters[this.parameters.getCommandBatchingIndex()];
        }
        AsyncCommand<Object, Object, Object> asyncCommand = new AsyncCommand<Object, Object, Object>(command);
        if (this.async) {
            this.batcher.batch(asyncCommand, batching);
            return asyncCommand;
        }
        BatchTasks batchTasks = this.batcher.batch(asyncCommand, batching);
        return BatchExecutableCommand.synchronize(batchTasks, this.connection);
    }

    protected static Object synchronize(BatchTasks batchTasks, StatefulConnection<Object, Object> connection) {
        if (batchTasks == BatchTasks.EMPTY) {
            return null;
        }
        long timeout = connection.getTimeout();
        TimeUnit unit = connection.getTimeoutUnit();
        Throwable exception = null;
        ArrayList failures = null;
        for (RedisCommand<?, ?, ?> batchTask : batchTasks) {
            try {
                LettuceFutures.awaitAll(timeout, unit, (RedisFuture)((Object)batchTask));
            }
            catch (Exception e) {
                if (exception == null) {
                    failures = new ArrayList();
                    exception = new BatchException(failures);
                }
                failures.add(batchTask);
                exception.addSuppressed(e);
            }
        }
        if (exception != null) {
            throw exception;
        }
        return null;
    }

    @Override
    public CommandMethod getCommandMethod() {
        return this.commandMethod;
    }
}

