/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.internal;

import io.lettuce.core.internal.ForwardingDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.Predicate;

public class FastCountingDeque<E>
extends ForwardingDeque<E>
implements Deque<E> {
    private static final AtomicIntegerFieldUpdater<FastCountingDeque> UPDATER = AtomicIntegerFieldUpdater.newUpdater(FastCountingDeque.class, "count");
    private volatile int count = 0;

    public FastCountingDeque(Deque<E> delegate) {
        super(delegate);
    }

    @Override
    public void addFirst(E e) {
        this.increment();
        super.addFirst(e);
    }

    @Override
    public void addLast(E e) {
        this.increment();
        super.addLast(e);
    }

    @Override
    public boolean offerFirst(E e) {
        if (super.offerFirst(e)) {
            this.increment();
            return true;
        }
        return false;
    }

    @Override
    public boolean offerLast(E e) {
        if (super.offerLast(e)) {
            this.increment();
            return true;
        }
        return false;
    }

    @Override
    public E removeFirst() {
        Object element = super.removeFirst();
        if (element != null) {
            this.decrement();
        }
        return element;
    }

    @Override
    public E removeLast() {
        Object element = super.removeLast();
        if (element != null) {
            this.decrement();
        }
        return element;
    }

    @Override
    public E pollFirst() {
        Object element = super.pollFirst();
        if (element != null) {
            this.decrement();
        }
        return element;
    }

    @Override
    public E pollLast() {
        Object element = super.pollLast();
        if (element != null) {
            this.decrement();
        }
        return element;
    }

    @Override
    public E getFirst() {
        return super.getFirst();
    }

    @Override
    public E getLast() {
        return super.getLast();
    }

    @Override
    public E peekFirst() {
        return super.peekFirst();
    }

    @Override
    public E peekLast() {
        return super.peekLast();
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        if (super.removeFirstOccurrence(o)) {
            this.decrement();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        if (super.removeLastOccurrence(o)) {
            this.decrement();
            return true;
        }
        return false;
    }

    @Override
    public boolean add(E e) {
        if (super.add(e)) {
            this.increment();
            return true;
        }
        return false;
    }

    @Override
    public boolean offer(E e) {
        if (super.offer(e)) {
            this.increment();
            return true;
        }
        return false;
    }

    @Override
    public E remove() {
        Object element = super.remove();
        if (element != null) {
            this.decrement();
        }
        return element;
    }

    @Override
    public E poll() {
        Object element = super.poll();
        if (element != null) {
            this.decrement();
        }
        return element;
    }

    @Override
    public E element() {
        return super.element();
    }

    @Override
    public E peek() {
        return super.peek();
    }

    @Override
    public void push(E e) {
        super.push(e);
        this.increment();
    }

    @Override
    public E pop() {
        Object element = super.pop();
        if (element != null) {
            this.decrement();
        }
        return element;
    }

    @Override
    public boolean remove(Object o) {
        if (super.remove(o)) {
            this.decrement();
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Object o) {
        return super.contains(o);
    }

    @Override
    public int size() {
        return UPDATER.get(this);
    }

    @Override
    public Iterator<E> iterator() {
        return new UnmodifiableIterator(super.iterator());
    }

    @Override
    public Iterator<E> descendingIterator() {
        return new UnmodifiableIterator(super.descendingIterator());
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty();
    }

    @Override
    public Object[] toArray() {
        return super.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return super.toArray(a);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return super.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean state = super.addAll(c);
        this.count = super.size();
        return state;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean state = super.removeAll(c);
        this.count = super.size();
        return state;
    }

    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        boolean state = super.removeIf(filter);
        this.count = super.size();
        return state;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean state = super.retainAll(c);
        this.count = super.size();
        return state;
    }

    @Override
    public void clear() {
        super.clear();
        UPDATER.set(this, 0);
    }

    protected void increment() {
        assert (UPDATER.incrementAndGet(this) > 0);
    }

    protected void decrement() {
        assert (UPDATER.decrementAndGet(this) >= 0);
    }

    private static class UnmodifiableIterator<E>
    implements Iterator<E> {
        private final Iterator<E> delegate;

        public UnmodifiableIterator(Iterator<E> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public E next() {
            return this.delegate.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

