/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.masterslave;

import io.lettuce.core.LettuceFutures;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisCommandInterruptedException;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.RedisURI;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.masterslave.RedisMasterSlaveNode;
import io.lettuce.core.masterslave.TopologyProvider;
import io.lettuce.core.models.role.RedisInstance;
import io.lettuce.core.models.role.RedisNodeDescription;
import io.lettuce.core.models.role.RoleParser;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class StaticMasterSlaveTopologyProvider
implements TopologyProvider {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(StaticMasterSlaveTopologyProvider.class);
    private final RedisClient redisClient;
    private final Iterable<RedisURI> redisURIs;

    public StaticMasterSlaveTopologyProvider(RedisClient redisClient, Iterable<RedisURI> redisURIs) {
        LettuceAssert.notNull(redisClient, "RedisClient must not be null");
        LettuceAssert.notNull(redisURIs, "RedisURIs must not be null");
        LettuceAssert.notNull(redisURIs.iterator().hasNext(), "RedisURIs must not be empty");
        this.redisClient = redisClient;
        this.redisURIs = redisURIs;
    }

    @Override
    public List<RedisNodeDescription> getNodes() {
        ArrayList<StatefulRedisConnection<String, String>> connections = new ArrayList<StatefulRedisConnection<String, String>>();
        HashMap<RedisURI, RedisFuture<List<Object>>> roles = new HashMap<RedisURI, RedisFuture<List<Object>>>();
        try {
            for (RedisURI redisURI : this.redisURIs) {
                try {
                    StatefulRedisConnection<String, String> connection = this.redisClient.connect(redisURI);
                    connections.add(connection);
                    roles.put(redisURI, connection.async().role());
                }
                catch (RuntimeException e) {
                    logger.warn("Cannot connect to {}", (Object)redisURI, (Object)e);
                }
            }
            RedisURI next = this.redisURIs.iterator().next();
            boolean success = LettuceFutures.awaitAll(next.getTimeout(), next.getUnit(), roles.values().toArray(new Future[roles.size()]));
            if (success) {
                ArrayList<RedisMasterSlaveNode> result = new ArrayList<RedisMasterSlaveNode>();
                for (Map.Entry entry : roles.entrySet()) {
                    if (!((RedisFuture)entry.getValue()).isDone()) continue;
                    RedisURI key = (RedisURI)entry.getKey();
                    RedisInstance redisInstance = RoleParser.parse((List)((RedisFuture)entry.getValue()).get());
                    result.add(new RedisMasterSlaveNode(key.getHost(), key.getPort(), key, redisInstance.getRole()));
                }
                ArrayList<RedisMasterSlaveNode> arrayList = result;
                return arrayList;
            }
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RedisCommandInterruptedException(e);
        }
        finally {
            for (StatefulRedisConnection statefulRedisConnection : connections) {
                statefulRedisConnection.close();
            }
        }
        return Collections.emptyList();
    }
}

