/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.output;

import io.lettuce.core.ScoredValue;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.output.CommandOutput;
import io.lettuce.core.output.ListSubscriber;
import io.lettuce.core.output.StreamingOutput;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class ScoredValueListOutput<K, V>
extends CommandOutput<K, V, List<ScoredValue<V>>>
implements StreamingOutput<ScoredValue<V>> {
    private V value;
    private StreamingOutput.Subscriber<ScoredValue<V>> subscriber;

    public ScoredValueListOutput(RedisCodec<K, V> codec) {
        super(codec, new ArrayList());
        this.setSubscriber((StreamingOutput.Subscriber<ScoredValue<V>>)ListSubscriber.of((List)this.output));
    }

    @Override
    public void set(ByteBuffer bytes) {
        if (this.value == null) {
            this.value = this.codec.decodeValue(bytes);
            return;
        }
        double score = Double.parseDouble(this.decodeAscii(bytes));
        this.subscriber.onNext(ScoredValue.fromNullable(score, this.value));
        this.value = null;
    }

    @Override
    public void setSubscriber(StreamingOutput.Subscriber<ScoredValue<V>> subscriber) {
        LettuceAssert.notNull(subscriber, "Subscriber must not be null");
        this.subscriber = subscriber;
    }

    @Override
    public StreamingOutput.Subscriber<ScoredValue<V>> getSubscriber() {
        return this.subscriber;
    }
}

