/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.pubsub;

import io.lettuce.core.RedisChannelWriter;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.StatefulRedisConnectionImpl;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.pubsub.PubSubEndpoint;
import io.lettuce.core.pubsub.RedisPubSubAsyncCommandsImpl;
import io.lettuce.core.pubsub.RedisPubSubListener;
import io.lettuce.core.pubsub.RedisPubSubReactiveCommandsImpl;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import io.lettuce.core.pubsub.api.async.RedisPubSubAsyncCommands;
import io.lettuce.core.pubsub.api.reactive.RedisPubSubReactiveCommands;
import io.lettuce.core.pubsub.api.sync.RedisPubSubCommands;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class StatefulRedisPubSubConnectionImpl<K, V>
extends StatefulRedisConnectionImpl<K, V>
implements StatefulRedisPubSubConnection<K, V> {
    private final PubSubEndpoint<K, V> endpoint;

    public StatefulRedisPubSubConnectionImpl(PubSubEndpoint<K, V> endpoint, RedisChannelWriter writer, RedisCodec<K, V> codec, long timeout, TimeUnit unit) {
        super(writer, codec, timeout, unit);
        this.endpoint = endpoint;
    }

    @Override
    public void addListener(RedisPubSubListener<K, V> listener) {
        this.endpoint.addListener(listener);
    }

    @Override
    public void removeListener(RedisPubSubListener<K, V> listener) {
        this.endpoint.removeListener(listener);
    }

    @Override
    public RedisPubSubAsyncCommands<K, V> async() {
        return (RedisPubSubAsyncCommands)((Object)this.async);
    }

    @Override
    protected RedisPubSubAsyncCommandsImpl<K, V> newRedisAsyncCommandsImpl() {
        return new RedisPubSubAsyncCommandsImpl(this, this.codec);
    }

    @Override
    public RedisPubSubCommands<K, V> sync() {
        return (RedisPubSubCommands)this.sync;
    }

    @Override
    protected RedisPubSubCommands<K, V> newRedisSyncCommandsImpl() {
        return (RedisPubSubCommands)this.syncHandler(this.async(), RedisPubSubCommands.class);
    }

    @Override
    public RedisPubSubReactiveCommands<K, V> reactive() {
        return (RedisPubSubReactiveCommands)((Object)this.reactive);
    }

    @Override
    protected RedisPubSubReactiveCommandsImpl<K, V> newRedisReactiveCommandsImpl() {
        return new RedisPubSubReactiveCommandsImpl(this, this.codec);
    }

    protected List<RedisFuture<Void>> resubscribe() {
        ArrayList<RedisFuture<Void>> result = new ArrayList<RedisFuture<Void>>();
        if (!this.endpoint.getChannels().isEmpty()) {
            result.add(this.async().subscribe(this.toArray(this.endpoint.getChannels())));
        }
        if (!this.endpoint.getPatterns().isEmpty()) {
            result.add(this.async().psubscribe(this.toArray(this.endpoint.getPatterns())));
        }
        return result;
    }

    private <T> T[] toArray(Collection<T> c) {
        Class<?> cls = c.iterator().next().getClass();
        Object[] array = (Object[])Array.newInstance(cls, c.size());
        return c.toArray(array);
    }

    @Override
    public void activated() {
        super.activated();
        this.resubscribe();
    }
}

