/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.resource;

import io.lettuce.core.resource.Delay;
import java.util.concurrent.TimeUnit;

class ExponentialDelay
extends Delay {
    private final long lower;
    private final long upper;
    private final int powersOf;

    ExponentialDelay(long lower, long upper, TimeUnit unit, int powersOf) {
        super(unit);
        this.lower = lower;
        this.upper = upper;
        this.powersOf = powersOf;
    }

    @Override
    public long createDelay(long attempt) {
        long delay = attempt <= 0L ? 0L : (this.powersOf == 2 ? ExponentialDelay.calculatePowerOfTwo(attempt) : this.calculateAlternatePower(attempt));
        return this.applyBounds(delay);
    }

    protected long applyBounds(long delay) {
        return ExponentialDelay.applyBounds(delay, this.lower, this.upper);
    }

    private long calculateAlternatePower(long attempt) {
        double step = Math.pow(this.powersOf, attempt - 1L);
        return Math.round(step);
    }

    protected static long calculatePowerOfTwo(long attempt) {
        if (attempt <= 0L) {
            return 0L;
        }
        if (attempt >= 64L) {
            return Long.MAX_VALUE;
        }
        return 1L << (int)(attempt - 1L);
    }
}

