/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.output;

import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.output.CommandOutput;
import io.lettuce.core.output.ListSubscriber;
import io.lettuce.core.output.StreamingOutput;
import java.util.ArrayList;
import java.util.List;

public class BooleanListOutput<K, V>
extends CommandOutput<K, V, List<Boolean>>
implements StreamingOutput<Boolean> {
    private StreamingOutput.Subscriber<Boolean> subscriber;

    public BooleanListOutput(RedisCodec<K, V> codec) {
        super(codec, new ArrayList());
        this.setSubscriber((StreamingOutput.Subscriber<Boolean>)ListSubscriber.of((List)this.output));
    }

    @Override
    public void set(long integer) {
        this.subscriber.onNext(integer == 1L ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void setSubscriber(StreamingOutput.Subscriber<Boolean> subscriber) {
        LettuceAssert.notNull(subscriber, "Subscriber must not be null");
        this.subscriber = subscriber;
    }

    @Override
    public StreamingOutput.Subscriber<Boolean> getSubscriber() {
        return this.subscriber;
    }
}

