/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.output;

import io.lettuce.core.GeoCoordinates;
import io.lettuce.core.GeoWithin;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.output.CommandOutput;
import io.lettuce.core.output.ListSubscriber;
import io.lettuce.core.output.StreamingOutput;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class GeoWithinListOutput<K, V>
extends CommandOutput<K, V, List<GeoWithin<V>>>
implements StreamingOutput<GeoWithin<V>> {
    private V member;
    private Double distance;
    private Long geohash;
    private GeoCoordinates coordinates;
    private Double x;
    private boolean withDistance;
    private boolean withHash;
    private boolean withCoordinates;
    private StreamingOutput.Subscriber<GeoWithin<V>> subscriber;

    public GeoWithinListOutput(RedisCodec<K, V> codec, boolean withDistance, boolean withHash, boolean withCoordinates) {
        super(codec, new ArrayList());
        this.withDistance = withDistance;
        this.withHash = withHash;
        this.withCoordinates = withCoordinates;
        this.setSubscriber((StreamingOutput.Subscriber<GeoWithin<V>>)ListSubscriber.of((List)this.output));
    }

    @Override
    public void set(long integer) {
        if (this.member == null) {
            this.member = integer;
            return;
        }
        if (this.withHash) {
            this.geohash = integer;
        }
    }

    @Override
    public void set(ByteBuffer bytes) {
        if (this.member == null) {
            this.member = this.codec.decodeValue(bytes);
            return;
        }
        Double value = bytes == null ? 0.0 : Double.parseDouble(this.decodeAscii(bytes));
        if (this.withDistance && this.distance == null) {
            this.distance = value;
            return;
        }
        if (this.withCoordinates) {
            if (this.x == null) {
                this.x = value;
                return;
            }
            this.coordinates = new GeoCoordinates(this.x, value);
            return;
        }
    }

    @Override
    public void complete(int depth) {
        if (depth == 1) {
            this.subscriber.onNext(new GeoWithin<V>(this.member, this.distance, this.geohash, this.coordinates));
            this.member = null;
            this.distance = null;
            this.geohash = null;
            this.coordinates = null;
        }
    }

    @Override
    public void setSubscriber(StreamingOutput.Subscriber<GeoWithin<V>> subscriber) {
        LettuceAssert.notNull(subscriber, "Subscriber must not be null");
        this.subscriber = subscriber;
    }

    @Override
    public StreamingOutput.Subscriber<GeoWithin<V>> getSubscriber() {
        return this.subscriber;
    }
}

