/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.output;

import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.output.CommandOutput;
import io.lettuce.core.output.ListSubscriber;
import io.lettuce.core.output.StreamingOutput;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class StringListOutput<K, V>
extends CommandOutput<K, V, List<String>>
implements StreamingOutput<String> {
    private StreamingOutput.Subscriber<String> subscriber;

    public StringListOutput(RedisCodec<K, V> codec) {
        super(codec, new ArrayList());
        this.setSubscriber((StreamingOutput.Subscriber<String>)ListSubscriber.of((List)this.output));
    }

    @Override
    public void set(ByteBuffer bytes) {
        this.subscriber.onNext(bytes == null ? null : this.decodeAscii(bytes));
    }

    @Override
    public void setSubscriber(StreamingOutput.Subscriber<String> subscriber) {
        LettuceAssert.notNull(subscriber, "Subscriber must not be null");
        this.subscriber = subscriber;
    }

    @Override
    public StreamingOutput.Subscriber<String> getSubscriber() {
        return this.subscriber;
    }
}

