/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.resource;

import io.lettuce.core.event.DefaultEventBus;
import io.lettuce.core.event.DefaultEventPublisherOptions;
import io.lettuce.core.event.EventBus;
import io.lettuce.core.event.EventPublisherOptions;
import io.lettuce.core.event.metrics.DefaultCommandLatencyEventPublisher;
import io.lettuce.core.event.metrics.MetricEventPublisher;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.internal.LettuceLists;
import io.lettuce.core.metrics.CommandLatencyCollector;
import io.lettuce.core.metrics.CommandLatencyCollectorOptions;
import io.lettuce.core.metrics.DefaultCommandLatencyCollector;
import io.lettuce.core.metrics.DefaultCommandLatencyCollectorOptions;
import io.lettuce.core.resource.ClientResources;
import io.lettuce.core.resource.DefaultEventLoopGroupProvider;
import io.lettuce.core.resource.DefaultNettyCustomizer;
import io.lettuce.core.resource.Delay;
import io.lettuce.core.resource.DnsResolver;
import io.lettuce.core.resource.DnsResolvers;
import io.lettuce.core.resource.EventLoopGroupProvider;
import io.lettuce.core.resource.Futures;
import io.lettuce.core.resource.NettyCustomizer;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timer;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import reactor.core.scheduler.Schedulers;

public class DefaultClientResources
implements ClientResources {
    protected static final InternalLogger logger;
    public static final int MIN_IO_THREADS = 3;
    public static final int MIN_COMPUTATION_THREADS = 3;
    public static final int DEFAULT_IO_THREADS;
    public static final int DEFAULT_COMPUTATION_THREADS;
    public static final Supplier<Delay> DEFAULT_RECONNECT_DELAY;
    public static final NettyCustomizer DEFAULT_NETTY_CUSTOMIZER;
    private final boolean sharedEventLoopGroupProvider;
    private final EventLoopGroupProvider eventLoopGroupProvider;
    private final boolean sharedEventExecutor;
    private final EventExecutorGroup eventExecutorGroup;
    private final Timer timer;
    private final boolean sharedTimer;
    private final EventBus eventBus;
    private final CommandLatencyCollector commandLatencyCollector;
    private final boolean sharedCommandLatencyCollector;
    private final EventPublisherOptions commandLatencyPublisherOptions;
    private final MetricEventPublisher metricEventPublisher;
    private final DnsResolver dnsResolver;
    private final Supplier<Delay> reconnectDelay;
    private final NettyCustomizer nettyCustomizer;
    private volatile boolean shutdownCalled = false;

    protected DefaultClientResources(Builder builder) {
        if (builder.eventLoopGroupProvider == null) {
            int ioThreadPoolSize = builder.ioThreadPoolSize;
            if (ioThreadPoolSize < 3) {
                logger.info("ioThreadPoolSize is less than {} ({}), setting to: {}", new Object[]{3, ioThreadPoolSize, 3});
                ioThreadPoolSize = 3;
            }
            this.sharedEventLoopGroupProvider = false;
            this.eventLoopGroupProvider = new DefaultEventLoopGroupProvider(ioThreadPoolSize);
        } else {
            this.sharedEventLoopGroupProvider = true;
            this.eventLoopGroupProvider = builder.eventLoopGroupProvider;
        }
        if (builder.eventExecutorGroup == null) {
            int computationThreadPoolSize = builder.computationThreadPoolSize;
            if (computationThreadPoolSize < 3) {
                logger.info("computationThreadPoolSize is less than {} ({}), setting to: {}", new Object[]{3, computationThreadPoolSize, 3});
                computationThreadPoolSize = 3;
            }
            this.eventExecutorGroup = DefaultEventLoopGroupProvider.createEventLoopGroup(DefaultEventExecutorGroup.class, computationThreadPoolSize);
            this.sharedEventExecutor = false;
        } else {
            this.sharedEventExecutor = true;
            this.eventExecutorGroup = builder.eventExecutorGroup;
        }
        if (builder.timer == null) {
            this.timer = new HashedWheelTimer((ThreadFactory)new DefaultThreadFactory("lettuce-timer"));
            this.sharedTimer = false;
        } else {
            this.timer = builder.timer;
            this.sharedTimer = true;
        }
        this.eventBus = builder.eventBus == null ? new DefaultEventBus(Schedulers.fromExecutor((Executor)this.eventExecutorGroup)) : builder.eventBus;
        if (builder.commandLatencyCollector == null) {
            if (DefaultCommandLatencyCollector.isAvailable()) {
                this.commandLatencyCollector = builder.commandLatencyCollectorOptions != null ? new DefaultCommandLatencyCollector(builder.commandLatencyCollectorOptions) : new DefaultCommandLatencyCollector(DefaultCommandLatencyCollectorOptions.create());
            } else {
                logger.debug("LatencyUtils/HdrUtils are not available, metrics are disabled");
                builder.commandLatencyCollectorOptions = DefaultCommandLatencyCollectorOptions.disabled();
                this.commandLatencyCollector = DefaultCommandLatencyCollector.disabled();
            }
            this.sharedCommandLatencyCollector = false;
        } else {
            this.sharedCommandLatencyCollector = true;
            this.commandLatencyCollector = builder.commandLatencyCollector;
        }
        this.commandLatencyPublisherOptions = builder.commandLatencyPublisherOptions;
        this.metricEventPublisher = this.commandLatencyCollector.isEnabled() && this.commandLatencyPublisherOptions != null ? new DefaultCommandLatencyEventPublisher(this.eventExecutorGroup, this.commandLatencyPublisherOptions, this.eventBus, this.commandLatencyCollector) : null;
        this.dnsResolver = builder.dnsResolver == null ? DnsResolvers.UNRESOLVED : builder.dnsResolver;
        this.reconnectDelay = builder.reconnectDelay;
        this.nettyCustomizer = builder.nettyCustomizer;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static DefaultClientResources create() {
        return DefaultClientResources.builder().build();
    }

    protected void finalize() throws Throwable {
        if (!this.shutdownCalled) {
            logger.warn(this.getClass().getName() + " was not shut down properly, shutdown() was not called before it's garbage-collected. Call shutdown() or shutdown(long,long,TimeUnit) ");
        }
        super.finalize();
    }

    @Override
    public Future<Boolean> shutdown() {
        return this.shutdown(2L, 15L, TimeUnit.SECONDS);
    }

    @Override
    public Future<Boolean> shutdown(long quietPeriod, long timeout, TimeUnit timeUnit) {
        Future shutdown;
        this.shutdownCalled = true;
        DefaultPromise overall = new DefaultPromise((EventExecutor)GlobalEventExecutor.INSTANCE);
        DefaultPromise lastRelease = new DefaultPromise((EventExecutor)GlobalEventExecutor.INSTANCE);
        Futures.PromiseAggregator aggregator = new Futures.PromiseAggregator(overall);
        aggregator.expectMore(1);
        if (!this.sharedEventLoopGroupProvider) {
            aggregator.expectMore(1);
        }
        if (!this.sharedEventExecutor) {
            aggregator.expectMore(1);
        }
        aggregator.arm();
        if (this.metricEventPublisher != null) {
            this.metricEventPublisher.shutdown();
        }
        if (!this.sharedTimer) {
            this.timer.stop();
        }
        if (!this.sharedEventLoopGroupProvider) {
            shutdown = this.eventLoopGroupProvider.shutdown(quietPeriod, timeout, timeUnit);
            if (shutdown instanceof Promise) {
                aggregator.add((Promise)shutdown);
            } else {
                aggregator.add(Futures.toBooleanPromise(shutdown));
            }
        }
        if (!this.sharedEventExecutor) {
            shutdown = this.eventExecutorGroup.shutdownGracefully(quietPeriod, timeout, timeUnit);
            aggregator.add(Futures.toBooleanPromise(shutdown));
        }
        if (!this.sharedCommandLatencyCollector) {
            this.commandLatencyCollector.shutdown();
        }
        aggregator.add(new Promise[]{lastRelease});
        lastRelease.setSuccess(null);
        return Futures.toBooleanPromise(overall);
    }

    @Override
    public EventLoopGroupProvider eventLoopGroupProvider() {
        return this.eventLoopGroupProvider;
    }

    @Override
    public EventExecutorGroup eventExecutorGroup() {
        return this.eventExecutorGroup;
    }

    @Override
    public int ioThreadPoolSize() {
        return this.eventLoopGroupProvider.threadPoolSize();
    }

    @Override
    public int computationThreadPoolSize() {
        return LettuceLists.newList(this.eventExecutorGroup.iterator()).size();
    }

    @Override
    public EventBus eventBus() {
        return this.eventBus;
    }

    @Override
    public Timer timer() {
        return this.timer;
    }

    @Override
    public CommandLatencyCollector commandLatencyCollector() {
        return this.commandLatencyCollector;
    }

    @Override
    public EventPublisherOptions commandLatencyPublisherOptions() {
        return this.commandLatencyPublisherOptions;
    }

    @Override
    public DnsResolver dnsResolver() {
        return this.dnsResolver;
    }

    @Override
    public Delay reconnectDelay() {
        return this.reconnectDelay.get();
    }

    @Override
    public NettyCustomizer nettyCustomizer() {
        return this.nettyCustomizer;
    }

    static {
        int threads;
        logger = InternalLoggerFactory.getInstance(DefaultClientResources.class);
        DEFAULT_RECONNECT_DELAY = Delay::exponential;
        DEFAULT_NETTY_CUSTOMIZER = DefaultNettyCustomizer.INSTANCE;
        DEFAULT_IO_THREADS = threads = Math.max(1, SystemPropertyUtil.getInt((String)"io.netty.eventLoopThreads", (int)Math.max(3, Runtime.getRuntime().availableProcessors())));
        DEFAULT_COMPUTATION_THREADS = threads;
        if (logger.isDebugEnabled()) {
            logger.debug("-Dio.netty.eventLoopThreads: {}", (Object)threads);
        }
    }

    public static class Builder {
        private int ioThreadPoolSize = DEFAULT_IO_THREADS;
        private int computationThreadPoolSize = DEFAULT_COMPUTATION_THREADS;
        private EventExecutorGroup eventExecutorGroup;
        private EventLoopGroupProvider eventLoopGroupProvider;
        private Timer timer;
        private EventBus eventBus;
        private CommandLatencyCollectorOptions commandLatencyCollectorOptions = DefaultCommandLatencyCollectorOptions.create();
        private CommandLatencyCollector commandLatencyCollector;
        private EventPublisherOptions commandLatencyPublisherOptions = DefaultEventPublisherOptions.create();
        private DnsResolver dnsResolver = DnsResolvers.UNRESOLVED;
        private Supplier<Delay> reconnectDelay = DEFAULT_RECONNECT_DELAY;
        private NettyCustomizer nettyCustomizer = DEFAULT_NETTY_CUSTOMIZER;

        private Builder() {
        }

        public Builder ioThreadPoolSize(int ioThreadPoolSize) {
            LettuceAssert.isTrue(ioThreadPoolSize > 0, "I/O thread pool size must be greater zero");
            this.ioThreadPoolSize = ioThreadPoolSize;
            return this;
        }

        public Builder eventLoopGroupProvider(EventLoopGroupProvider eventLoopGroupProvider) {
            LettuceAssert.notNull(eventLoopGroupProvider, "EventLoopGroupProvider must not be null");
            this.eventLoopGroupProvider = eventLoopGroupProvider;
            return this;
        }

        public Builder computationThreadPoolSize(int computationThreadPoolSize) {
            LettuceAssert.isTrue(computationThreadPoolSize > 0, "Computation thread pool size must be greater zero");
            this.computationThreadPoolSize = computationThreadPoolSize;
            return this;
        }

        public Builder eventExecutorGroup(EventExecutorGroup eventExecutorGroup) {
            LettuceAssert.notNull(eventExecutorGroup, "EventExecutorGroup must not be null");
            this.eventExecutorGroup = eventExecutorGroup;
            return this;
        }

        public Builder timer(Timer timer) {
            LettuceAssert.notNull(timer, "Timer must not be null");
            this.timer = timer;
            return this;
        }

        public Builder eventBus(EventBus eventBus) {
            LettuceAssert.notNull(eventBus, "EventBus must not be null");
            this.eventBus = eventBus;
            return this;
        }

        public Builder commandLatencyPublisherOptions(EventPublisherOptions commandLatencyPublisherOptions) {
            LettuceAssert.notNull(commandLatencyPublisherOptions, "EventPublisherOptions must not be null");
            this.commandLatencyPublisherOptions = commandLatencyPublisherOptions;
            return this;
        }

        public Builder commandLatencyCollectorOptions(CommandLatencyCollectorOptions commandLatencyCollectorOptions) {
            LettuceAssert.notNull(commandLatencyCollectorOptions, "CommandLatencyCollectorOptions must not be null");
            this.commandLatencyCollectorOptions = commandLatencyCollectorOptions;
            return this;
        }

        public Builder commandLatencyCollector(CommandLatencyCollector commandLatencyCollector) {
            LettuceAssert.notNull(commandLatencyCollector, "CommandLatencyCollector must not be null");
            this.commandLatencyCollector = commandLatencyCollector;
            return this;
        }

        public Builder dnsResolver(DnsResolver dnsResolver) {
            LettuceAssert.notNull(dnsResolver, "DnsResolver must not be null");
            this.dnsResolver = dnsResolver;
            return this;
        }

        public Builder reconnectDelay(Delay reconnectDelay) {
            LettuceAssert.notNull(reconnectDelay, "Delay must not be null");
            LettuceAssert.isTrue(!(reconnectDelay instanceof Delay.StatefulDelay), "Delay must be a stateless instance.");
            return this.reconnectDelay(() -> reconnectDelay);
        }

        public Builder reconnectDelay(Supplier<Delay> reconnectDelay) {
            LettuceAssert.notNull(reconnectDelay, "Delay must not be null");
            this.reconnectDelay = reconnectDelay;
            return this;
        }

        public Builder nettyCustomizer(NettyCustomizer nettyCustomizer) {
            LettuceAssert.notNull(nettyCustomizer, "NettyCustomizer must not be null");
            this.nettyCustomizer = nettyCustomizer;
            return this;
        }

        public DefaultClientResources build() {
            return new DefaultClientResources(this);
        }
    }
}

