/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.BitFieldArgs;
import io.lettuce.core.GeoArgs;
import io.lettuce.core.GeoCoordinates;
import io.lettuce.core.GeoRadiusStoreArgs;
import io.lettuce.core.GeoWithin;
import io.lettuce.core.KeyScanCursor;
import io.lettuce.core.KeyValue;
import io.lettuce.core.KillArgs;
import io.lettuce.core.LettuceStrings;
import io.lettuce.core.Limit;
import io.lettuce.core.MapScanCursor;
import io.lettuce.core.MigrateArgs;
import io.lettuce.core.Range;
import io.lettuce.core.RedisCommandBuilder;
import io.lettuce.core.RedisPublisher;
import io.lettuce.core.ScanArgs;
import io.lettuce.core.ScanCursor;
import io.lettuce.core.ScoredValue;
import io.lettuce.core.ScoredValueScanCursor;
import io.lettuce.core.ScriptOutputType;
import io.lettuce.core.SetArgs;
import io.lettuce.core.SortArgs;
import io.lettuce.core.StreamScanCursor;
import io.lettuce.core.TransactionResult;
import io.lettuce.core.Value;
import io.lettuce.core.ValueScanCursor;
import io.lettuce.core.ZAddArgs;
import io.lettuce.core.ZStoreArgs;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.api.reactive.BaseRedisReactiveCommands;
import io.lettuce.core.api.reactive.RedisGeoReactiveCommands;
import io.lettuce.core.api.reactive.RedisHLLReactiveCommands;
import io.lettuce.core.api.reactive.RedisHashReactiveCommands;
import io.lettuce.core.api.reactive.RedisKeyReactiveCommands;
import io.lettuce.core.api.reactive.RedisListReactiveCommands;
import io.lettuce.core.api.reactive.RedisScriptingReactiveCommands;
import io.lettuce.core.api.reactive.RedisServerReactiveCommands;
import io.lettuce.core.api.reactive.RedisSetReactiveCommands;
import io.lettuce.core.api.reactive.RedisSortedSetReactiveCommands;
import io.lettuce.core.api.reactive.RedisStringReactiveCommands;
import io.lettuce.core.api.reactive.RedisTransactionalReactiveCommands;
import io.lettuce.core.cluster.api.reactive.RedisClusterReactiveCommands;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.output.CommandOutput;
import io.lettuce.core.output.KeyStreamingChannel;
import io.lettuce.core.output.KeyValueStreamingChannel;
import io.lettuce.core.output.ScoredValueStreamingChannel;
import io.lettuce.core.output.ValueStreamingChannel;
import io.lettuce.core.protocol.Command;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CommandType;
import io.lettuce.core.protocol.ProtocolKeyword;
import io.lettuce.core.protocol.RedisCommand;
import java.time.Duration;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class AbstractRedisReactiveCommands<K, V>
implements RedisHashReactiveCommands<K, V>,
RedisKeyReactiveCommands<K, V>,
RedisStringReactiveCommands<K, V>,
RedisListReactiveCommands<K, V>,
RedisSetReactiveCommands<K, V>,
RedisSortedSetReactiveCommands<K, V>,
RedisScriptingReactiveCommands<K, V>,
RedisServerReactiveCommands<K, V>,
RedisHLLReactiveCommands<K, V>,
BaseRedisReactiveCommands<K, V>,
RedisTransactionalReactiveCommands<K, V>,
RedisGeoReactiveCommands<K, V>,
RedisClusterReactiveCommands<K, V> {
    private final StatefulConnection<K, V> connection;
    private final RedisCodec<K, V> codec;
    private final RedisCommandBuilder<K, V> commandBuilder;

    public AbstractRedisReactiveCommands(StatefulConnection<K, V> connection, RedisCodec<K, V> codec) {
        this.connection = connection;
        this.codec = codec;
        this.commandBuilder = new RedisCommandBuilder<K, V>(codec);
    }

    @Override
    public Mono<Long> append(K key, V value) {
        return this.createMono(() -> this.commandBuilder.append(key, value));
    }

    @Override
    public Mono<String> asking() {
        return this.createMono(this.commandBuilder::asking);
    }

    @Override
    public Mono<String> auth(String password) {
        return this.createMono(() -> this.commandBuilder.auth(password));
    }

    @Override
    public Mono<String> bgrewriteaof() {
        return this.createMono(this.commandBuilder::bgrewriteaof);
    }

    @Override
    public Mono<String> bgsave() {
        return this.createMono(this.commandBuilder::bgsave);
    }

    @Override
    public Mono<Long> bitcount(K key) {
        return this.createMono(() -> this.commandBuilder.bitcount(key));
    }

    @Override
    public Mono<Long> bitcount(K key, long start, long end) {
        return this.createMono(() -> this.commandBuilder.bitcount(key, start, end));
    }

    @Override
    public Flux<Value<Long>> bitfield(K key, BitFieldArgs args) {
        return this.createDissolvingFlux(() -> this.commandBuilder.bitfieldValue(key, args));
    }

    @Override
    public Mono<Long> bitopAnd(K destination, K ... keys) {
        return this.createMono(() -> this.commandBuilder.bitopAnd(destination, keys));
    }

    @Override
    public Mono<Long> bitopNot(K destination, K source) {
        return this.createMono(() -> this.commandBuilder.bitopNot(destination, source));
    }

    @Override
    public Mono<Long> bitopOr(K destination, K ... keys) {
        return this.createMono(() -> this.commandBuilder.bitopOr(destination, keys));
    }

    @Override
    public Mono<Long> bitopXor(K destination, K ... keys) {
        return this.createMono(() -> this.commandBuilder.bitopXor(destination, keys));
    }

    @Override
    public Mono<Long> bitpos(K key, boolean state) {
        return this.createMono(() -> this.commandBuilder.bitpos(key, state));
    }

    @Override
    public Mono<Long> bitpos(K key, boolean state, long start, long end) {
        return this.createMono(() -> this.commandBuilder.bitpos(key, state, start, end));
    }

    @Override
    public Mono<KeyValue<K, V>> blpop(long timeout, K ... keys) {
        return this.createMono(() -> this.commandBuilder.blpop(timeout, keys));
    }

    @Override
    public Mono<KeyValue<K, V>> brpop(long timeout, K ... keys) {
        return this.createMono(() -> this.commandBuilder.brpop(timeout, keys));
    }

    @Override
    public Mono<V> brpoplpush(long timeout, K source, K destination) {
        return this.createMono(() -> this.commandBuilder.brpoplpush(timeout, source, destination));
    }

    @Override
    public Mono<K> clientGetname() {
        return this.createMono(this.commandBuilder::clientGetname);
    }

    @Override
    public Mono<String> clientKill(String addr) {
        return this.createMono(() -> this.commandBuilder.clientKill(addr));
    }

    @Override
    public Mono<Long> clientKill(KillArgs killArgs) {
        return this.createMono(() -> this.commandBuilder.clientKill(killArgs));
    }

    @Override
    public Mono<String> clientList() {
        return this.createMono(this.commandBuilder::clientList);
    }

    @Override
    public Mono<String> clientPause(long timeout) {
        return this.createMono(() -> this.commandBuilder.clientPause(timeout));
    }

    @Override
    public Mono<String> clientSetname(K name) {
        return this.createMono(() -> this.commandBuilder.clientSetname(name));
    }

    public void close() {
        this.connection.close();
    }

    @Override
    public Mono<String> clusterAddSlots(int ... slots) {
        return this.createMono(() -> this.commandBuilder.clusterAddslots(slots));
    }

    @Override
    public Mono<String> clusterBumpepoch() {
        return this.createMono(() -> this.commandBuilder.clusterBumpepoch());
    }

    @Override
    public Mono<Long> clusterCountFailureReports(String nodeId) {
        return this.createMono(() -> this.commandBuilder.clusterCountFailureReports(nodeId));
    }

    @Override
    public Mono<Long> clusterCountKeysInSlot(int slot) {
        return this.createMono(() -> this.commandBuilder.clusterCountKeysInSlot(slot));
    }

    @Override
    public Mono<String> clusterDelSlots(int ... slots) {
        return this.createMono(() -> this.commandBuilder.clusterDelslots(slots));
    }

    @Override
    public Mono<String> clusterFailover(boolean force) {
        return this.createMono(() -> this.commandBuilder.clusterFailover(force));
    }

    @Override
    public Mono<String> clusterFlushslots() {
        return this.createMono(this.commandBuilder::clusterFlushslots);
    }

    @Override
    public Mono<String> clusterForget(String nodeId) {
        return this.createMono(() -> this.commandBuilder.clusterForget(nodeId));
    }

    @Override
    public Flux<K> clusterGetKeysInSlot(int slot, int count) {
        return this.createDissolvingFlux(() -> this.commandBuilder.clusterGetKeysInSlot(slot, count));
    }

    @Override
    public Mono<String> clusterInfo() {
        return this.createMono(this.commandBuilder::clusterInfo);
    }

    @Override
    public Mono<Long> clusterKeyslot(K key) {
        return this.createMono(() -> this.commandBuilder.clusterKeyslot(key));
    }

    @Override
    public Mono<String> clusterMeet(String ip, int port) {
        return this.createMono(() -> this.commandBuilder.clusterMeet(ip, port));
    }

    @Override
    public Mono<String> clusterMyId() {
        return this.createMono(this.commandBuilder::clusterMyId);
    }

    @Override
    public Mono<String> clusterNodes() {
        return this.createMono(this.commandBuilder::clusterNodes);
    }

    @Override
    public Mono<String> clusterReplicate(String nodeId) {
        return this.createMono(() -> this.commandBuilder.clusterReplicate(nodeId));
    }

    @Override
    public Mono<String> clusterReset(boolean hard) {
        return this.createMono(() -> this.commandBuilder.clusterReset(hard));
    }

    @Override
    public Mono<String> clusterSaveconfig() {
        return this.createMono(() -> this.commandBuilder.clusterSaveconfig());
    }

    @Override
    public Mono<String> clusterSetConfigEpoch(long configEpoch) {
        return this.createMono(() -> this.commandBuilder.clusterSetConfigEpoch(configEpoch));
    }

    @Override
    public Mono<String> clusterSetSlotImporting(int slot, String nodeId) {
        return this.createMono(() -> this.commandBuilder.clusterSetSlotImporting(slot, nodeId));
    }

    @Override
    public Mono<String> clusterSetSlotMigrating(int slot, String nodeId) {
        return this.createMono(() -> this.commandBuilder.clusterSetSlotMigrating(slot, nodeId));
    }

    @Override
    public Mono<String> clusterSetSlotNode(int slot, String nodeId) {
        return this.createMono(() -> this.commandBuilder.clusterSetSlotNode(slot, nodeId));
    }

    @Override
    public Mono<String> clusterSetSlotStable(int slot) {
        return this.createMono(() -> this.commandBuilder.clusterSetSlotStable(slot));
    }

    @Override
    public Flux<String> clusterSlaves(String nodeId) {
        return this.createDissolvingFlux(() -> this.commandBuilder.clusterSlaves(nodeId));
    }

    @Override
    public Flux<Object> clusterSlots() {
        return this.createDissolvingFlux(this.commandBuilder::clusterSlots);
    }

    @Override
    public Flux<Object> command() {
        return this.createDissolvingFlux(this.commandBuilder::command);
    }

    @Override
    public Mono<Long> commandCount() {
        return this.createMono(this.commandBuilder::commandCount);
    }

    @Override
    public Flux<Object> commandInfo(String ... commands) {
        return this.createDissolvingFlux(() -> this.commandBuilder.commandInfo(commands));
    }

    @Override
    public Flux<Object> commandInfo(CommandType ... commands) {
        String[] stringCommands = new String[commands.length];
        for (int i = 0; i < commands.length; ++i) {
            stringCommands[i] = commands[i].name();
        }
        return this.commandInfo(stringCommands);
    }

    @Override
    public Mono<Map<String, String>> configGet(String parameter) {
        return this.createMono(() -> this.commandBuilder.configGet(parameter));
    }

    @Override
    public Mono<String> configResetstat() {
        return this.createMono(this.commandBuilder::configResetstat);
    }

    @Override
    public Mono<String> configRewrite() {
        return this.createMono(this.commandBuilder::configRewrite);
    }

    @Override
    public Mono<String> configSet(String parameter, String value) {
        return this.createMono(() -> this.commandBuilder.configSet(parameter, value));
    }

    public <T, R> Flux<R> createDissolvingFlux(Supplier<RedisCommand<K, V, T>> commandSupplier) {
        return Flux.from(new RedisPublisher<K, V, T>(commandSupplier, this.connection, true));
    }

    public <T> Flux<T> createFlux(Supplier<RedisCommand<K, V, T>> commandSupplier) {
        return Flux.from(new RedisPublisher<K, V, T>(commandSupplier, this.connection, false));
    }

    protected <T> Mono<T> createMono(CommandType type, CommandOutput<K, V, T> output, CommandArgs<K, V> args) {
        return this.createMono(() -> new Command(type, output, args));
    }

    public <T> Mono<T> createMono(Supplier<RedisCommand<K, V, T>> commandSupplier) {
        return Mono.from(new RedisPublisher<K, V, T>(commandSupplier, this.connection, false));
    }

    @Override
    public Mono<Long> dbsize() {
        return this.createMono(this.commandBuilder::dbsize);
    }

    @Override
    public Mono<String> debugCrashAndRecover(Long delay) {
        return this.createMono(() -> this.commandBuilder.debugCrashAndRecover(delay));
    }

    @Override
    public Mono<String> debugHtstats(int db) {
        return this.createMono(() -> this.commandBuilder.debugHtstats(db));
    }

    @Override
    public Mono<String> debugObject(K key) {
        return this.createMono(() -> this.commandBuilder.debugObject(key));
    }

    @Override
    public Mono<Void> debugOom() {
        return this.createMono(this.commandBuilder::debugOom).then();
    }

    @Override
    public Mono<String> debugReload() {
        return this.createMono(() -> this.commandBuilder.debugReload());
    }

    @Override
    public Mono<String> debugRestart(Long delay) {
        return this.createMono(() -> this.commandBuilder.debugRestart(delay));
    }

    @Override
    public Mono<String> debugSdslen(K key) {
        return this.createMono(() -> this.commandBuilder.debugSdslen(key));
    }

    @Override
    public Mono<Void> debugSegfault() {
        return this.createFlux(this.commandBuilder::debugSegfault).then();
    }

    @Override
    public Mono<Long> decr(K key) {
        return this.createMono(() -> this.commandBuilder.decr(key));
    }

    @Override
    public Mono<Long> decrby(K key, long amount) {
        return this.createMono(() -> this.commandBuilder.decrby(key, amount));
    }

    @Override
    public Mono<Long> del(K ... keys) {
        return this.createMono(() -> this.commandBuilder.del(keys));
    }

    public Mono<Long> del(Iterable<K> keys) {
        return this.createMono(() -> this.commandBuilder.del(keys));
    }

    @Override
    public String digest(V script) {
        return LettuceStrings.digest(this.codec.encodeValue(script));
    }

    @Override
    public Mono<String> discard() {
        return this.createMono(this.commandBuilder::discard);
    }

    @Override
    public <T> Flux<T> dispatch(ProtocolKeyword type, CommandOutput<K, V, ?> output) {
        LettuceAssert.notNull(type, "Command type must not be null");
        LettuceAssert.notNull(output, "CommandOutput type must not be null");
        return this.createFlux(() -> new Command(type, output));
    }

    @Override
    public <T> Flux<T> dispatch(ProtocolKeyword type, CommandOutput<K, V, ?> output, CommandArgs<K, V> args) {
        LettuceAssert.notNull(type, "Command type must not be null");
        LettuceAssert.notNull(output, "CommandOutput type must not be null");
        LettuceAssert.notNull(args, "CommandArgs type must not be null");
        return this.createFlux(() -> new Command(type, output, args));
    }

    @Override
    public Mono<byte[]> dump(K key) {
        return this.createMono(() -> this.commandBuilder.dump(key));
    }

    @Override
    public Mono<V> echo(V msg) {
        return this.createMono(() -> this.commandBuilder.echo(msg));
    }

    @Override
    public <T> Flux<T> eval(String script, ScriptOutputType type, K ... keys) {
        return this.createFlux(() -> this.commandBuilder.eval(script, type, keys));
    }

    @Override
    public <T> Flux<T> eval(String script, ScriptOutputType type, K[] keys, V ... values) {
        return this.createFlux(() -> this.commandBuilder.eval(script, type, keys, values));
    }

    @Override
    public <T> Flux<T> evalsha(String digest, ScriptOutputType type, K ... keys) {
        return this.createFlux(() -> this.commandBuilder.evalsha(digest, type, keys));
    }

    @Override
    public <T> Flux<T> evalsha(String digest, ScriptOutputType type, K[] keys, V ... values) {
        return this.createFlux(() -> this.commandBuilder.evalsha(digest, type, keys, values));
    }

    @Override
    public Mono<TransactionResult> exec() {
        return this.createMono(CommandType.EXEC, null, null);
    }

    public Mono<Boolean> exists(K key) {
        return this.createMono(() -> this.commandBuilder.exists((Object)key));
    }

    @Override
    public Mono<Long> exists(K ... keys) {
        return this.createMono(() -> this.commandBuilder.exists(keys));
    }

    public Mono<Long> exists(Iterable<K> keys) {
        return this.createMono(() -> this.commandBuilder.exists(keys));
    }

    @Override
    public Mono<Boolean> expire(K key, long seconds) {
        return this.createMono(() -> this.commandBuilder.expire(key, seconds));
    }

    @Override
    public Mono<Boolean> expireat(K key, long timestamp) {
        return this.createMono(() -> this.commandBuilder.expireat(key, timestamp));
    }

    @Override
    public Mono<Boolean> expireat(K key, Date timestamp) {
        return this.expireat(key, timestamp.getTime() / 1000L);
    }

    @Override
    public void flushCommands() {
        this.connection.flushCommands();
    }

    @Override
    public Mono<String> flushall() {
        return this.createMono(this.commandBuilder::flushall);
    }

    @Override
    public Mono<String> flushallAsync() {
        return this.createMono(this.commandBuilder::flushallAsync);
    }

    @Override
    public Mono<String> flushdb() {
        return this.createMono(this.commandBuilder::flushdb);
    }

    @Override
    public Mono<String> flushdbAsync() {
        return this.createMono(this.commandBuilder::flushdbAsync);
    }

    @Override
    public Mono<Long> geoadd(K key, double longitude, double latitude, V member) {
        return this.createMono(() -> this.commandBuilder.geoadd(key, longitude, latitude, member));
    }

    @Override
    public Mono<Long> geoadd(K key, Object ... lngLatMember) {
        return this.createMono(() -> this.commandBuilder.geoadd(key, lngLatMember));
    }

    @Override
    public Mono<Double> geodist(K key, V from, V to, GeoArgs.Unit unit) {
        return this.createMono(() -> this.commandBuilder.geodist(key, from, to, unit));
    }

    @Override
    public Flux<Value<String>> geohash(K key, V ... members) {
        return this.createDissolvingFlux(() -> this.commandBuilder.geohash(key, members));
    }

    @Override
    public Flux<Value<GeoCoordinates>> geopos(K key, V ... members) {
        return this.createDissolvingFlux(() -> this.commandBuilder.geoposValues(key, members));
    }

    @Override
    public Flux<V> georadius(K key, double longitude, double latitude, double distance, GeoArgs.Unit unit) {
        return this.createDissolvingFlux(() -> this.commandBuilder.georadius(CommandType.GEORADIUS, key, longitude, latitude, distance, unit.name()));
    }

    @Override
    public Flux<GeoWithin<V>> georadius(K key, double longitude, double latitude, double distance, GeoArgs.Unit unit, GeoArgs geoArgs) {
        return this.createDissolvingFlux(() -> this.commandBuilder.georadius(CommandType.GEORADIUS, key, longitude, latitude, distance, unit.name(), geoArgs));
    }

    @Override
    public Mono<Long> georadius(K key, double longitude, double latitude, double distance, GeoArgs.Unit unit, GeoRadiusStoreArgs<K> geoRadiusStoreArgs) {
        return this.createMono(() -> this.commandBuilder.georadius(key, longitude, latitude, distance, unit.name(), geoRadiusStoreArgs));
    }

    protected Flux<V> georadius_ro(K key, double longitude, double latitude, double distance, GeoArgs.Unit unit) {
        return this.createDissolvingFlux(() -> this.commandBuilder.georadius(CommandType.GEORADIUS_RO, key, longitude, latitude, distance, unit.name()));
    }

    protected Flux<GeoWithin<V>> georadius_ro(K key, double longitude, double latitude, double distance, GeoArgs.Unit unit, GeoArgs geoArgs) {
        return this.createDissolvingFlux(() -> this.commandBuilder.georadius(CommandType.GEORADIUS_RO, key, longitude, latitude, distance, unit.name(), geoArgs));
    }

    @Override
    public Flux<V> georadiusbymember(K key, V member, double distance, GeoArgs.Unit unit) {
        return this.createDissolvingFlux(() -> this.commandBuilder.georadiusbymember(CommandType.GEORADIUSBYMEMBER, key, member, distance, unit.name()));
    }

    @Override
    public Flux<GeoWithin<V>> georadiusbymember(K key, V member, double distance, GeoArgs.Unit unit, GeoArgs geoArgs) {
        return this.createDissolvingFlux(() -> this.commandBuilder.georadiusbymember(CommandType.GEORADIUSBYMEMBER, key, member, distance, unit.name(), geoArgs));
    }

    @Override
    public Mono<Long> georadiusbymember(K key, V member, double distance, GeoArgs.Unit unit, GeoRadiusStoreArgs<K> geoRadiusStoreArgs) {
        return this.createMono(() -> this.commandBuilder.georadiusbymember(key, member, distance, unit.name(), geoRadiusStoreArgs));
    }

    protected Flux<V> georadiusbymember_ro(K key, V member, double distance, GeoArgs.Unit unit) {
        return this.createDissolvingFlux(() -> this.commandBuilder.georadiusbymember(CommandType.GEORADIUSBYMEMBER_RO, key, member, distance, unit.name()));
    }

    protected Flux<GeoWithin<V>> georadiusbymember_ro(K key, V member, double distance, GeoArgs.Unit unit, GeoArgs geoArgs) {
        return this.createDissolvingFlux(() -> this.commandBuilder.georadiusbymember(CommandType.GEORADIUSBYMEMBER_RO, key, member, distance, unit.name(), geoArgs));
    }

    @Override
    public Mono<V> get(K key) {
        return this.createMono(() -> this.commandBuilder.get(key));
    }

    public StatefulConnection<K, V> getConnection() {
        return this.connection;
    }

    @Override
    public Mono<Long> getbit(K key, long offset) {
        return this.createMono(() -> this.commandBuilder.getbit(key, offset));
    }

    @Override
    public Mono<V> getrange(K key, long start, long end) {
        return this.createMono(() -> this.commandBuilder.getrange(key, start, end));
    }

    @Override
    public Mono<V> getset(K key, V value) {
        return this.createMono(() -> this.commandBuilder.getset(key, value));
    }

    @Override
    public Mono<Long> hdel(K key, K ... fields) {
        return this.createMono(() -> this.commandBuilder.hdel(key, fields));
    }

    @Override
    public Mono<Boolean> hexists(K key, K field) {
        return this.createMono(() -> this.commandBuilder.hexists(key, field));
    }

    @Override
    public Mono<V> hget(K key, K field) {
        return this.createMono(() -> this.commandBuilder.hget(key, field));
    }

    @Override
    public Mono<Map<K, V>> hgetall(K key) {
        return this.createMono(() -> this.commandBuilder.hgetall(key));
    }

    @Override
    public Mono<Long> hgetall(KeyValueStreamingChannel<K, V> channel, K key) {
        return this.createMono(() -> this.commandBuilder.hgetall(channel, key));
    }

    @Override
    public Mono<Long> hincrby(K key, K field, long amount) {
        return this.createMono(() -> this.commandBuilder.hincrby(key, field, amount));
    }

    @Override
    public Mono<Double> hincrbyfloat(K key, K field, double amount) {
        return this.createMono(() -> this.commandBuilder.hincrbyfloat(key, field, amount));
    }

    @Override
    public Flux<K> hkeys(K key) {
        return this.createDissolvingFlux(() -> this.commandBuilder.hkeys(key));
    }

    @Override
    public Mono<Long> hkeys(KeyStreamingChannel<K> channel, K key) {
        return this.createMono(() -> this.commandBuilder.hkeys(channel, key));
    }

    @Override
    public Mono<Long> hlen(K key) {
        return this.createMono(() -> this.commandBuilder.hlen(key));
    }

    @Override
    public Flux<KeyValue<K, V>> hmget(K key, K ... fields) {
        return this.createDissolvingFlux(() -> this.commandBuilder.hmgetKeyValue(key, fields));
    }

    @Override
    public Mono<Long> hmget(KeyValueStreamingChannel<K, V> channel, K key, K ... fields) {
        return this.createMono(() -> this.commandBuilder.hmget(channel, key, fields));
    }

    @Override
    public Mono<String> hmset(K key, Map<K, V> map) {
        return this.createMono(() -> this.commandBuilder.hmset(key, map));
    }

    @Override
    public Mono<MapScanCursor<K, V>> hscan(K key) {
        return this.createMono(() -> this.commandBuilder.hscan(key));
    }

    @Override
    public Mono<MapScanCursor<K, V>> hscan(K key, ScanArgs scanArgs) {
        return this.createMono(() -> this.commandBuilder.hscan(key, scanArgs));
    }

    @Override
    public Mono<MapScanCursor<K, V>> hscan(K key, ScanCursor scanCursor, ScanArgs scanArgs) {
        return this.createMono(() -> this.commandBuilder.hscan(key, scanCursor, scanArgs));
    }

    @Override
    public Mono<MapScanCursor<K, V>> hscan(K key, ScanCursor scanCursor) {
        return this.createMono(() -> this.commandBuilder.hscan(key, scanCursor));
    }

    @Override
    public Mono<StreamScanCursor> hscan(KeyValueStreamingChannel<K, V> channel, K key) {
        return this.createMono(() -> this.commandBuilder.hscanStreaming(channel, key));
    }

    @Override
    public Mono<StreamScanCursor> hscan(KeyValueStreamingChannel<K, V> channel, K key, ScanArgs scanArgs) {
        return this.createMono(() -> this.commandBuilder.hscanStreaming(channel, key, scanArgs));
    }

    @Override
    public Mono<StreamScanCursor> hscan(KeyValueStreamingChannel<K, V> channel, K key, ScanCursor scanCursor, ScanArgs scanArgs) {
        return this.createMono(() -> this.commandBuilder.hscanStreaming(channel, key, scanCursor, scanArgs));
    }

    @Override
    public Mono<StreamScanCursor> hscan(KeyValueStreamingChannel<K, V> channel, K key, ScanCursor scanCursor) {
        return this.createMono(() -> this.commandBuilder.hscanStreaming(channel, key, scanCursor));
    }

    @Override
    public Mono<Boolean> hset(K key, K field, V value) {
        return this.createMono(() -> this.commandBuilder.hset(key, field, value));
    }

    @Override
    public Mono<Boolean> hsetnx(K key, K field, V value) {
        return this.createMono(() -> this.commandBuilder.hsetnx(key, field, value));
    }

    @Override
    public Mono<Long> hstrlen(K key, K field) {
        return this.createMono(() -> this.commandBuilder.hstrlen(key, field));
    }

    @Override
    public Flux<V> hvals(K key) {
        return this.createDissolvingFlux(() -> this.commandBuilder.hvals(key));
    }

    @Override
    public Mono<Long> hvals(ValueStreamingChannel<V> channel, K key) {
        return this.createMono(() -> this.commandBuilder.hvals(channel, key));
    }

    @Override
    public Mono<Long> incr(K key) {
        return this.createMono(() -> this.commandBuilder.incr(key));
    }

    @Override
    public Mono<Long> incrby(K key, long amount) {
        return this.createMono(() -> this.commandBuilder.incrby(key, amount));
    }

    @Override
    public Mono<Double> incrbyfloat(K key, double amount) {
        return this.createMono(() -> this.commandBuilder.incrbyfloat(key, amount));
    }

    @Override
    public Mono<String> info() {
        return this.createMono(this.commandBuilder::info);
    }

    @Override
    public Mono<String> info(String section) {
        return this.createMono(() -> this.commandBuilder.info(section));
    }

    @Override
    public boolean isOpen() {
        return this.connection.isOpen();
    }

    @Override
    public Flux<K> keys(K pattern) {
        return this.createDissolvingFlux(() -> this.commandBuilder.keys(pattern));
    }

    @Override
    public Mono<Long> keys(KeyStreamingChannel<K> channel, K pattern) {
        return this.createMono(() -> this.commandBuilder.keys(channel, pattern));
    }

    @Override
    public Mono<Date> lastsave() {
        return this.createMono(this.commandBuilder::lastsave);
    }

    @Override
    public Mono<V> lindex(K key, long index) {
        return this.createMono(() -> this.commandBuilder.lindex(key, index));
    }

    @Override
    public Mono<Long> linsert(K key, boolean before, V pivot, V value) {
        return this.createMono(() -> this.commandBuilder.linsert(key, before, pivot, value));
    }

    @Override
    public Mono<Long> llen(K key) {
        return this.createMono(() -> this.commandBuilder.llen(key));
    }

    @Override
    public Mono<V> lpop(K key) {
        return this.createMono(() -> this.commandBuilder.lpop(key));
    }

    @Override
    public Mono<Long> lpush(K key, V ... values) {
        return this.createMono(() -> this.commandBuilder.lpush(key, values));
    }

    @Override
    public Mono<Long> lpushx(K key, V ... values) {
        return this.createMono(() -> this.commandBuilder.lpushx(key, values));
    }

    @Override
    public Flux<V> lrange(K key, long start, long stop) {
        return this.createDissolvingFlux(() -> this.commandBuilder.lrange(key, start, stop));
    }

    @Override
    public Mono<Long> lrange(ValueStreamingChannel<V> channel, K key, long start, long stop) {
        return this.createMono(() -> this.commandBuilder.lrange(channel, key, start, stop));
    }

    @Override
    public Mono<Long> lrem(K key, long count, V value) {
        return this.createMono(() -> this.commandBuilder.lrem(key, count, value));
    }

    @Override
    public Mono<String> lset(K key, long index, V value) {
        return this.createMono(() -> this.commandBuilder.lset(key, index, value));
    }

    @Override
    public Mono<String> ltrim(K key, long start, long stop) {
        return this.createMono(() -> this.commandBuilder.ltrim(key, start, stop));
    }

    @Override
    public Flux<KeyValue<K, V>> mget(K ... keys) {
        return this.createDissolvingFlux(() -> this.commandBuilder.mgetKeyValue(keys));
    }

    public Flux<KeyValue<K, V>> mget(Iterable<K> keys) {
        return this.createDissolvingFlux(() -> this.commandBuilder.mgetKeyValue(keys));
    }

    @Override
    public Mono<Long> mget(KeyValueStreamingChannel<K, V> channel, K ... keys) {
        return this.createMono(() -> this.commandBuilder.mget(channel, keys));
    }

    public Mono<Long> mget(ValueStreamingChannel<V> channel, Iterable<K> keys) {
        return this.createMono(() -> this.commandBuilder.mget(channel, keys));
    }

    public Mono<Long> mget(KeyValueStreamingChannel<K, V> channel, Iterable<K> keys) {
        return this.createMono(() -> this.commandBuilder.mget(channel, keys));
    }

    @Override
    public Mono<String> migrate(String host, int port, K key, int db, long timeout) {
        return this.createMono(() -> this.commandBuilder.migrate(host, port, key, db, timeout));
    }

    @Override
    public Mono<String> migrate(String host, int port, int db, long timeout, MigrateArgs<K> migrateArgs) {
        return this.createMono(() -> this.commandBuilder.migrate(host, port, db, timeout, migrateArgs));
    }

    @Override
    public Mono<Boolean> move(K key, int db) {
        return this.createMono(() -> this.commandBuilder.move(key, db));
    }

    @Override
    public Mono<String> mset(Map<K, V> map) {
        return this.createMono(() -> this.commandBuilder.mset(map));
    }

    @Override
    public Mono<Boolean> msetnx(Map<K, V> map) {
        return this.createMono(() -> this.commandBuilder.msetnx(map));
    }

    @Override
    public Mono<String> multi() {
        return this.createMono(this.commandBuilder::multi);
    }

    @Override
    public Mono<String> objectEncoding(K key) {
        return this.createMono(() -> this.commandBuilder.objectEncoding(key));
    }

    @Override
    public Mono<Long> objectIdletime(K key) {
        return this.createMono(() -> this.commandBuilder.objectIdletime(key));
    }

    @Override
    public Mono<Long> objectRefcount(K key) {
        return this.createMono(() -> this.commandBuilder.objectRefcount(key));
    }

    @Override
    public Mono<Boolean> persist(K key) {
        return this.createMono(() -> this.commandBuilder.persist(key));
    }

    @Override
    public Mono<Boolean> pexpire(K key, long milliseconds) {
        return this.createMono(() -> this.commandBuilder.pexpire(key, milliseconds));
    }

    @Override
    public Mono<Boolean> pexpireat(K key, Date timestamp) {
        return this.pexpireat(key, timestamp.getTime());
    }

    @Override
    public Mono<Boolean> pexpireat(K key, long timestamp) {
        return this.createMono(() -> this.commandBuilder.pexpireat(key, timestamp));
    }

    @Override
    public Mono<Long> pfadd(K key, V ... values) {
        return this.createMono(() -> this.commandBuilder.pfadd(key, values));
    }

    public Mono<Long> pfadd(K key, V value, V ... values) {
        return this.createMono(() -> this.commandBuilder.pfadd((Object)key, (Object)value, values));
    }

    @Override
    public Mono<Long> pfcount(K ... keys) {
        return this.createMono(() -> this.commandBuilder.pfcount(keys));
    }

    public Mono<Long> pfcount(K key, K ... keys) {
        return this.createMono(() -> this.commandBuilder.pfcount((Object)key, keys));
    }

    @Override
    public Mono<String> pfmerge(K destkey, K ... sourcekeys) {
        return this.createMono(() -> this.commandBuilder.pfmerge(destkey, sourcekeys));
    }

    public Mono<String> pfmerge(K destkey, K sourceKey, K ... sourcekeys) {
        return this.createMono(() -> this.commandBuilder.pfmerge((Object)destkey, (Object)sourceKey, sourcekeys));
    }

    @Override
    public Mono<String> ping() {
        return this.createMono(this.commandBuilder::ping);
    }

    @Override
    public Mono<String> psetex(K key, long milliseconds, V value) {
        return this.createMono(() -> this.commandBuilder.psetex(key, milliseconds, value));
    }

    @Override
    public Mono<Long> pttl(K key) {
        return this.createMono(() -> this.commandBuilder.pttl(key));
    }

    @Override
    public Mono<Long> publish(K channel, V message) {
        return this.createMono(() -> this.commandBuilder.publish(channel, message));
    }

    @Override
    public Flux<K> pubsubChannels() {
        return this.createDissolvingFlux(this.commandBuilder::pubsubChannels);
    }

    @Override
    public Flux<K> pubsubChannels(K channel) {
        return this.createDissolvingFlux(() -> this.commandBuilder.pubsubChannels(channel));
    }

    @Override
    public Mono<Long> pubsubNumpat() {
        return this.createMono(this.commandBuilder::pubsubNumpat);
    }

    @Override
    public Mono<Map<K, Long>> pubsubNumsub(K ... channels) {
        return this.createMono(() -> this.commandBuilder.pubsubNumsub(channels));
    }

    @Override
    public Mono<String> quit() {
        return this.createMono(this.commandBuilder::quit);
    }

    @Override
    public Mono<V> randomkey() {
        return this.createMono(this.commandBuilder::randomkey);
    }

    @Override
    public Mono<String> readOnly() {
        return this.createMono(this.commandBuilder::readOnly);
    }

    @Override
    public Mono<String> readWrite() {
        return this.createMono(this.commandBuilder::readWrite);
    }

    @Override
    public Mono<String> rename(K key, K newKey) {
        return this.createMono(() -> this.commandBuilder.rename(key, newKey));
    }

    @Override
    public Mono<Boolean> renamenx(K key, K newKey) {
        return this.createMono(() -> this.commandBuilder.renamenx(key, newKey));
    }

    @Override
    public void reset() {
        this.getConnection().reset();
    }

    @Override
    public Mono<String> restore(K key, long ttl, byte[] value) {
        return this.createMono(() -> this.commandBuilder.restore(key, ttl, value));
    }

    @Override
    public Flux<Object> role() {
        return this.createDissolvingFlux(this.commandBuilder::role);
    }

    @Override
    public Mono<V> rpop(K key) {
        return this.createMono(() -> this.commandBuilder.rpop(key));
    }

    @Override
    public Mono<V> rpoplpush(K source, K destination) {
        return this.createMono(() -> this.commandBuilder.rpoplpush(source, destination));
    }

    @Override
    public Mono<Long> rpush(K key, V ... values) {
        return this.createMono(() -> this.commandBuilder.rpush(key, values));
    }

    @Override
    public Mono<Long> rpushx(K key, V ... values) {
        return this.createMono(() -> this.commandBuilder.rpushx(key, values));
    }

    @Override
    public Mono<Long> sadd(K key, V ... members) {
        return this.createMono(() -> this.commandBuilder.sadd(key, members));
    }

    @Override
    public Mono<String> save() {
        return this.createMono(this.commandBuilder::save);
    }

    @Override
    public Mono<KeyScanCursor<K>> scan() {
        return this.createMono(this.commandBuilder::scan);
    }

    @Override
    public Mono<KeyScanCursor<K>> scan(ScanArgs scanArgs) {
        return this.createMono(() -> this.commandBuilder.scan(scanArgs));
    }

    @Override
    public Mono<KeyScanCursor<K>> scan(ScanCursor scanCursor, ScanArgs scanArgs) {
        return this.createMono(() -> this.commandBuilder.scan(scanCursor, scanArgs));
    }

    @Override
    public Mono<KeyScanCursor<K>> scan(ScanCursor scanCursor) {
        return this.createMono(() -> this.commandBuilder.scan(scanCursor));
    }

    @Override
    public Mono<StreamScanCursor> scan(KeyStreamingChannel<K> channel) {
        return this.createMono(() -> this.commandBuilder.scanStreaming(channel));
    }

    @Override
    public Mono<StreamScanCursor> scan(KeyStreamingChannel<K> channel, ScanArgs scanArgs) {
        return this.createMono(() -> this.commandBuilder.scanStreaming(channel, scanArgs));
    }

    @Override
    public Mono<StreamScanCursor> scan(KeyStreamingChannel<K> channel, ScanCursor scanCursor, ScanArgs scanArgs) {
        return this.createMono(() -> this.commandBuilder.scanStreaming(channel, scanCursor, scanArgs));
    }

    @Override
    public Mono<StreamScanCursor> scan(KeyStreamingChannel<K> channel, ScanCursor scanCursor) {
        return this.createMono(() -> this.commandBuilder.scanStreaming(channel, scanCursor));
    }

    @Override
    public Mono<Long> scard(K key) {
        return this.createMono(() -> this.commandBuilder.scard(key));
    }

    @Override
    public Flux<Boolean> scriptExists(String ... digests) {
        return this.createDissolvingFlux(() -> this.commandBuilder.scriptExists(digests));
    }

    @Override
    public Mono<String> scriptFlush() {
        return this.createMono(this.commandBuilder::scriptFlush);
    }

    @Override
    public Mono<String> scriptKill() {
        return this.createMono(this.commandBuilder::scriptKill);
    }

    @Override
    public Mono<String> scriptLoad(V script) {
        return this.createMono(() -> this.commandBuilder.scriptLoad(script));
    }

    @Override
    public Flux<V> sdiff(K ... keys) {
        return this.createDissolvingFlux(() -> this.commandBuilder.sdiff(keys));
    }

    @Override
    public Mono<Long> sdiff(ValueStreamingChannel<V> channel, K ... keys) {
        return this.createMono(() -> this.commandBuilder.sdiff(channel, keys));
    }

    @Override
    public Mono<Long> sdiffstore(K destination, K ... keys) {
        return this.createMono(() -> this.commandBuilder.sdiffstore(destination, keys));
    }

    public Mono<String> select(int db) {
        return this.createMono(() -> this.commandBuilder.select(db));
    }

    @Override
    public Mono<String> set(K key, V value) {
        return this.createMono(() -> this.commandBuilder.set(key, value));
    }

    @Override
    public Mono<String> set(K key, V value, SetArgs setArgs) {
        return this.createMono(() -> this.commandBuilder.set(key, value, setArgs));
    }

    @Override
    public void setAutoFlushCommands(boolean autoFlush) {
        this.connection.setAutoFlushCommands(autoFlush);
    }

    @Override
    public void setTimeout(Duration timeout) {
        this.connection.setTimeout(timeout);
    }

    @Override
    public void setTimeout(long timeout, TimeUnit unit) {
        this.connection.setTimeout(timeout, unit);
    }

    @Override
    public Mono<Long> setbit(K key, long offset, int value) {
        return this.createMono(() -> this.commandBuilder.setbit(key, offset, value));
    }

    @Override
    public Mono<String> setex(K key, long seconds, V value) {
        return this.createMono(() -> this.commandBuilder.setex(key, seconds, value));
    }

    @Override
    public Mono<Boolean> setnx(K key, V value) {
        return this.createMono(() -> this.commandBuilder.setnx(key, value));
    }

    @Override
    public Mono<Long> setrange(K key, long offset, V value) {
        return this.createMono(() -> this.commandBuilder.setrange(key, offset, value));
    }

    @Override
    public Mono<Void> shutdown(boolean save) {
        return this.createMono(() -> this.commandBuilder.shutdown(save)).then();
    }

    @Override
    public Flux<V> sinter(K ... keys) {
        return this.createDissolvingFlux(() -> this.commandBuilder.sinter(keys));
    }

    @Override
    public Mono<Long> sinter(ValueStreamingChannel<V> channel, K ... keys) {
        return this.createMono(() -> this.commandBuilder.sinter(channel, keys));
    }

    @Override
    public Mono<Long> sinterstore(K destination, K ... keys) {
        return this.createMono(() -> this.commandBuilder.sinterstore(destination, keys));
    }

    @Override
    public Mono<Boolean> sismember(K key, V member) {
        return this.createMono(() -> this.commandBuilder.sismember(key, member));
    }

    @Override
    public Mono<String> slaveof(String host, int port) {
        return this.createMono(() -> this.commandBuilder.slaveof(host, port));
    }

    @Override
    public Mono<String> slaveofNoOne() {
        return this.createMono(() -> this.commandBuilder.slaveofNoOne());
    }

    @Override
    public Flux<Object> slowlogGet() {
        return this.createDissolvingFlux(() -> this.commandBuilder.slowlogGet());
    }

    @Override
    public Flux<Object> slowlogGet(int count) {
        return this.createDissolvingFlux(() -> this.commandBuilder.slowlogGet(count));
    }

    @Override
    public Mono<Long> slowlogLen() {
        return this.createMono(() -> this.commandBuilder.slowlogLen());
    }

    @Override
    public Mono<String> slowlogReset() {
        return this.createMono(() -> this.commandBuilder.slowlogReset());
    }

    @Override
    public Flux<V> smembers(K key) {
        return this.createDissolvingFlux(() -> this.commandBuilder.smembers(key));
    }

    @Override
    public Mono<Long> smembers(ValueStreamingChannel<V> channel, K key) {
        return this.createMono(() -> this.commandBuilder.smembers(channel, key));
    }

    @Override
    public Mono<Boolean> smove(K source, K destination, V member) {
        return this.createMono(() -> this.commandBuilder.smove(source, destination, member));
    }

    @Override
    public Flux<V> sort(K key) {
        return this.createDissolvingFlux(() -> this.commandBuilder.sort(key));
    }

    @Override
    public Mono<Long> sort(ValueStreamingChannel<V> channel, K key) {
        return this.createMono(() -> this.commandBuilder.sort(channel, key));
    }

    @Override
    public Flux<V> sort(K key, SortArgs sortArgs) {
        return this.createDissolvingFlux(() -> this.commandBuilder.sort(key, sortArgs));
    }

    @Override
    public Mono<Long> sort(ValueStreamingChannel<V> channel, K key, SortArgs sortArgs) {
        return this.createMono(() -> this.commandBuilder.sort(channel, key, sortArgs));
    }

    @Override
    public Mono<Long> sortStore(K key, SortArgs sortArgs, K destination) {
        return this.createMono(() -> this.commandBuilder.sortStore(key, sortArgs, destination));
    }

    @Override
    public Mono<V> spop(K key) {
        return this.createMono(() -> this.commandBuilder.spop(key));
    }

    @Override
    public Flux<V> spop(K key, long count) {
        return this.createDissolvingFlux(() -> this.commandBuilder.spop(key, count));
    }

    @Override
    public Mono<V> srandmember(K key) {
        return this.createMono(() -> this.commandBuilder.srandmember(key));
    }

    @Override
    public Flux<V> srandmember(K key, long count) {
        return this.createDissolvingFlux(() -> this.commandBuilder.srandmember(key, count));
    }

    @Override
    public Mono<Long> srandmember(ValueStreamingChannel<V> channel, K key, long count) {
        return this.createMono(() -> this.commandBuilder.srandmember(channel, key, count));
    }

    @Override
    public Mono<Long> srem(K key, V ... members) {
        return this.createMono(() -> this.commandBuilder.srem(key, members));
    }

    @Override
    public Mono<ValueScanCursor<V>> sscan(K key) {
        return this.createMono(() -> this.commandBuilder.sscan(key));
    }

    @Override
    public Mono<ValueScanCursor<V>> sscan(K key, ScanArgs scanArgs) {
        return this.createMono(() -> this.commandBuilder.sscan(key, scanArgs));
    }

    @Override
    public Mono<ValueScanCursor<V>> sscan(K key, ScanCursor scanCursor, ScanArgs scanArgs) {
        return this.createMono(() -> this.commandBuilder.sscan(key, scanCursor, scanArgs));
    }

    @Override
    public Mono<ValueScanCursor<V>> sscan(K key, ScanCursor scanCursor) {
        return this.createMono(() -> this.commandBuilder.sscan(key, scanCursor));
    }

    @Override
    public Mono<StreamScanCursor> sscan(ValueStreamingChannel<V> channel, K key) {
        return this.createMono(() -> this.commandBuilder.sscanStreaming(channel, key));
    }

    @Override
    public Mono<StreamScanCursor> sscan(ValueStreamingChannel<V> channel, K key, ScanArgs scanArgs) {
        return this.createMono(() -> this.commandBuilder.sscanStreaming(channel, key, scanArgs));
    }

    @Override
    public Mono<StreamScanCursor> sscan(ValueStreamingChannel<V> channel, K key, ScanCursor scanCursor, ScanArgs scanArgs) {
        return this.createMono(() -> this.commandBuilder.sscanStreaming(channel, key, scanCursor, scanArgs));
    }

    @Override
    public Mono<StreamScanCursor> sscan(ValueStreamingChannel<V> channel, K key, ScanCursor scanCursor) {
        return this.createMono(() -> this.commandBuilder.sscanStreaming(channel, key, scanCursor));
    }

    @Override
    public Mono<Long> strlen(K key) {
        return this.createMono(() -> this.commandBuilder.strlen(key));
    }

    @Override
    public Flux<V> sunion(K ... keys) {
        return this.createDissolvingFlux(() -> this.commandBuilder.sunion(keys));
    }

    @Override
    public Mono<Long> sunion(ValueStreamingChannel<V> channel, K ... keys) {
        return this.createMono(() -> this.commandBuilder.sunion(channel, keys));
    }

    @Override
    public Mono<Long> sunionstore(K destination, K ... keys) {
        return this.createMono(() -> this.commandBuilder.sunionstore(destination, keys));
    }

    public Mono<String> swapdb(int db1, int db2) {
        return this.createMono(() -> this.commandBuilder.swapdb(db1, db2));
    }

    @Override
    public Flux<V> time() {
        return this.createDissolvingFlux(this.commandBuilder::time);
    }

    @Override
    public Mono<Long> touch(K ... keys) {
        return this.createMono(() -> this.commandBuilder.touch(keys));
    }

    public Mono<Long> touch(Iterable<K> keys) {
        return this.createMono(() -> this.commandBuilder.touch(keys));
    }

    @Override
    public Mono<Long> ttl(K key) {
        return this.createMono(() -> this.commandBuilder.ttl(key));
    }

    @Override
    public Mono<String> type(K key) {
        return this.createMono(() -> this.commandBuilder.type(key));
    }

    @Override
    public Mono<Long> unlink(K ... keys) {
        return this.createMono(() -> this.commandBuilder.unlink(keys));
    }

    public Mono<Long> unlink(Iterable<K> keys) {
        return this.createMono(() -> this.commandBuilder.unlink(keys));
    }

    @Override
    public Mono<String> unwatch() {
        return this.createMono(this.commandBuilder::unwatch);
    }

    @Override
    public Mono<Long> waitForReplication(int replicas, long timeout) {
        return this.createMono(() -> this.commandBuilder.wait(replicas, timeout));
    }

    @Override
    public Mono<String> watch(K ... keys) {
        return this.createMono(() -> this.commandBuilder.watch(keys));
    }

    @Override
    public Mono<Long> zadd(K key, double score, V member) {
        return this.createMono(() -> this.commandBuilder.zadd(key, (ZAddArgs)null, score, member));
    }

    @Override
    public Mono<Long> zadd(K key, Object ... scoresAndValues) {
        return this.createMono(() -> this.commandBuilder.zadd(key, null, scoresAndValues));
    }

    @Override
    public Mono<Long> zadd(K key, ScoredValue<V> ... scoredValues) {
        return this.createMono(() -> this.commandBuilder.zadd(key, null, scoredValues));
    }

    @Override
    public Mono<Long> zadd(K key, ZAddArgs zAddArgs, double score, V member) {
        return this.createMono(() -> this.commandBuilder.zadd(key, zAddArgs, score, member));
    }

    @Override
    public Mono<Long> zadd(K key, ZAddArgs zAddArgs, Object ... scoresAndValues) {
        return this.createMono(() -> this.commandBuilder.zadd(key, zAddArgs, scoresAndValues));
    }

    @Override
    public Mono<Long> zadd(K key, ZAddArgs zAddArgs, ScoredValue<V> ... scoredValues) {
        return this.createMono(() -> this.commandBuilder.zadd(key, zAddArgs, scoredValues));
    }

    @Override
    public Mono<Double> zaddincr(K key, double score, V member) {
        return this.createMono(() -> this.commandBuilder.zaddincr(key, null, score, member));
    }

    @Override
    public Mono<Double> zaddincr(K key, ZAddArgs zAddArgs, double score, V member) {
        return this.createMono(() -> this.commandBuilder.zaddincr(key, zAddArgs, score, member));
    }

    @Override
    public Mono<Long> zcard(K key) {
        return this.createMono(() -> this.commandBuilder.zcard(key));
    }

    @Override
    public Mono<Long> zcount(K key, double min, double max) {
        return this.createMono(() -> this.commandBuilder.zcount(key, min, max));
    }

    @Override
    public Mono<Long> zcount(K key, String min, String max) {
        return this.createMono(() -> this.commandBuilder.zcount(key, min, max));
    }

    @Override
    public Mono<Long> zcount(K key, Range<? extends Number> range) {
        return this.createMono(() -> this.commandBuilder.zcount(key, range));
    }

    @Override
    public Mono<Double> zincrby(K key, double amount, K member) {
        return this.createMono(() -> this.commandBuilder.zincrby(key, amount, member));
    }

    @Override
    public Mono<Long> zinterstore(K destination, K ... keys) {
        return this.createMono(() -> this.commandBuilder.zinterstore(destination, keys));
    }

    @Override
    public Mono<Long> zinterstore(K destination, ZStoreArgs storeArgs, K ... keys) {
        return this.createMono(() -> this.commandBuilder.zinterstore(destination, storeArgs, keys));
    }

    @Override
    public Mono<Long> zlexcount(K key, String min, String max) {
        return this.createMono(() -> this.commandBuilder.zlexcount(key, min, max));
    }

    @Override
    public Mono<Long> zlexcount(K key, Range<? extends V> range) {
        return this.createMono(() -> this.commandBuilder.zlexcount(key, range));
    }

    @Override
    public Flux<V> zrange(K key, long start, long stop) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrange(key, start, stop));
    }

    @Override
    public Mono<Long> zrange(ValueStreamingChannel<V> channel, K key, long start, long stop) {
        return this.createMono(() -> this.commandBuilder.zrange(channel, key, start, stop));
    }

    @Override
    public Flux<ScoredValue<V>> zrangeWithScores(K key, long start, long stop) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrangeWithScores(key, start, stop));
    }

    @Override
    public Mono<Long> zrangeWithScores(ScoredValueStreamingChannel<V> channel, K key, long start, long stop) {
        return this.createMono(() -> this.commandBuilder.zrangeWithScores(channel, key, start, stop));
    }

    @Override
    public Flux<V> zrangebylex(K key, String min, String max) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrangebylex(key, min, max));
    }

    @Override
    public Flux<V> zrangebylex(K key, Range<? extends V> range) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrangebylex(key, range, Limit.unlimited()));
    }

    @Override
    public Flux<V> zrangebylex(K key, String min, String max, long offset, long count) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrangebylex(key, min, max, offset, count));
    }

    @Override
    public Flux<V> zrangebylex(K key, Range<? extends V> range, Limit limit) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrangebylex(key, range, limit));
    }

    @Override
    public Flux<V> zrangebyscore(K key, double min, double max) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrangebyscore(key, min, max));
    }

    @Override
    public Flux<V> zrangebyscore(K key, String min, String max) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrangebyscore(key, min, max));
    }

    @Override
    public Flux<V> zrangebyscore(K key, double min, double max, long offset, long count) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrangebyscore(key, min, max, offset, count));
    }

    @Override
    public Flux<V> zrangebyscore(K key, String min, String max, long offset, long count) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrangebyscore(key, min, max, offset, count));
    }

    @Override
    public Flux<V> zrangebyscore(K key, Range<? extends Number> range) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrangebyscore(key, range, Limit.unlimited()));
    }

    @Override
    public Flux<V> zrangebyscore(K key, Range<? extends Number> range, Limit limit) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrangebyscore(key, range, limit));
    }

    @Override
    public Mono<Long> zrangebyscore(ValueStreamingChannel<V> channel, K key, double min, double max) {
        return this.createMono(() -> this.commandBuilder.zrangebyscore(channel, key, min, max));
    }

    @Override
    public Mono<Long> zrangebyscore(ValueStreamingChannel<V> channel, K key, String min, String max) {
        return this.createMono(() -> this.commandBuilder.zrangebyscore(channel, key, min, max));
    }

    @Override
    public Mono<Long> zrangebyscore(ValueStreamingChannel<V> channel, K key, double min, double max, long offset, long count) {
        return this.createMono(() -> this.commandBuilder.zrangebyscore(channel, key, min, max, offset, count));
    }

    @Override
    public Mono<Long> zrangebyscore(ValueStreamingChannel<V> channel, K key, Range<? extends Number> range) {
        return this.createMono(() -> this.commandBuilder.zrangebyscore(channel, key, range, Limit.unlimited()));
    }

    @Override
    public Mono<Long> zrangebyscore(ValueStreamingChannel<V> channel, K key, String min, String max, long offset, long count) {
        return this.createMono(() -> this.commandBuilder.zrangebyscore(channel, key, min, max, offset, count));
    }

    @Override
    public Mono<Long> zrangebyscore(ValueStreamingChannel<V> channel, K key, Range<? extends Number> range, Limit limit) {
        return this.createMono(() -> this.commandBuilder.zrangebyscore(channel, key, range, limit));
    }

    @Override
    public Flux<ScoredValue<V>> zrangebyscoreWithScores(K key, double min, double max) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrangebyscoreWithScores(key, min, max));
    }

    @Override
    public Flux<ScoredValue<V>> zrangebyscoreWithScores(K key, String min, String max) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrangebyscoreWithScores(key, min, max));
    }

    @Override
    public Flux<ScoredValue<V>> zrangebyscoreWithScores(K key, double min, double max, long offset, long count) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrangebyscoreWithScores(key, min, max, offset, count));
    }

    @Override
    public Flux<ScoredValue<V>> zrangebyscoreWithScores(K key, String min, String max, long offset, long count) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrangebyscoreWithScores(key, min, max, offset, count));
    }

    @Override
    public Flux<ScoredValue<V>> zrangebyscoreWithScores(K key, Range<? extends Number> range) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrangebyscoreWithScores(key, range, Limit.unlimited()));
    }

    @Override
    public Flux<ScoredValue<V>> zrangebyscoreWithScores(K key, Range<? extends Number> range, Limit limit) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrangebyscoreWithScores(key, range, limit));
    }

    @Override
    public Mono<Long> zrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, double min, double max) {
        return this.createMono(() -> this.commandBuilder.zrangebyscoreWithScores(channel, key, min, max));
    }

    @Override
    public Mono<Long> zrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, String min, String max) {
        return this.createMono(() -> this.commandBuilder.zrangebyscoreWithScores(channel, key, min, max));
    }

    @Override
    public Mono<Long> zrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, Range<? extends Number> range) {
        return this.createMono(() -> this.commandBuilder.zrangebyscoreWithScores(channel, key, range, Limit.unlimited()));
    }

    @Override
    public Mono<Long> zrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, double min, double max, long offset, long count) {
        return this.createMono(() -> this.commandBuilder.zrangebyscoreWithScores(channel, key, min, max, offset, count));
    }

    @Override
    public Mono<Long> zrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, String min, String max, long offset, long count) {
        return this.createMono(() -> this.commandBuilder.zrangebyscoreWithScores(channel, key, min, max, offset, count));
    }

    @Override
    public Mono<Long> zrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, Range<? extends Number> range, Limit limit) {
        return this.createMono(() -> this.commandBuilder.zrangebyscoreWithScores(channel, key, range, limit));
    }

    @Override
    public Mono<Long> zrank(K key, V member) {
        return this.createMono(() -> this.commandBuilder.zrank(key, member));
    }

    @Override
    public Mono<Long> zrem(K key, V ... members) {
        return this.createMono(() -> this.commandBuilder.zrem(key, members));
    }

    @Override
    public Mono<Long> zremrangebylex(K key, String min, String max) {
        return this.createMono(() -> this.commandBuilder.zremrangebylex(key, min, max));
    }

    @Override
    public Mono<Long> zremrangebylex(K key, Range<? extends V> range) {
        return this.createMono(() -> this.commandBuilder.zremrangebylex(key, range));
    }

    @Override
    public Mono<Long> zremrangebyrank(K key, long start, long stop) {
        return this.createMono(() -> this.commandBuilder.zremrangebyrank(key, start, stop));
    }

    @Override
    public Mono<Long> zremrangebyscore(K key, double min, double max) {
        return this.createMono(() -> this.commandBuilder.zremrangebyscore(key, min, max));
    }

    @Override
    public Mono<Long> zremrangebyscore(K key, String min, String max) {
        return this.createMono(() -> this.commandBuilder.zremrangebyscore(key, min, max));
    }

    @Override
    public Mono<Long> zremrangebyscore(K key, Range<? extends Number> range) {
        return this.createMono(() -> this.commandBuilder.zremrangebyscore(key, range));
    }

    @Override
    public Flux<V> zrevrange(K key, long start, long stop) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrevrange(key, start, stop));
    }

    @Override
    public Mono<Long> zrevrange(ValueStreamingChannel<V> channel, K key, long start, long stop) {
        return this.createMono(() -> this.commandBuilder.zrevrange(channel, key, start, stop));
    }

    @Override
    public Flux<ScoredValue<V>> zrevrangeWithScores(K key, long start, long stop) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrevrangeWithScores(key, start, stop));
    }

    @Override
    public Mono<Long> zrevrangeWithScores(ScoredValueStreamingChannel<V> channel, K key, long start, long stop) {
        return this.createMono(() -> this.commandBuilder.zrevrangeWithScores(channel, key, start, stop));
    }

    @Override
    public Flux<V> zrevrangebylex(K key, Range<? extends V> range) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrevrangebylex(key, range, Limit.unlimited()));
    }

    @Override
    public Flux<V> zrevrangebylex(K key, Range<? extends V> range, Limit limit) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrevrangebylex(key, range, limit));
    }

    @Override
    public Flux<V> zrevrangebyscore(K key, double max, double min) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrevrangebyscore(key, max, min));
    }

    @Override
    public Flux<V> zrevrangebyscore(K key, String max, String min) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrevrangebyscore(key, max, min));
    }

    @Override
    public Flux<V> zrevrangebyscore(K key, Range<? extends Number> range) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrevrangebyscore(key, range, Limit.unlimited()));
    }

    @Override
    public Flux<V> zrevrangebyscore(K key, double max, double min, long offset, long count) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrevrangebyscore(key, max, min, offset, count));
    }

    @Override
    public Flux<V> zrevrangebyscore(K key, String max, String min, long offset, long count) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrevrangebyscore(key, max, min, offset, count));
    }

    @Override
    public Flux<V> zrevrangebyscore(K key, Range<? extends Number> range, Limit limit) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrevrangebyscore(key, range, limit));
    }

    @Override
    public Mono<Long> zrevrangebyscore(ValueStreamingChannel<V> channel, K key, double max, double min) {
        return this.createMono(() -> this.commandBuilder.zrevrangebyscore(channel, key, max, min));
    }

    @Override
    public Mono<Long> zrevrangebyscore(ValueStreamingChannel<V> channel, K key, String max, String min) {
        return this.createMono(() -> this.commandBuilder.zrevrangebyscore(channel, key, max, min));
    }

    @Override
    public Mono<Long> zrevrangebyscore(ValueStreamingChannel<V> channel, K key, Range<? extends Number> range) {
        return this.createMono(() -> this.commandBuilder.zrevrangebyscore(channel, key, range, Limit.unlimited()));
    }

    @Override
    public Mono<Long> zrevrangebyscore(ValueStreamingChannel<V> channel, K key, double max, double min, long offset, long count) {
        return this.createMono(() -> this.commandBuilder.zrevrangebyscore(channel, key, max, min, offset, count));
    }

    @Override
    public Mono<Long> zrevrangebyscore(ValueStreamingChannel<V> channel, K key, String max, String min, long offset, long count) {
        return this.createMono(() -> this.commandBuilder.zrevrangebyscore(channel, key, max, min, offset, count));
    }

    @Override
    public Mono<Long> zrevrangebyscore(ValueStreamingChannel<V> channel, K key, Range<? extends Number> range, Limit limit) {
        return this.createMono(() -> this.commandBuilder.zrevrangebyscore(channel, key, range, limit));
    }

    @Override
    public Flux<ScoredValue<V>> zrevrangebyscoreWithScores(K key, double max, double min) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrevrangebyscoreWithScores(key, max, min));
    }

    @Override
    public Flux<ScoredValue<V>> zrevrangebyscoreWithScores(K key, String max, String min) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrevrangebyscoreWithScores(key, max, min));
    }

    @Override
    public Flux<ScoredValue<V>> zrevrangebyscoreWithScores(K key, Range<? extends Number> range) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrevrangebyscoreWithScores(key, range, Limit.unlimited()));
    }

    @Override
    public Flux<ScoredValue<V>> zrevrangebyscoreWithScores(K key, double max, double min, long offset, long count) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrevrangebyscoreWithScores(key, max, min, offset, count));
    }

    @Override
    public Flux<ScoredValue<V>> zrevrangebyscoreWithScores(K key, String max, String min, long offset, long count) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrevrangebyscoreWithScores(key, max, min, offset, count));
    }

    @Override
    public Flux<ScoredValue<V>> zrevrangebyscoreWithScores(K key, Range<? extends Number> range, Limit limit) {
        return this.createDissolvingFlux(() -> this.commandBuilder.zrevrangebyscoreWithScores(key, range, limit));
    }

    @Override
    public Mono<Long> zrevrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, double max, double min) {
        return this.createMono(() -> this.commandBuilder.zrevrangebyscoreWithScores(channel, key, max, min));
    }

    @Override
    public Mono<Long> zrevrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, String max, String min) {
        return this.createMono(() -> this.commandBuilder.zrevrangebyscoreWithScores(channel, key, max, min));
    }

    @Override
    public Mono<Long> zrevrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, Range<? extends Number> range) {
        return this.createMono(() -> this.commandBuilder.zrevrangebyscoreWithScores(channel, key, range, Limit.unlimited()));
    }

    @Override
    public Mono<Long> zrevrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, double max, double min, long offset, long count) {
        return this.createMono(() -> this.commandBuilder.zrevrangebyscoreWithScores(channel, key, max, min, offset, count));
    }

    @Override
    public Mono<Long> zrevrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, String max, String min, long offset, long count) {
        return this.createMono(() -> this.commandBuilder.zrevrangebyscoreWithScores(channel, key, max, min, offset, count));
    }

    @Override
    public Mono<Long> zrevrangebyscoreWithScores(ScoredValueStreamingChannel<V> channel, K key, Range<? extends Number> range, Limit limit) {
        return this.createMono(() -> this.commandBuilder.zrevrangebyscoreWithScores(channel, key, range, limit));
    }

    @Override
    public Mono<Long> zrevrank(K key, V member) {
        return this.createMono(() -> this.commandBuilder.zrevrank(key, member));
    }

    @Override
    public Mono<ScoredValueScanCursor<V>> zscan(K key) {
        return this.createMono(() -> this.commandBuilder.zscan(key));
    }

    @Override
    public Mono<ScoredValueScanCursor<V>> zscan(K key, ScanArgs scanArgs) {
        return this.createMono(() -> this.commandBuilder.zscan(key, scanArgs));
    }

    @Override
    public Mono<ScoredValueScanCursor<V>> zscan(K key, ScanCursor scanCursor, ScanArgs scanArgs) {
        return this.createMono(() -> this.commandBuilder.zscan(key, scanCursor, scanArgs));
    }

    @Override
    public Mono<ScoredValueScanCursor<V>> zscan(K key, ScanCursor scanCursor) {
        return this.createMono(() -> this.commandBuilder.zscan(key, scanCursor));
    }

    @Override
    public Mono<StreamScanCursor> zscan(ScoredValueStreamingChannel<V> channel, K key) {
        return this.createMono(() -> this.commandBuilder.zscanStreaming(channel, key));
    }

    @Override
    public Mono<StreamScanCursor> zscan(ScoredValueStreamingChannel<V> channel, K key, ScanArgs scanArgs) {
        return this.createMono(() -> this.commandBuilder.zscanStreaming(channel, key, scanArgs));
    }

    @Override
    public Mono<StreamScanCursor> zscan(ScoredValueStreamingChannel<V> channel, K key, ScanCursor scanCursor, ScanArgs scanArgs) {
        return this.createMono(() -> this.commandBuilder.zscanStreaming(channel, key, scanCursor, scanArgs));
    }

    @Override
    public Mono<StreamScanCursor> zscan(ScoredValueStreamingChannel<V> channel, K key, ScanCursor scanCursor) {
        return this.createMono(() -> this.commandBuilder.zscanStreaming(channel, key, scanCursor));
    }

    @Override
    public Mono<Double> zscore(K key, V member) {
        return this.createMono(() -> this.commandBuilder.zscore(key, member));
    }

    @Override
    public Mono<Long> zunionstore(K destination, K ... keys) {
        return this.createMono(() -> this.commandBuilder.zunionstore(destination, keys));
    }

    @Override
    public Mono<Long> zunionstore(K destination, ZStoreArgs storeArgs, K ... keys) {
        return this.createMono(() -> this.commandBuilder.zunionstore(destination, storeArgs, keys));
    }
}

