/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.cluster;

import io.lettuce.core.ClientOptions;
import io.lettuce.core.RedisChannelWriter;
import io.lettuce.core.RedisException;
import io.lettuce.core.protocol.DefaultEndpoint;
import io.lettuce.core.protocol.RedisCommand;
import io.lettuce.core.resource.ClientResources;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.Collection;

class ClusterNodeEndpoint
extends DefaultEndpoint {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ClusterNodeEndpoint.class);
    private final RedisChannelWriter clusterChannelWriter;

    public ClusterNodeEndpoint(ClientOptions clientOptions, ClientResources clientResources, RedisChannelWriter clusterChannelWriter) {
        super(clientOptions);
        this.clusterChannelWriter = clusterChannelWriter;
    }

    @Override
    public void close() {
        logger.debug("{} close()", (Object)this.logPrefix());
        if (this.clusterChannelWriter != null) {
            this.retriggerCommands(this.doExclusive(this::drainCommands));
        }
        super.close();
    }

    protected void retriggerCommands(Collection<RedisCommand<?, ?, ?>> commands) {
        for (RedisCommand<?, ?, ?> queuedCommand : commands) {
            if (queuedCommand == null || queuedCommand.isCancelled()) continue;
            try {
                this.clusterChannelWriter.write(queuedCommand);
            }
            catch (RedisException e) {
                queuedCommand.completeExceptionally(e);
            }
        }
    }
}

