/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.protocol;

import io.lettuce.core.ClientOptions;
import io.lettuce.core.RedisChannelInitializer;
import io.lettuce.core.RedisCommandTimeoutException;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.internal.LettuceSets;
import io.lettuce.core.protocol.ChannelLogDescriptor;
import io.lettuce.core.protocol.ConnectionFacade;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.ConnectException;
import java.net.SocketAddress;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;

class ReconnectionHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ReconnectionHandler.class);
    private static final Set<Class<?>> EXECUTION_EXCEPTION_TYPES = LettuceSets.unmodifiableSet(TimeoutException.class, CancellationException.class, RedisCommandTimeoutException.class, ConnectException.class);
    private final ClientOptions clientOptions;
    private final Bootstrap bootstrap;
    private final Supplier<SocketAddress> socketAddressSupplier;
    private final Timer timer;
    private final ExecutorService reconnectWorkers;
    private final ConnectionFacade connectionFacade;
    private TimeUnit timeoutUnit = TimeUnit.SECONDS;
    private long timeout = 60L;
    private volatile ChannelFuture currentFuture;
    private volatile boolean reconnectSuspended;

    ReconnectionHandler(ClientOptions clientOptions, Bootstrap bootstrap, Supplier<SocketAddress> socketAddressSupplier, Timer timer, ExecutorService reconnectWorkers, ConnectionFacade connectionFacade) {
        LettuceAssert.notNull(socketAddressSupplier, "SocketAddressSupplier must not be null");
        LettuceAssert.notNull(bootstrap, "Bootstrap must not be null");
        LettuceAssert.notNull(timer, "Timer must not be null");
        LettuceAssert.notNull(reconnectWorkers, "ExecutorService must not be null");
        LettuceAssert.notNull(connectionFacade, "ConnectionFacade must not be null");
        this.socketAddressSupplier = socketAddressSupplier;
        this.bootstrap = bootstrap;
        this.clientOptions = clientOptions;
        this.timer = timer;
        this.reconnectWorkers = reconnectWorkers;
        this.connectionFacade = connectionFacade;
    }

    protected ChannelFuture reconnect() {
        SocketAddress remoteAddress = this.socketAddressSupplier.get();
        logger.debug("Reconnecting to Redis at {}", (Object)remoteAddress);
        ChannelFuture connectFuture = this.bootstrap.connect(remoteAddress);
        ChannelPromise initFuture = connectFuture.channel().newPromise();
        initFuture.addListener(it -> {
            if (it.cause() != null) {
                connectFuture.cancel(true);
                this.close(it.channel());
            }
        });
        connectFuture.addListener(it -> {
            if (it.cause() != null) {
                initFuture.tryFailure(it.cause());
                return;
            }
            ChannelPipeline pipeline = it.channel().pipeline();
            RedisChannelInitializer channelInitializer = (RedisChannelInitializer)pipeline.get(RedisChannelInitializer.class);
            if (channelInitializer == null) {
                initFuture.tryFailure((Throwable)new IllegalStateException("Reconnection attempt without a RedisChannelInitializer in the channel pipeline"));
                return;
            }
            channelInitializer.channelInitialized().whenComplete((state, throwable) -> {
                if (throwable != null) {
                    if (ReconnectionHandler.isExecutionException(throwable)) {
                        initFuture.tryFailure(throwable);
                        return;
                    }
                    if (this.clientOptions.isCancelCommandsOnReconnectFailure()) {
                        this.connectionFacade.reset();
                    }
                    if (this.clientOptions.isSuspendReconnectOnProtocolFailure()) {
                        logger.error("Disabling autoReconnect due to initialization failure", throwable);
                        this.setReconnectSuspended(true);
                    }
                    initFuture.tryFailure(throwable);
                    return;
                }
                if (logger.isDebugEnabled()) {
                    logger.info("Reconnected to {}, Channel {}", (Object)remoteAddress, (Object)ChannelLogDescriptor.logDescriptor(it.channel()));
                } else {
                    logger.info("Reconnected to {}", (Object)remoteAddress);
                }
                initFuture.trySuccess();
            });
        });
        Runnable timeoutAction = () -> initFuture.tryFailure((Throwable)new TimeoutException(String.format("Reconnection attempt exceeded timeout of %d %s ", new Object[]{this.timeout, this.timeoutUnit})));
        Timeout timeoutHandle = this.timer.newTimeout(it -> {
            if (connectFuture.isDone() && initFuture.isDone()) {
                return;
            }
            if (this.reconnectWorkers.isShutdown()) {
                timeoutAction.run();
                return;
            }
            this.reconnectWorkers.submit(timeoutAction);
        }, this.timeout, this.timeoutUnit);
        initFuture.addListener(it -> timeoutHandle.cancel());
        this.currentFuture = initFuture;
        return this.currentFuture;
    }

    private void close(Channel channel) {
        if (channel != null) {
            channel.close();
        }
    }

    boolean isReconnectSuspended() {
        return this.reconnectSuspended;
    }

    void setReconnectSuspended(boolean reconnectSuspended) {
        this.reconnectSuspended = reconnectSuspended;
    }

    long getTimeout() {
        return this.timeout;
    }

    void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    void prepareClose() {
        ChannelFuture currentFuture = this.currentFuture;
        if (currentFuture != null && !currentFuture.isDone()) {
            currentFuture.cancel(true);
        }
    }

    public static boolean isExecutionException(Throwable throwable) {
        for (Class<?> type : EXECUTION_EXCEPTION_TYPES) {
            if (!type.isAssignableFrom(throwable.getClass())) continue;
            return true;
        }
        return false;
    }

    ClientOptions getClientOptions() {
        return this.clientOptions;
    }
}

