/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.pubsub;

import io.lettuce.core.ClientOptions;
import io.lettuce.core.protocol.DefaultEndpoint;
import io.lettuce.core.pubsub.PubSubOutput;
import io.lettuce.core.pubsub.RedisPubSubListener;
import io.netty.util.internal.ConcurrentSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

public class PubSubEndpoint<K, V>
extends DefaultEndpoint {
    private final List<RedisPubSubListener<K, V>> listeners = new CopyOnWriteArrayList<RedisPubSubListener<K, V>>();
    private final Set<K> channels = new ConcurrentSet();
    private final Set<K> patterns = new ConcurrentSet();

    public PubSubEndpoint(ClientOptions clientOptions) {
        super(clientOptions);
    }

    public void addListener(RedisPubSubListener<K, V> listener) {
        this.listeners.add(listener);
    }

    public void removeListener(RedisPubSubListener<K, V> listener) {
        this.listeners.remove(listener);
    }

    protected List<RedisPubSubListener<K, V>> getListeners() {
        return this.listeners;
    }

    public Set<K> getChannels() {
        return this.channels;
    }

    public Set<K> getPatterns() {
        return this.patterns;
    }

    public void notifyMessage(PubSubOutput<K, V, V> output) {
        if (output.type() == null || output.pattern() == null && output.channel() == null && output.get() == null) {
            return;
        }
        this.updateInternalState(output);
        this.notifyListeners(output);
    }

    protected void notifyListeners(PubSubOutput<K, V, V> output) {
        block8: for (RedisPubSubListener redisPubSubListener : this.listeners) {
            switch (output.type()) {
                case message: {
                    redisPubSubListener.message(output.channel(), output.get());
                    continue block8;
                }
                case pmessage: {
                    redisPubSubListener.message(output.pattern(), output.channel(), output.get());
                    continue block8;
                }
                case psubscribe: {
                    redisPubSubListener.psubscribed(output.pattern(), output.count());
                    continue block8;
                }
                case punsubscribe: {
                    redisPubSubListener.punsubscribed(output.pattern(), output.count());
                    continue block8;
                }
                case subscribe: {
                    redisPubSubListener.subscribed(output.channel(), output.count());
                    continue block8;
                }
                case unsubscribe: {
                    redisPubSubListener.unsubscribed(output.channel(), output.count());
                    continue block8;
                }
            }
            throw new UnsupportedOperationException("Operation " + (Object)((Object)output.type()) + " not supported");
        }
    }

    private void updateInternalState(PubSubOutput<K, V, V> output) {
        switch (output.type()) {
            case psubscribe: {
                this.patterns.add(output.pattern());
                break;
            }
            case punsubscribe: {
                this.patterns.remove(output.pattern());
                break;
            }
            case subscribe: {
                this.channels.add(output.channel());
                break;
            }
            case unsubscribe: {
                this.channels.remove(output.channel());
                break;
            }
        }
    }
}

