/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.ExceptionFactory;
import io.lettuce.core.Operators;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.output.StreamingOutput;
import io.lettuce.core.protocol.CommandWrapper;
import io.lettuce.core.protocol.DemandAware;
import io.lettuce.core.protocol.RedisCommand;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.Collection;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Exceptions;
import reactor.util.context.Context;

class RedisPublisher<K, V, T>
implements Publisher<T> {
    private static final InternalLogger LOG = InternalLoggerFactory.getInstance(RedisPublisher.class);
    private final boolean traceEnabled = LOG.isTraceEnabled();
    private final Supplier<? extends RedisCommand<K, V, T>> commandSupplier;
    private final AtomicReference<RedisCommand<K, V, T>> ref;
    private final StatefulConnection<K, V> connection;
    private final boolean dissolve;

    public RedisPublisher(RedisCommand<K, V, T> staticCommand, StatefulConnection<K, V> connection, boolean dissolve) {
        this(() -> staticCommand, connection, dissolve);
    }

    public RedisPublisher(Supplier<RedisCommand<K, V, T>> commandSupplier, StatefulConnection<K, V> connection, boolean dissolve) {
        LettuceAssert.notNull(commandSupplier, "CommandSupplier must not be null");
        LettuceAssert.notNull(connection, "StatefulConnection must not be null");
        this.commandSupplier = commandSupplier;
        this.connection = connection;
        this.dissolve = dissolve;
        this.ref = new AtomicReference<RedisCommand<K, RedisCommand<K, V, T>, T>>(commandSupplier.get());
    }

    public void subscribe(Subscriber<? super T> subscriber) {
        RedisCommand<K, V, T> command;
        if (this.traceEnabled) {
            LOG.trace("subscribe: {}@{}", (Object)subscriber.getClass().getName(), (Object)Objects.hashCode(subscriber));
        }
        if ((command = this.ref.get()) != null) {
            if (!this.ref.compareAndSet(command, null)) {
                command = this.commandSupplier.get();
            }
        } else {
            command = this.commandSupplier.get();
        }
        RedisSubscription<T> redisSubscription = new RedisSubscription<T>(this.connection, command, this.dissolve);
        redisSubscription.subscribe(subscriber);
    }

    private static class CompositeSubscriber<T>
    extends StreamingOutput.Subscriber<T> {
        private final StreamingOutput.Subscriber<T> first;
        private final StreamingOutput.Subscriber<T> second;

        public CompositeSubscriber(StreamingOutput.Subscriber<T> first, StreamingOutput.Subscriber<T> second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public void onNext(T t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void onNext(Collection<T> outputTarget, T t) {
            this.first.onNext(outputTarget, t);
            this.second.onNext(outputTarget, t);
        }
    }

    private static class SubscriptionCommand<K, V, T>
    extends CommandWrapper<K, V, T>
    implements DemandAware.Sink {
        private final boolean dissolve;
        private final RedisSubscription<T> subscription;
        private volatile boolean completed = false;
        private volatile DemandAware.Source source;

        public SubscriptionCommand(RedisCommand<K, V, T> command, RedisSubscription<T> subscription, boolean dissolve) {
            super(command);
            this.subscription = subscription;
            this.dissolve = dissolve;
        }

        @Override
        public boolean hasDemand() {
            return this.completed || this.subscription.state() == State.COMPLETED || this.subscription.data.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void complete() {
            if (this.completed) {
                return;
            }
            try {
                super.complete();
                if (this.getOutput() != null) {
                    Object result = this.getOutput().get();
                    if (this.getOutput().hasError()) {
                        this.onError(ExceptionFactory.createExecutionException(this.getOutput().getError()));
                        this.completed = true;
                        return;
                    }
                    if (!(this.getOutput() instanceof StreamingOutput) && result != null) {
                        if (this.dissolve && result instanceof Collection) {
                            Collection collection = (Collection)result;
                            for (Object t : collection) {
                                if (t == null) continue;
                                this.subscription.onNext(t);
                            }
                        } else {
                            this.subscription.onNext(result);
                        }
                    }
                }
                this.subscription.onAllDataRead();
            }
            finally {
                this.completed = true;
            }
        }

        @Override
        public void setSource(DemandAware.Source source) {
            this.source = source;
        }

        @Override
        public void removeSource() {
            this.source = null;
        }

        @Override
        public void cancel() {
            if (this.completed) {
                return;
            }
            super.cancel();
            this.completed = true;
        }

        @Override
        public boolean completeExceptionally(Throwable throwable) {
            if (this.completed) {
                return false;
            }
            boolean b = super.completeExceptionally(throwable);
            this.onError(throwable);
            this.completed = true;
            return b;
        }

        private void onError(Throwable throwable) {
            this.subscription.onError(throwable);
        }
    }

    private static enum State {
        UNSUBSCRIBED{

            @Override
            void subscribe(RedisSubscription<?> subscription, Subscriber<?> subscriber) {
                LettuceAssert.notNull(subscriber, "Subscriber must not be null");
                if (!subscription.changeState(this, NO_DEMAND)) {
                    throw new IllegalStateException(this.toString());
                }
                subscription.subscriber = subscriber;
                subscriber.onSubscribe(subscription);
            }
        }
        ,
        NO_DEMAND{

            @Override
            void request(RedisSubscription<?> subscription, long n) {
                if (Operators.request(RedisSubscription.DEMAND, subscription, n)) {
                    if (subscription.changeState(this, DEMAND)) {
                        try {
                            subscription.checkCommandDispatch();
                        }
                        catch (Exception ex) {
                            subscription.onError(ex);
                        }
                        subscription.checkOnDataAvailable();
                    }
                    subscription.potentiallyReadMore();
                    if (subscription.allDataRead) {
                        this.onAllDataRead(subscription);
                    }
                } else {
                    this.onError(subscription, Exceptions.nullOrNegativeRequestException((long)n));
                }
            }
        }
        ,
        DEMAND{

            @Override
            void onDataAvailable(RedisSubscription<?> subscription) {
                do {
                    if (this.read(subscription)) continue;
                    return;
                } while (subscription.hasDemand() && subscription.changeState(NO_DEMAND, this));
            }

            @Override
            void request(RedisSubscription<?> subscription, long n) {
                if (Operators.request(RedisSubscription.DEMAND, subscription, n)) {
                    if (subscription.changeState(NO_DEMAND, DEMAND)) {
                        this.read(subscription);
                    }
                    subscription.potentiallyReadMore();
                } else {
                    this.onError(subscription, Exceptions.nullOrNegativeRequestException((long)n));
                }
            }

            private boolean read(RedisSubscription<?> subscription) {
                if (subscription.changeState(this, READING)) {
                    boolean hasDemand = subscription.readAndPublish();
                    if (subscription.allDataRead && subscription.data.isEmpty()) {
                        subscription.onAllDataRead();
                        return true;
                    }
                    if (hasDemand) {
                        subscription.changeState(READING, DEMAND);
                        subscription.checkOnDataAvailable();
                    } else {
                        subscription.changeState(READING, NO_DEMAND);
                    }
                    return true;
                }
                return false;
            }
        }
        ,
        READING{

            @Override
            void request(RedisSubscription<?> subscription, long n) {
                DEMAND.request(subscription, n);
            }
        }
        ,
        COMPLETED{

            @Override
            void request(RedisSubscription<?> subscription, long n) {
            }

            @Override
            void cancel(RedisSubscription<?> subscription) {
            }

            @Override
            void onAllDataRead(RedisSubscription<?> subscription) {
            }

            @Override
            void onError(RedisSubscription<?> subscription, Throwable t) {
            }
        };


        void subscribe(RedisSubscription<?> subscription, Subscriber<?> subscriber) {
            throw new IllegalStateException(this.toString());
        }

        void request(RedisSubscription<?> subscription, long n) {
            throw new IllegalStateException(this.toString());
        }

        void cancel(RedisSubscription<?> subscription) {
            subscription.command.cancel();
            if (subscription.changeState(this, COMPLETED)) {
                this.readData(subscription);
            }
        }

        void readData(RedisSubscription<?> subscription) {
            DemandAware.Source source = ((RedisSubscription)subscription).subscriptionCommand.source;
            if (source != null) {
                source.requestMore();
            }
        }

        void onDataAvailable(RedisSubscription<?> subscription) {
        }

        void onAllDataRead(RedisSubscription<?> subscription) {
            subscription.allDataRead = true;
            if (subscription.data.isEmpty() && subscription.complete()) {
                this.readData(subscription);
                Subscriber subscriber = subscription.subscriber;
                if (subscriber != null) {
                    subscriber.onComplete();
                }
            }
        }

        void onError(RedisSubscription<?> subscription, Throwable t) {
            if (subscription.changeState(this, COMPLETED)) {
                this.readData(subscription);
                Subscriber subscriber = subscription.subscriber;
                if (subscriber != null) {
                    subscriber.onError(t);
                }
            }
        }
    }

    private static enum CommandDispatch {
        UNDISPATCHED{

            @Override
            void dispatch(RedisSubscription<?> redisSubscription) {
                if (RedisSubscription.COMMAND_DISPATCH.compareAndSet(redisSubscription, this, DISPATCHED)) {
                    redisSubscription.dispatchCommand();
                }
            }
        }
        ,
        DISPATCHED;


        void dispatch(RedisSubscription<?> redisSubscription) {
        }
    }

    static class RedisSubscription<T>
    extends StreamingOutput.Subscriber<T>
    implements Subscription {
        static final InternalLogger LOG = InternalLoggerFactory.getInstance(RedisPublisher.class);
        static final int ST_PROGRESS = 0;
        static final int ST_COMPLETED = 1;
        static final AtomicLongFieldUpdater<RedisSubscription> DEMAND = AtomicLongFieldUpdater.newUpdater(RedisSubscription.class, "demand");
        static final AtomicReferenceFieldUpdater<RedisSubscription, State> STATE = AtomicReferenceFieldUpdater.newUpdater(RedisSubscription.class, State.class, "state");
        static final AtomicReferenceFieldUpdater<RedisSubscription, CommandDispatch> COMMAND_DISPATCH = AtomicReferenceFieldUpdater.newUpdater(RedisSubscription.class, CommandDispatch.class, "commandDispatch");
        static final AtomicIntegerFieldUpdater<RedisSubscription> COMPLETION = AtomicIntegerFieldUpdater.newUpdater(RedisSubscription.class, "completion");
        private final SubscriptionCommand<?, ?, T> subscriptionCommand;
        private final boolean traceEnabled = LOG.isTraceEnabled();
        final Queue<T> data = Operators.newQueue();
        final StatefulConnection<?, ?> connection;
        final RedisCommand<?, ?, T> command;
        final boolean dissolve;
        volatile long demand;
        volatile State state = State.UNSUBSCRIBED;
        volatile int completion = 0;
        volatile CommandDispatch commandDispatch = CommandDispatch.UNDISPATCHED;
        volatile boolean allDataRead = false;
        volatile Subscriber<? super T> subscriber;

        RedisSubscription(StatefulConnection<?, ?> connection, RedisCommand<?, ?, T> command, boolean dissolve) {
            LettuceAssert.notNull(connection, "Connection must not be null");
            LettuceAssert.notNull(command, "RedisCommand must not be null");
            this.connection = connection;
            this.command = command;
            this.dissolve = dissolve;
            if (command.getOutput() instanceof StreamingOutput) {
                StreamingOutput streamingOutput = (StreamingOutput)((Object)command.getOutput());
                if (connection instanceof StatefulRedisConnection && ((StatefulRedisConnection)connection).isMulti()) {
                    streamingOutput.setSubscriber(new CompositeSubscriber(this, streamingOutput.getSubscriber()));
                } else {
                    streamingOutput.setSubscriber(this);
                }
            }
            this.subscriptionCommand = new SubscriptionCommand(command, this, dissolve);
        }

        void subscribe(Subscriber<? super T> subscriber) {
            if (subscriber == null) {
                throw new NullPointerException("Subscriber must not be null");
            }
            State state = this.state();
            if (this.traceEnabled) {
                LOG.trace("{} subscribe: {}@{}", new Object[]{state, subscriber.getClass().getName(), subscriber.hashCode()});
            }
            state.subscribe(this, subscriber);
        }

        public final void request(long n) {
            State state = this.state();
            if (this.traceEnabled) {
                LOG.trace("{} request: {}", (Object)state, (Object)n);
            }
            state.request(this, n);
        }

        public final void cancel() {
            State state = this.state();
            if (this.traceEnabled) {
                LOG.trace("{} cancel", (Object)state);
            }
            state.cancel(this);
        }

        @Override
        public void onNext(T t) {
            long initial;
            LettuceAssert.notNull(t, "Data must not be null");
            State state = this.state();
            if (state == State.COMPLETED) {
                return;
            }
            if (state == State.DEMAND && this.data.isEmpty() && (initial = this.getDemand()) > 0L && DEMAND.compareAndSet(this, initial, initial - 1L)) {
                try {
                    this.subscriber.onNext(t);
                }
                catch (Exception e) {
                    this.onError(e);
                }
                return;
            }
            if (!this.data.offer(t)) {
                Subscriber<? super T> subscriber = this.subscriber;
                Context context = Context.empty();
                if (subscriber instanceof CoreSubscriber) {
                    context = ((CoreSubscriber)subscriber).currentContext();
                }
                Throwable e = Operators.onOperatorError(this, Exceptions.failWithOverflow(), t, context);
                this.onError(e);
                return;
            }
            this.onDataAvailable();
        }

        final void onDataAvailable() {
            State state = this.state();
            if (this.traceEnabled) {
                LOG.trace("{} onDataAvailable()", (Object)state);
            }
            state.onDataAvailable(this);
        }

        final void onAllDataRead() {
            State state = this.state();
            if (this.traceEnabled) {
                LOG.trace("{} onAllDataRead()", (Object)state);
            }
            state.onAllDataRead(this);
        }

        final void onError(Throwable t) {
            State state = this.state();
            if (LOG.isErrorEnabled()) {
                LOG.trace("{} onError(): {}", new Object[]{state, t.toString(), t});
            }
            state.onError(this, t);
        }

        protected T read() {
            return this.data.poll();
        }

        boolean hasDemand() {
            return this.getDemand() > 0L;
        }

        private long getDemand() {
            return DEMAND.get(this);
        }

        boolean changeState(State oldState, State newState) {
            return STATE.compareAndSet(this, oldState, newState);
        }

        public boolean complete() {
            if (COMPLETION.compareAndSet(this, 0, 1)) {
                STATE.set(this, State.COMPLETED);
                return true;
            }
            return false;
        }

        void checkCommandDispatch() {
            COMMAND_DISPATCH.get(this).dispatch(this);
        }

        void dispatchCommand() {
            this.connection.dispatch(this.subscriptionCommand);
        }

        void checkOnDataAvailable() {
            if (this.data.isEmpty()) {
                this.potentiallyReadMore();
            }
            if (!this.data.isEmpty()) {
                this.onDataAvailable();
            }
        }

        void potentiallyReadMore() {
            if (this.getDemand() + 1L > (long)this.data.size()) {
                this.state().readData(this);
            }
        }

        boolean readAndPublish() {
            while (this.hasDemand()) {
                long initial = this.getDemand();
                if (!RedisSubscription.hasDemand(initial)) {
                    return false;
                }
                T data = this.read();
                if (data == null) {
                    return RedisSubscription.hasDemand(initial);
                }
                boolean success = DEMAND.compareAndSet(this, initial, initial - 1L);
                if (!success) continue;
                this.subscriber.onNext(data);
            }
            return false;
        }

        private static boolean hasDemand(long n) {
            return n > 0L;
        }

        State state() {
            return STATE.get(this);
        }
    }
}

