/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.cluster;

import io.lettuce.core.AbstractRedisClient;
import io.lettuce.core.ReadFrom;
import io.lettuce.core.RedisChannelHandler;
import io.lettuce.core.RedisChannelWriter;
import io.lettuce.core.RedisException;
import io.lettuce.core.RedisURI;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.cluster.AsyncClusterConnectionProvider;
import io.lettuce.core.cluster.ClusterConnectionProvider;
import io.lettuce.core.cluster.ClusterDistributionChannelWriter;
import io.lettuce.core.cluster.ClusterFutureSyncInvocationHandler;
import io.lettuce.core.cluster.RedisAdvancedClusterAsyncCommandsImpl;
import io.lettuce.core.cluster.RedisAdvancedClusterReactiveCommandsImpl;
import io.lettuce.core.cluster.RedisState;
import io.lettuce.core.cluster.api.StatefulRedisClusterConnection;
import io.lettuce.core.cluster.api.async.RedisAdvancedClusterAsyncCommands;
import io.lettuce.core.cluster.api.async.RedisClusterAsyncCommands;
import io.lettuce.core.cluster.api.reactive.RedisAdvancedClusterReactiveCommands;
import io.lettuce.core.cluster.api.sync.NodeSelection;
import io.lettuce.core.cluster.api.sync.NodeSelectionCommands;
import io.lettuce.core.cluster.api.sync.RedisAdvancedClusterCommands;
import io.lettuce.core.cluster.models.partitions.Partitions;
import io.lettuce.core.cluster.models.partitions.RedisClusterNode;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.codec.StringCodec;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.output.StatusOutput;
import io.lettuce.core.protocol.AsyncCommand;
import io.lettuce.core.protocol.Command;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CommandArgsAccessor;
import io.lettuce.core.protocol.CommandKeyword;
import io.lettuce.core.protocol.CommandType;
import io.lettuce.core.protocol.CompleteableCommand;
import io.lettuce.core.protocol.RedisCommand;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public class StatefulRedisClusterConnectionImpl<K, V>
extends RedisChannelHandler<K, V>
implements StatefulRedisClusterConnection<K, V> {
    private Partitions partitions;
    private char[] password;
    private boolean readOnly;
    private String clientName;
    protected final RedisCodec<K, V> codec;
    protected final RedisAdvancedClusterCommands<K, V> sync;
    protected final RedisAdvancedClusterAsyncCommandsImpl<K, V> async;
    protected final RedisAdvancedClusterReactiveCommandsImpl<K, V> reactive;
    private volatile RedisState state;

    public StatefulRedisClusterConnectionImpl(RedisChannelWriter writer, RedisCodec<K, V> codec, Duration timeout) {
        super(writer, timeout);
        this.codec = codec;
        this.async = new RedisAdvancedClusterAsyncCommandsImpl<K, V>(this, codec);
        this.sync = (RedisAdvancedClusterCommands)Proxy.newProxyInstance(AbstractRedisClient.class.getClassLoader(), new Class[]{RedisAdvancedClusterCommands.class}, this.syncInvocationHandler());
        this.reactive = new RedisAdvancedClusterReactiveCommandsImpl<K, V>(this, codec);
    }

    @Override
    public RedisAdvancedClusterCommands<K, V> sync() {
        return this.sync;
    }

    protected InvocationHandler syncInvocationHandler() {
        return new ClusterFutureSyncInvocationHandler(this, RedisClusterAsyncCommands.class, NodeSelection.class, NodeSelectionCommands.class, this.async());
    }

    @Override
    public RedisAdvancedClusterAsyncCommands<K, V> async() {
        return this.async;
    }

    @Override
    public RedisAdvancedClusterReactiveCommands<K, V> reactive() {
        return this.reactive;
    }

    RedisState getState() {
        return this.state;
    }

    void setState(RedisState state) {
        this.state = state;
    }

    private RedisURI lookup(String nodeId) {
        for (RedisClusterNode partition : this.partitions) {
            if (!partition.getNodeId().equals(nodeId)) continue;
            return partition.getUri();
        }
        return null;
    }

    @Override
    public StatefulRedisConnection<K, V> getConnection(String nodeId) {
        RedisURI redisURI = this.lookup(nodeId);
        if (redisURI == null) {
            throw new RedisException("NodeId " + nodeId + " does not belong to the cluster");
        }
        return this.getClusterDistributionChannelWriter().getClusterConnectionProvider().getConnection(ClusterConnectionProvider.Intent.WRITE, nodeId);
    }

    @Override
    public CompletableFuture<StatefulRedisConnection<K, V>> getConnectionAsync(String nodeId) {
        RedisURI redisURI = this.lookup(nodeId);
        if (redisURI == null) {
            throw new RedisException("NodeId " + nodeId + " does not belong to the cluster");
        }
        AsyncClusterConnectionProvider provider = (AsyncClusterConnectionProvider)((Object)this.getClusterDistributionChannelWriter().getClusterConnectionProvider());
        return provider.getConnectionAsync(ClusterConnectionProvider.Intent.WRITE, nodeId);
    }

    @Override
    public StatefulRedisConnection<K, V> getConnection(String host, int port) {
        return this.getClusterDistributionChannelWriter().getClusterConnectionProvider().getConnection(ClusterConnectionProvider.Intent.WRITE, host, port);
    }

    @Override
    public CompletableFuture<StatefulRedisConnection<K, V>> getConnectionAsync(String host, int port) {
        AsyncClusterConnectionProvider provider = (AsyncClusterConnectionProvider)((Object)this.getClusterDistributionChannelWriter().getClusterConnectionProvider());
        return provider.getConnectionAsync(ClusterConnectionProvider.Intent.WRITE, host, port);
    }

    ClusterDistributionChannelWriter getClusterDistributionChannelWriter() {
        return (ClusterDistributionChannelWriter)super.getChannelWriter();
    }

    @Override
    public void activated() {
        super.activated();
        if (this.password != null) {
            this.async.authAsync(this.password);
        }
        if (this.clientName != null) {
            this.setClientName(this.clientName);
        }
        if (this.readOnly) {
            this.async.readOnly();
        }
    }

    void setClientName(String clientName) {
        CommandArgs<String, String> args = new CommandArgs<String, String>(StringCodec.UTF8).add(CommandKeyword.SETNAME).addValue(clientName);
        AsyncCommand async = new AsyncCommand(new Command(CommandType.CLIENT, new StatusOutput<String, String>(StringCodec.UTF8), args));
        this.clientName = clientName;
        this.dispatch(async);
    }

    @Override
    public <T> RedisCommand<K, V, T> dispatch(RedisCommand<K, V, T> command) {
        return super.dispatch(this.preProcessCommand(command));
    }

    @Override
    public Collection<RedisCommand<K, V, ?>> dispatch(Collection<? extends RedisCommand<K, V, ?>> commands) {
        ArrayList commandsToSend = new ArrayList(commands.size());
        for (RedisCommand<K, V, ?> command : commands) {
            commandsToSend.add(this.preProcessCommand(command));
        }
        return super.dispatch(commandsToSend);
    }

    private <T> RedisCommand<K, V, T> preProcessCommand(RedisCommand<K, V, T> command) {
        RedisCommand<K, V, Object> local = command;
        if (local.getType().name().equals(CommandType.AUTH.name())) {
            local = this.attachOnComplete(local, status -> {
                if (status.equals("OK")) {
                    char[] password = CommandArgsAccessor.getFirstCharArray(command.getArgs());
                    if (password != null) {
                        this.password = password;
                    } else {
                        String stringPassword = CommandArgsAccessor.getFirstString(command.getArgs());
                        if (stringPassword != null) {
                            this.password = stringPassword.toCharArray();
                        }
                    }
                }
            });
        }
        if (local.getType().name().equals(CommandType.READONLY.name())) {
            local = this.attachOnComplete(local, status -> {
                if (status.equals("OK")) {
                    this.readOnly = true;
                }
            });
        }
        if (local.getType().name().equals(CommandType.READWRITE.name())) {
            local = this.attachOnComplete(local, status -> {
                if (status.equals("OK")) {
                    this.readOnly = false;
                }
            });
        }
        return local;
    }

    private <T> RedisCommand<K, V, T> attachOnComplete(RedisCommand<K, V, T> command, Consumer<T> consumer) {
        if (command instanceof CompleteableCommand) {
            CompleteableCommand completeable = (CompleteableCommand)((Object)command);
            completeable.onComplete(consumer);
        }
        return command;
    }

    public void setPartitions(Partitions partitions) {
        this.partitions = partitions;
        this.getClusterDistributionChannelWriter().setPartitions(partitions);
    }

    @Override
    public Partitions getPartitions() {
        return this.partitions;
    }

    @Override
    public void setReadFrom(ReadFrom readFrom) {
        LettuceAssert.notNull((Object)readFrom, "ReadFrom must not be null");
        this.getClusterDistributionChannelWriter().setReadFrom(readFrom);
    }

    @Override
    public ReadFrom getReadFrom() {
        return this.getClusterDistributionChannelWriter().getReadFrom();
    }
}

