/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.cluster;

import io.lettuce.core.AbstractRedisClient;
import io.lettuce.core.RedisChannelWriter;
import io.lettuce.core.RedisException;
import io.lettuce.core.RedisURI;
import io.lettuce.core.cluster.AsyncClusterConnectionProvider;
import io.lettuce.core.cluster.ClusterConnectionProvider;
import io.lettuce.core.cluster.ClusterDistributionChannelWriter;
import io.lettuce.core.cluster.ClusterFutureSyncInvocationHandler;
import io.lettuce.core.cluster.PubSubClusterEndpoint;
import io.lettuce.core.cluster.RedisClusterPubSubAsyncCommandsImpl;
import io.lettuce.core.cluster.RedisClusterPubSubReactiveCommandsImpl;
import io.lettuce.core.cluster.RedisState;
import io.lettuce.core.cluster.models.partitions.Partitions;
import io.lettuce.core.cluster.models.partitions.RedisClusterNode;
import io.lettuce.core.cluster.pubsub.RedisClusterPubSubListener;
import io.lettuce.core.cluster.pubsub.StatefulRedisClusterPubSubConnection;
import io.lettuce.core.cluster.pubsub.api.async.RedisClusterPubSubAsyncCommands;
import io.lettuce.core.cluster.pubsub.api.reactive.RedisClusterPubSubReactiveCommands;
import io.lettuce.core.cluster.pubsub.api.sync.NodeSelectionPubSubCommands;
import io.lettuce.core.cluster.pubsub.api.sync.PubSubNodeSelection;
import io.lettuce.core.cluster.pubsub.api.sync.RedisClusterPubSubCommands;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.pubsub.RedisPubSubAsyncCommandsImpl;
import io.lettuce.core.pubsub.RedisPubSubReactiveCommandsImpl;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnectionImpl;
import io.lettuce.core.pubsub.api.async.RedisPubSubAsyncCommands;
import io.lettuce.core.pubsub.api.sync.RedisPubSubCommands;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;

class StatefulRedisClusterPubSubConnectionImpl<K, V>
extends StatefulRedisPubSubConnectionImpl<K, V>
implements StatefulRedisClusterPubSubConnection<K, V> {
    private final PubSubClusterEndpoint<K, V> endpoint;
    private volatile Partitions partitions;
    private volatile RedisState state;

    public StatefulRedisClusterPubSubConnectionImpl(PubSubClusterEndpoint<K, V> endpoint, RedisChannelWriter writer, RedisCodec<K, V> codec, Duration timeout) {
        super(endpoint, writer, codec, timeout);
        this.endpoint = endpoint;
    }

    @Override
    public RedisClusterPubSubAsyncCommands<K, V> async() {
        return (RedisClusterPubSubAsyncCommands)super.async();
    }

    @Override
    protected RedisPubSubAsyncCommandsImpl<K, V> newRedisAsyncCommandsImpl() {
        return new RedisClusterPubSubAsyncCommandsImpl(this, this.codec);
    }

    @Override
    public RedisClusterPubSubCommands<K, V> sync() {
        return (RedisClusterPubSubCommands)super.sync();
    }

    @Override
    protected RedisPubSubCommands<K, V> newRedisSyncCommandsImpl() {
        return (RedisPubSubCommands)Proxy.newProxyInstance(AbstractRedisClient.class.getClassLoader(), new Class[]{RedisClusterPubSubCommands.class, RedisPubSubCommands.class}, this.syncInvocationHandler());
    }

    private InvocationHandler syncInvocationHandler() {
        return new ClusterFutureSyncInvocationHandler(this, RedisPubSubAsyncCommands.class, PubSubNodeSelection.class, NodeSelectionPubSubCommands.class, this.async());
    }

    @Override
    public RedisClusterPubSubReactiveCommands<K, V> reactive() {
        return (RedisClusterPubSubReactiveCommands)super.reactive();
    }

    @Override
    protected RedisPubSubReactiveCommandsImpl<K, V> newRedisReactiveCommandsImpl() {
        return new RedisClusterPubSubReactiveCommandsImpl(this, this.codec);
    }

    RedisState getState() {
        return this.state;
    }

    void setState(RedisState state) {
        this.state = state;
    }

    @Override
    public void activated() {
        super.activated();
        this.async().clusterMyId().thenAccept(nodeId -> this.endpoint.setClusterNode(this.partitions.getPartitionByNodeId((String)nodeId)));
    }

    @Override
    public StatefulRedisPubSubConnection<K, V> getConnection(String nodeId) {
        RedisURI redisURI = this.lookup(nodeId);
        if (redisURI == null) {
            throw new RedisException("NodeId " + nodeId + " does not belong to the cluster");
        }
        return (StatefulRedisPubSubConnection)this.getClusterDistributionChannelWriter().getClusterConnectionProvider().getConnection(ClusterConnectionProvider.Intent.WRITE, nodeId);
    }

    @Override
    public CompletableFuture<StatefulRedisPubSubConnection<K, V>> getConnectionAsync(String nodeId) {
        RedisURI redisURI = this.lookup(nodeId);
        if (redisURI == null) {
            throw new RedisException("NodeId " + nodeId + " does not belong to the cluster");
        }
        AsyncClusterConnectionProvider provider = (AsyncClusterConnectionProvider)((Object)this.getClusterDistributionChannelWriter().getClusterConnectionProvider());
        return provider.getConnectionAsync(ClusterConnectionProvider.Intent.WRITE, nodeId);
    }

    @Override
    public StatefulRedisPubSubConnection<K, V> getConnection(String host, int port) {
        return (StatefulRedisPubSubConnection)this.getClusterDistributionChannelWriter().getClusterConnectionProvider().getConnection(ClusterConnectionProvider.Intent.WRITE, host, port);
    }

    @Override
    public CompletableFuture<StatefulRedisPubSubConnection<K, V>> getConnectionAsync(String host, int port) {
        AsyncClusterConnectionProvider provider = (AsyncClusterConnectionProvider)((Object)this.getClusterDistributionChannelWriter().getClusterConnectionProvider());
        return provider.getConnectionAsync(ClusterConnectionProvider.Intent.WRITE, host, port);
    }

    public void setPartitions(Partitions partitions) {
        this.partitions = partitions;
        this.getClusterDistributionChannelWriter().setPartitions(partitions);
    }

    @Override
    public Partitions getPartitions() {
        return this.partitions;
    }

    @Override
    public void setNodeMessagePropagation(boolean enabled) {
        this.endpoint.setNodeMessagePropagation(enabled);
    }

    @Override
    public void addListener(RedisClusterPubSubListener<K, V> listener) {
        this.endpoint.addListener(listener);
    }

    @Override
    public void removeListener(RedisClusterPubSubListener<K, V> listener) {
        this.endpoint.removeListener(listener);
    }

    RedisClusterPubSubListener<K, V> getUpstreamListener() {
        return this.endpoint.getUpstreamListener();
    }

    protected ClusterDistributionChannelWriter getClusterDistributionChannelWriter() {
        return (ClusterDistributionChannelWriter)super.getChannelWriter();
    }

    private RedisURI lookup(String nodeId) {
        for (RedisClusterNode partition : this.partitions) {
            if (!partition.getNodeId().equals(nodeId)) continue;
            return partition.getUri();
        }
        return null;
    }
}

