/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.ConnectionBuilder;
import io.lettuce.core.RedisURI;
import io.lettuce.core.SslOptions;
import io.lettuce.core.internal.HostAndPort;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.resource.ClientResources;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.function.Supplier;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;

public class SslConnectionBuilder
extends ConnectionBuilder {
    private RedisURI redisURI;

    public SslConnectionBuilder ssl(RedisURI redisURI) {
        this.redisURI = redisURI;
        return this;
    }

    public static SslConnectionBuilder sslConnectionBuilder() {
        return new SslConnectionBuilder();
    }

    @Override
    protected List<ChannelHandler> buildHandlers() {
        LettuceAssert.assertState(this.redisURI != null, "RedisURI must not be null");
        LettuceAssert.assertState(this.redisURI.isSsl(), "RedisURI is not configured for SSL (ssl is false)");
        return super.buildHandlers();
    }

    @Override
    public ChannelInitializer<Channel> build(SocketAddress socketAddress) {
        return new SslChannelInitializer(this::buildHandlers, SslConnectionBuilder.toHostAndPort(socketAddress), this.redisURI.isVerifyPeer(), this.redisURI.isStartTls(), this.clientResources(), this.clientOptions().getSslOptions());
    }

    static HostAndPort toHostAndPort(SocketAddress socketAddress) {
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress isa = (InetSocketAddress)socketAddress;
            return HostAndPort.of(isa.getHostString(), isa.getPort());
        }
        return null;
    }

    static class SslChannelInitializer
    extends ChannelInitializer<Channel> {
        private final Supplier<List<ChannelHandler>> handlers;
        private final HostAndPort hostAndPort;
        private final boolean verifyPeer;
        private final boolean startTls;
        private final ClientResources clientResources;
        private final SslOptions sslOptions;

        public SslChannelInitializer(Supplier<List<ChannelHandler>> handlers, HostAndPort hostAndPort, boolean verifyPeer, boolean startTls, ClientResources clientResources, SslOptions sslOptions) {
            this.handlers = handlers;
            this.hostAndPort = hostAndPort;
            this.verifyPeer = verifyPeer;
            this.startTls = startTls;
            this.clientResources = clientResources;
            this.sslOptions = sslOptions;
        }

        protected void initChannel(Channel channel) throws Exception {
            SSLEngine sslEngine = this.initializeSSLEngine(channel.alloc());
            SslHandler sslHandler = new SslHandler(sslEngine, this.startTls);
            channel.pipeline().addLast(new ChannelHandler[]{sslHandler});
            for (ChannelHandler handler : this.handlers.get()) {
                channel.pipeline().addLast(new ChannelHandler[]{handler});
            }
            this.clientResources.nettyCustomizer().afterChannelInitialized(channel);
        }

        private SSLEngine initializeSSLEngine(ByteBufAllocator alloc) throws IOException, GeneralSecurityException {
            SSLParameters sslParams = this.sslOptions.createSSLParameters();
            SslContextBuilder sslContextBuilder = this.sslOptions.createSslContextBuilder();
            if (this.verifyPeer) {
                sslParams.setEndpointIdentificationAlgorithm("HTTPS");
            } else {
                sslContextBuilder.trustManager(InsecureTrustManagerFactory.INSTANCE);
            }
            SslContext sslContext = sslContextBuilder.build();
            SSLEngine sslEngine = this.hostAndPort != null ? sslContext.newEngine(alloc, this.hostAndPort.getHostText(), this.hostAndPort.getPort()) : sslContext.newEngine(alloc);
            sslEngine.setSSLParameters(sslParams);
            return sslEngine;
        }
    }
}

