/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.protocol;

import io.lettuce.core.LettuceStrings;
import io.lettuce.core.output.CommandOutput;
import io.lettuce.core.protocol.ProtocolVersion;
import io.lettuce.core.protocol.RedisCommand;
import io.lettuce.core.protocol.RedisProtocolException;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.ByteProcessor;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;

public class RedisStateMachine {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(RedisStateMachine.class);
    private static final ByteBuffer QUEUED = StandardCharsets.US_ASCII.encode("QUEUED");
    private static final int TERMINATOR_LENGTH = 2;
    private static final int NOT_FOUND = -1;
    private final State[] stack = new State[32];
    private final boolean debugEnabled = logger.isDebugEnabled();
    private final ByteBuf responseElementBuffer;
    private final AtomicBoolean closed = new AtomicBoolean();
    private final Resp2LongProcessor longProcessor = new Resp2LongProcessor();
    private ProtocolVersion protocolVersion = null;
    private int stackElements;

    public RedisStateMachine(ByteBufAllocator alloc) {
        this.responseElementBuffer = alloc.buffer(1024);
    }

    public boolean isDiscoverProtocol() {
        return this.protocolVersion == null;
    }

    public ProtocolVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setProtocolVersion(ProtocolVersion protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public boolean decode(ByteBuf buffer, CommandOutput<?, ?, ?> output) {
        return this.decode(buffer, null, output);
    }

    public boolean decode(ByteBuf buffer, RedisCommand<?, ?, ?> command, CommandOutput<?, ?, ?> output) {
        buffer.touch((Object)"RedisStateMachine.decode(\u2026)");
        if (this.debugEnabled) {
            logger.debug("Decode {}", command);
        }
        if (this.isEmpty(this.stack)) {
            this.add(this.stack, new State());
        }
        if (output == null) {
            return this.isEmpty(this.stack);
        }
        boolean resp3Indicator = false;
        block20: while (!this.isEmpty(this.stack)) {
            State state = this.peek(this.stack);
            if (state.type == null) {
                if (!buffer.isReadable()) break;
                state.type = this.readReplyType(buffer);
                if (state.type == State.Type.HELLO_V3 || state.type == State.Type.MAP) {
                    resp3Indicator = true;
                }
                buffer.markReaderIndex();
            }
            switch (state.type) {
                case SINGLE: {
                    ByteBuffer bytes = this.readLine(buffer);
                    if (bytes == null) break block20;
                    if (QUEUED.equals(bytes)) break;
                    this.safeSetSingle(output, bytes, command);
                    break;
                }
                case BIG_NUMBER: {
                    ByteBuffer bytes = this.readLine(buffer);
                    if (bytes == null) break block20;
                    this.safeSetBigNumber(output, bytes, command);
                    break;
                }
                case ERROR: {
                    ByteBuffer bytes = this.readLine(buffer);
                    if (bytes == null) break block20;
                    this.safeSetError(output, bytes, command);
                    break;
                }
                case NULL: {
                    ByteBuffer bytes = this.readLine(buffer);
                    if (bytes == null) break block20;
                    this.safeSet(output, null, command);
                    break;
                }
                case INTEGER: {
                    int end = this.findLineEnd(buffer);
                    if (end == -1) break block20;
                    long integer = this.readLong(buffer, buffer.readerIndex(), end);
                    this.safeSet(output, integer, command);
                    break;
                }
                case BOOLEAN: {
                    int end = this.findLineEnd(buffer);
                    if (end == -1) break block20;
                    boolean value = this.readBoolean(buffer);
                    this.safeSet(output, value, command);
                    break;
                }
                case FLOAT: {
                    int end = this.findLineEnd(buffer);
                    if (end == -1) break block20;
                    double f = this.readFloat(buffer, buffer.readerIndex(), end);
                    this.safeSet(output, f, command);
                    break;
                }
                case BULK: 
                case VERBATIM: {
                    int end = this.findLineEnd(buffer);
                    if (end == -1) break block20;
                    int length = (int)this.readLong(buffer, buffer.readerIndex(), end);
                    if (length == -1) {
                        this.safeSet(output, null, command);
                        break;
                    }
                    state.type = state.type == State.Type.VERBATIM ? State.Type.VERBATIM_STRING : State.Type.BYTES;
                    state.count = length + 2;
                    buffer.markReaderIndex();
                    continue block20;
                }
                case BULK_ERROR: {
                    int end = this.findLineEnd(buffer);
                    if (end == -1) break block20;
                    int length = (int)this.readLong(buffer, buffer.readerIndex(), end);
                    if (length == -1) {
                        this.safeSetError(output, null, command);
                        break;
                    }
                    state.type = State.Type.BYTES;
                    state.count = length + 2;
                    buffer.markReaderIndex();
                    continue block20;
                }
                case MULTI: 
                case PUSH: 
                case MAP: 
                case SET: 
                case HELLO_V3: {
                    int length;
                    int end;
                    if (state.count == -1) {
                        end = this.findLineEnd(buffer);
                        if (end == -1) break block20;
                        state.count = length = (int)this.readLong(buffer, buffer.readerIndex(), end);
                        buffer.markReaderIndex();
                        switch (state.type) {
                            case MULTI: 
                            case PUSH: {
                                this.safeMultiArray(output, state.count, command);
                                break;
                            }
                            case MAP: {
                                this.safeMultiMap(output, state.count, command);
                                state.count = length * 2;
                                break;
                            }
                            case SET: {
                                this.safeMultiSet(output, state.count, command);
                            }
                        }
                    }
                    if (state.count <= 0) break;
                    --state.count;
                    this.addFirst(this.stack, new State());
                    continue block20;
                }
                case VERBATIM_STRING: {
                    ByteBuffer bytes = this.readBytes(buffer, state.count);
                    if (bytes == null) break block20;
                    bytes.position(bytes.position() + 4);
                    this.safeSet(output, bytes, command);
                    break;
                }
                case BYTES: {
                    ByteBuffer bytes = this.readBytes(buffer, state.count);
                    if (bytes == null) break block20;
                    this.safeSet(output, bytes, command);
                    break;
                }
                case ATTRIBUTE: {
                    throw new RedisProtocolException("Not implemented");
                }
                default: {
                    throw new RedisProtocolException("State " + (Object)((Object)state.type) + " not supported");
                }
            }
            buffer.markReaderIndex();
            this.remove(this.stack);
            output.complete(this.size(this.stack));
        }
        if (this.debugEnabled) {
            logger.debug("Decoded {}, empty stack: {}", command, (Object)this.isEmpty(this.stack));
        }
        if (this.isDiscoverProtocol()) {
            if (resp3Indicator) {
                this.setProtocolVersion(ProtocolVersion.RESP3);
            } else {
                this.setProtocolVersion(ProtocolVersion.RESP2);
            }
        }
        return this.isEmpty(this.stack);
    }

    public void reset() {
        Arrays.fill(this.stack, null);
        this.stackElements = 0;
    }

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.responseElementBuffer.release();
        }
    }

    private int findLineEnd(ByteBuf buffer) {
        int index = buffer.forEachByte(ByteProcessor.FIND_LF);
        return index > 0 && buffer.getByte(index - 1) == 13 ? index - 1 : -1;
    }

    private State.Type readReplyType(ByteBuf buffer) {
        return this.getType(buffer.readerIndex(), buffer.readByte());
    }

    private State.Type getType(int index, byte b) {
        switch (b) {
            case 43: {
                return State.Type.SINGLE;
            }
            case 45: {
                return State.Type.ERROR;
            }
            case 58: {
                return State.Type.INTEGER;
            }
            case 44: {
                return State.Type.FLOAT;
            }
            case 35: {
                return State.Type.BOOLEAN;
            }
            case 61: {
                return State.Type.VERBATIM;
            }
            case 40: {
                return State.Type.BIG_NUMBER;
            }
            case 37: {
                return State.Type.MAP;
            }
            case 126: {
                return State.Type.SET;
            }
            case 124: {
                return State.Type.ATTRIBUTE;
            }
            case 64: {
                return State.Type.HELLO_V3;
            }
            case 36: {
                return State.Type.BULK;
            }
            case 42: {
                return State.Type.MULTI;
            }
            case 62: {
                return State.Type.PUSH;
            }
            case 95: {
                return State.Type.NULL;
            }
        }
        throw new RedisProtocolException("Invalid first byte: " + b + " (" + new String(new byte[]{b}) + ") at buffer index " + index + " decoding using " + (Object)((Object)this.getProtocolVersion()));
    }

    private long readLong(ByteBuf buffer, int start, int end) {
        return this.longProcessor.getValue(buffer, start, end);
    }

    private double readFloat(ByteBuf buffer, int start, int end) {
        int valueLength = end - start;
        String value = buffer.toString(start, valueLength, StandardCharsets.US_ASCII);
        buffer.skipBytes(valueLength + 2);
        return LettuceStrings.toDouble(value);
    }

    private boolean readBoolean(ByteBuf buffer) {
        byte b = buffer.readByte();
        buffer.skipBytes(2);
        switch (b) {
            case 116: {
                return true;
            }
            case 102: {
                return false;
            }
        }
        throw new RedisProtocolException("Unexpected BOOLEAN value: " + b);
    }

    private ByteBuffer readLine(ByteBuf buffer) {
        ByteBuffer bytes = null;
        int end = this.findLineEnd(buffer);
        if (end > -1) {
            bytes = this.readBytes0(buffer, end - buffer.readerIndex());
            buffer.skipBytes(2);
            buffer.markReaderIndex();
        }
        return bytes;
    }

    private ByteBuffer readBytes(ByteBuf buffer, int count) {
        if (buffer.readableBytes() >= count) {
            ByteBuffer byteBuffer = this.readBytes0(buffer, count - 2);
            buffer.skipBytes(2);
            buffer.markReaderIndex();
            return byteBuffer;
        }
        return null;
    }

    private ByteBuffer readBytes0(ByteBuf buffer, int count) {
        this.responseElementBuffer.clear();
        if (this.responseElementBuffer.capacity() < count) {
            this.responseElementBuffer.capacity(count);
        }
        buffer.readBytes(this.responseElementBuffer, count);
        ByteBuffer bytes = this.responseElementBuffer.internalNioBuffer(0, count);
        return bytes;
    }

    private void remove(State[] stack) {
        stack[this.stackElements - 1] = null;
        --this.stackElements;
    }

    private void addFirst(State[] stack, State state) {
        stack[this.stackElements++] = state;
    }

    private State peek(State[] stack) {
        return stack[this.stackElements - 1];
    }

    private void add(State[] stack, State state) {
        if (this.stackElements != 0) {
            System.arraycopy(stack, 0, stack, 1, this.stackElements);
        }
        stack[0] = state;
        ++this.stackElements;
    }

    private int size(State[] stack) {
        return this.stackElements;
    }

    private boolean isEmpty(State[] stack) {
        return this.stackElements == 0;
    }

    protected void safeSet(CommandOutput<?, ?, ?> output, boolean value, RedisCommand<?, ?, ?> command) {
        try {
            output.set(value);
        }
        catch (Exception e) {
            command.completeExceptionally(e);
        }
    }

    protected void safeSet(CommandOutput<?, ?, ?> output, long number, RedisCommand<?, ?, ?> command) {
        try {
            output.set(number);
        }
        catch (Exception e) {
            command.completeExceptionally(e);
        }
    }

    protected void safeSet(CommandOutput<?, ?, ?> output, double number, RedisCommand<?, ?, ?> command) {
        try {
            output.set(number);
        }
        catch (Exception e) {
            command.completeExceptionally(e);
        }
    }

    protected void safeSet(CommandOutput<?, ?, ?> output, ByteBuffer bytes, RedisCommand<?, ?, ?> command) {
        try {
            output.set(bytes);
        }
        catch (Exception e) {
            command.completeExceptionally(e);
        }
    }

    protected void safeSetSingle(CommandOutput<?, ?, ?> output, ByteBuffer bytes, RedisCommand<?, ?, ?> command) {
        try {
            output.set(bytes);
        }
        catch (Exception e) {
            command.completeExceptionally(e);
        }
    }

    protected void safeSetBigNumber(CommandOutput<?, ?, ?> output, ByteBuffer bytes, RedisCommand<?, ?, ?> command) {
        try {
            output.setBigNumber(bytes);
        }
        catch (Exception e) {
            command.completeExceptionally(e);
        }
    }

    protected void safeMultiArray(CommandOutput<?, ?, ?> output, int count, RedisCommand<?, ?, ?> command) {
        try {
            output.multiArray(count);
        }
        catch (Exception e) {
            command.completeExceptionally(e);
        }
    }

    protected void safeMultiPush(CommandOutput<?, ?, ?> output, int count, RedisCommand<?, ?, ?> command) {
        try {
            output.multiPush(count);
        }
        catch (Exception e) {
            command.completeExceptionally(e);
        }
    }

    protected void safeMultiSet(CommandOutput<?, ?, ?> output, int count, RedisCommand<?, ?, ?> command) {
        try {
            output.multiSet(count);
        }
        catch (Exception e) {
            command.completeExceptionally(e);
        }
    }

    protected void safeMultiMap(CommandOutput<?, ?, ?> output, int count, RedisCommand<?, ?, ?> command) {
        try {
            output.multiMap(count);
        }
        catch (Exception e) {
            command.completeExceptionally(e);
        }
    }

    protected void safeSetError(CommandOutput<?, ?, ?> output, ByteBuffer bytes, RedisCommand<?, ?, ?> command) {
        try {
            output.setError(bytes);
        }
        catch (Exception e) {
            command.completeExceptionally(e);
        }
    }

    static class Resp2LongProcessor
    implements ByteProcessor {
        long result;
        boolean negative;
        boolean first;

        Resp2LongProcessor() {
        }

        public long getValue(ByteBuf buffer, int start, int end) {
            this.result = 0L;
            this.first = true;
            int length = end - start;
            buffer.forEachByte(start, length, (ByteProcessor)this);
            if (!this.negative) {
                this.result = -this.result;
            }
            buffer.skipBytes(length + 2);
            return this.result;
        }

        public boolean process(byte value) {
            if (this.first) {
                this.first = false;
                if (value == 45) {
                    this.negative = true;
                } else {
                    this.negative = false;
                    int digit = value - 48;
                    this.result = this.result * 10L - (long)digit;
                }
                return true;
            }
            int digit = value - 48;
            this.result = this.result * 10L - (long)digit;
            return true;
        }
    }

    static class State {
        Type type = null;
        int count = -1;

        State() {
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getClass().getSimpleName());
            sb.append(" [type=").append((Object)this.type);
            sb.append(", count=").append(this.count);
            sb.append(']');
            return sb.toString();
        }

        static enum Type {
            SINGLE,
            ERROR,
            INTEGER,
            FLOAT,
            BOOLEAN,
            BULK_ERROR,
            VERBATIM,
            VERBATIM_STRING,
            BIG_NUMBER,
            MAP,
            SET,
            ATTRIBUTE,
            PUSH,
            HELLO_V3,
            NULL,
            BULK,
            MULTI,
            BYTES;

        }
    }
}

