/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.resource;

import io.lettuce.core.event.EventBus;
import io.lettuce.core.event.EventPublisherOptions;
import io.lettuce.core.metrics.CommandLatencyCollector;
import io.lettuce.core.metrics.CommandLatencyCollectorOptions;
import io.lettuce.core.resource.DefaultClientResources;
import io.lettuce.core.resource.Delay;
import io.lettuce.core.resource.DnsResolver;
import io.lettuce.core.resource.EventLoopGroupProvider;
import io.lettuce.core.resource.NettyCustomizer;
import io.lettuce.core.resource.SocketAddressResolver;
import io.lettuce.core.tracing.Tracing;
import io.netty.util.Timer;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public interface ClientResources {
    public static ClientResources create() {
        return DefaultClientResources.create();
    }

    public static Builder builder() {
        return DefaultClientResources.builder();
    }

    public Builder mutate();

    public Future<Boolean> shutdown();

    public Future<Boolean> shutdown(long var1, long var3, TimeUnit var5);

    public EventPublisherOptions commandLatencyPublisherOptions();

    public CommandLatencyCollector commandLatencyCollector();

    public int computationThreadPoolSize();

    public DnsResolver dnsResolver();

    public EventBus eventBus();

    public EventLoopGroupProvider eventLoopGroupProvider();

    public EventExecutorGroup eventExecutorGroup();

    public int ioThreadPoolSize();

    public NettyCustomizer nettyCustomizer();

    public Delay reconnectDelay();

    public SocketAddressResolver socketAddressResolver();

    public Timer timer();

    public Tracing tracing();

    public static interface Builder {
        public Builder commandLatencyCollector(CommandLatencyCollector var1);

        public Builder commandLatencyCollectorOptions(CommandLatencyCollectorOptions var1);

        public Builder commandLatencyPublisherOptions(EventPublisherOptions var1);

        public Builder computationThreadPoolSize(int var1);

        public Builder dnsResolver(DnsResolver var1);

        public Builder eventBus(EventBus var1);

        public Builder eventExecutorGroup(EventExecutorGroup var1);

        public Builder eventLoopGroupProvider(EventLoopGroupProvider var1);

        public Builder ioThreadPoolSize(int var1);

        public Builder nettyCustomizer(NettyCustomizer var1);

        public Builder reconnectDelay(Delay var1);

        public Builder reconnectDelay(Supplier<Delay> var1);

        public Builder socketAddressResolver(SocketAddressResolver var1);

        public Builder timer(Timer var1);

        public Builder tracing(Tracing var1);

        public ClientResources build();
    }
}

