/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.resource;

import io.lettuce.core.event.DefaultEventBus;
import io.lettuce.core.event.DefaultEventPublisherOptions;
import io.lettuce.core.event.EventBus;
import io.lettuce.core.event.EventPublisherOptions;
import io.lettuce.core.event.metrics.DefaultCommandLatencyEventPublisher;
import io.lettuce.core.event.metrics.MetricEventPublisher;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.internal.LettuceLists;
import io.lettuce.core.metrics.CommandLatencyCollector;
import io.lettuce.core.metrics.CommandLatencyCollectorOptions;
import io.lettuce.core.metrics.DefaultCommandLatencyCollector;
import io.lettuce.core.metrics.DefaultCommandLatencyCollectorOptions;
import io.lettuce.core.resource.ClientResources;
import io.lettuce.core.resource.DefaultEventLoopGroupProvider;
import io.lettuce.core.resource.DefaultNettyCustomizer;
import io.lettuce.core.resource.Delay;
import io.lettuce.core.resource.DnsResolver;
import io.lettuce.core.resource.DnsResolvers;
import io.lettuce.core.resource.EventLoopGroupProvider;
import io.lettuce.core.resource.NettyCustomizer;
import io.lettuce.core.resource.PromiseAdapter;
import io.lettuce.core.resource.SocketAddressResolver;
import io.lettuce.core.tracing.Tracing;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timer;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseCombiner;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import reactor.core.scheduler.Schedulers;

public class DefaultClientResources
implements ClientResources {
    protected static final InternalLogger logger;
    public static final int MIN_IO_THREADS = 2;
    public static final int MIN_COMPUTATION_THREADS = 2;
    public static final int DEFAULT_IO_THREADS;
    public static final int DEFAULT_COMPUTATION_THREADS;
    public static final Supplier<Delay> DEFAULT_RECONNECT_DELAY;
    public static final NettyCustomizer DEFAULT_NETTY_CUSTOMIZER;
    private final CommandLatencyCollector commandLatencyCollector;
    private final boolean sharedCommandLatencyCollector;
    private final EventPublisherOptions commandLatencyPublisherOptions;
    private final DnsResolver dnsResolver;
    private final EventBus eventBus;
    private final boolean sharedEventLoopGroupProvider;
    private final EventLoopGroupProvider eventLoopGroupProvider;
    private final boolean sharedEventExecutor;
    private final EventExecutorGroup eventExecutorGroup;
    private final MetricEventPublisher metricEventPublisher;
    private final NettyCustomizer nettyCustomizer;
    private final Supplier<Delay> reconnectDelay;
    private final SocketAddressResolver socketAddressResolver;
    private final Timer timer;
    private final boolean sharedTimer;
    private final Tracing tracing;
    private volatile boolean shutdownCalled = false;

    protected DefaultClientResources(Builder builder) {
        if (builder.eventLoopGroupProvider == null) {
            int ioThreadPoolSize = builder.ioThreadPoolSize;
            if (ioThreadPoolSize < 2) {
                logger.info("ioThreadPoolSize is less than {} ({}), setting to: {}", new Object[]{2, ioThreadPoolSize, 2});
                ioThreadPoolSize = 2;
            }
            this.sharedEventLoopGroupProvider = false;
            this.eventLoopGroupProvider = new DefaultEventLoopGroupProvider(ioThreadPoolSize);
        } else {
            this.sharedEventLoopGroupProvider = builder.sharedEventLoopGroupProvider;
            this.eventLoopGroupProvider = builder.eventLoopGroupProvider;
        }
        if (builder.eventExecutorGroup == null) {
            int computationThreadPoolSize = builder.computationThreadPoolSize;
            if (computationThreadPoolSize < 2) {
                logger.info("computationThreadPoolSize is less than {} ({}), setting to: {}", new Object[]{2, computationThreadPoolSize, 2});
                computationThreadPoolSize = 2;
            }
            this.eventExecutorGroup = DefaultEventLoopGroupProvider.createEventLoopGroup(DefaultEventExecutorGroup.class, computationThreadPoolSize);
            this.sharedEventExecutor = false;
        } else {
            this.sharedEventExecutor = builder.sharedEventExecutor;
            this.eventExecutorGroup = builder.eventExecutorGroup;
        }
        if (builder.timer == null) {
            this.timer = new HashedWheelTimer((ThreadFactory)new DefaultThreadFactory("lettuce-timer"));
            this.sharedTimer = false;
        } else {
            this.timer = builder.timer;
            this.sharedTimer = builder.sharedTimer;
        }
        this.eventBus = builder.eventBus == null ? new DefaultEventBus(Schedulers.fromExecutor((Executor)this.eventExecutorGroup)) : builder.eventBus;
        if (builder.commandLatencyCollector == null) {
            if (DefaultCommandLatencyCollector.isAvailable()) {
                this.commandLatencyCollector = builder.commandLatencyCollectorOptions != null ? CommandLatencyCollector.create(builder.commandLatencyCollectorOptions) : CommandLatencyCollector.create(CommandLatencyCollectorOptions.create());
            } else {
                logger.debug("LatencyUtils/HdrUtils are not available, metrics are disabled");
                builder.commandLatencyCollectorOptions = CommandLatencyCollectorOptions.disabled();
                this.commandLatencyCollector = CommandLatencyCollector.disabled();
            }
            this.sharedCommandLatencyCollector = false;
        } else {
            this.sharedCommandLatencyCollector = builder.sharedCommandLatencyCollector;
            this.commandLatencyCollector = builder.commandLatencyCollector;
        }
        this.commandLatencyPublisherOptions = builder.commandLatencyPublisherOptions;
        this.metricEventPublisher = this.commandLatencyCollector.isEnabled() && this.commandLatencyPublisherOptions != null ? new DefaultCommandLatencyEventPublisher(this.eventExecutorGroup, this.commandLatencyPublisherOptions, this.eventBus, this.commandLatencyCollector) : null;
        this.dnsResolver = builder.dnsResolver == null ? DnsResolvers.UNRESOLVED : builder.dnsResolver;
        this.socketAddressResolver = builder.socketAddressResolver == null ? SocketAddressResolver.create(this.dnsResolver) : builder.socketAddressResolver;
        this.reconnectDelay = builder.reconnectDelay;
        this.nettyCustomizer = builder.nettyCustomizer;
        this.tracing = builder.tracing;
    }

    public static DefaultClientResources create() {
        return DefaultClientResources.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Builder mutate() {
        Builder builder = new Builder();
        ((Builder)builder.commandLatencyCollector(this.commandLatencyCollector()).commandLatencyPublisherOptions(this.commandLatencyPublisherOptions()).dnsResolver(this.dnsResolver()).eventBus(this.eventBus()).eventExecutorGroup(this.eventExecutorGroup()).reconnectDelay((Supplier)this.reconnectDelay)).socketAddressResolver(this.socketAddressResolver()).nettyCustomizer(this.nettyCustomizer()).timer(this.timer()).tracing(this.tracing());
        builder.sharedCommandLatencyCollector = this.sharedEventLoopGroupProvider;
        builder.sharedEventExecutor = this.sharedEventExecutor;
        builder.sharedEventLoopGroupProvider = this.sharedEventLoopGroupProvider;
        builder.sharedTimer = this.sharedTimer;
        return builder;
    }

    protected void finalize() throws Throwable {
        if (!this.shutdownCalled) {
            logger.warn(this.getClass().getName() + " was not shut down properly, shutdown() was not called before it's garbage-collected. Call shutdown() or shutdown(long,long,TimeUnit) ");
        }
        super.finalize();
    }

    @Override
    public Future<Boolean> shutdown() {
        return this.shutdown(0L, 2L, TimeUnit.SECONDS);
    }

    @Override
    public Future<Boolean> shutdown(long quietPeriod, long timeout, TimeUnit timeUnit) {
        Future shutdown;
        logger.debug("Initiate shutdown ({}, {}, {})", new Object[]{quietPeriod, timeout, timeUnit});
        this.shutdownCalled = true;
        DefaultPromise voidPromise = new DefaultPromise((EventExecutor)ImmediateEventExecutor.INSTANCE);
        PromiseCombiner aggregator = new PromiseCombiner((EventExecutor)ImmediateEventExecutor.INSTANCE);
        if (this.metricEventPublisher != null) {
            this.metricEventPublisher.shutdown();
        }
        if (!this.sharedTimer) {
            this.timer.stop();
        }
        if (!this.sharedEventLoopGroupProvider) {
            shutdown = this.eventLoopGroupProvider.shutdown(quietPeriod, timeout, timeUnit);
            aggregator.add(shutdown);
        }
        if (!this.sharedEventExecutor) {
            shutdown = this.eventExecutorGroup.shutdownGracefully(quietPeriod, timeout, timeUnit);
            aggregator.add(shutdown);
        }
        if (!this.sharedCommandLatencyCollector) {
            this.commandLatencyCollector.shutdown();
        }
        aggregator.finish((Promise)voidPromise);
        return PromiseAdapter.toBooleanPromise(voidPromise);
    }

    @Override
    public CommandLatencyCollector commandLatencyCollector() {
        return this.commandLatencyCollector;
    }

    @Override
    public EventPublisherOptions commandLatencyPublisherOptions() {
        return this.commandLatencyPublisherOptions;
    }

    @Override
    public int computationThreadPoolSize() {
        return LettuceLists.newList(this.eventExecutorGroup.iterator()).size();
    }

    @Override
    public DnsResolver dnsResolver() {
        return this.dnsResolver;
    }

    @Override
    public EventBus eventBus() {
        return this.eventBus;
    }

    @Override
    public EventLoopGroupProvider eventLoopGroupProvider() {
        return this.eventLoopGroupProvider;
    }

    @Override
    public EventExecutorGroup eventExecutorGroup() {
        return this.eventExecutorGroup;
    }

    @Override
    public int ioThreadPoolSize() {
        return this.eventLoopGroupProvider.threadPoolSize();
    }

    @Override
    public NettyCustomizer nettyCustomizer() {
        return this.nettyCustomizer;
    }

    @Override
    public Delay reconnectDelay() {
        return this.reconnectDelay.get();
    }

    @Override
    public SocketAddressResolver socketAddressResolver() {
        return this.socketAddressResolver;
    }

    @Override
    public Timer timer() {
        return this.timer;
    }

    @Override
    public Tracing tracing() {
        return this.tracing;
    }

    static {
        int threads;
        logger = InternalLoggerFactory.getInstance(DefaultClientResources.class);
        DEFAULT_RECONNECT_DELAY = Delay::exponential;
        DEFAULT_NETTY_CUSTOMIZER = DefaultNettyCustomizer.INSTANCE;
        DEFAULT_IO_THREADS = threads = Math.max(1, SystemPropertyUtil.getInt((String)"io.netty.eventLoopThreads", (int)Math.max(2, Runtime.getRuntime().availableProcessors())));
        DEFAULT_COMPUTATION_THREADS = threads;
        if (logger.isDebugEnabled()) {
            logger.debug("-Dio.netty.eventLoopThreads: {}", (Object)threads);
        }
    }

    public static class Builder
    implements ClientResources.Builder {
        private CommandLatencyCollectorOptions commandLatencyCollectorOptions = DefaultCommandLatencyCollectorOptions.create();
        private CommandLatencyCollector commandLatencyCollector;
        private EventPublisherOptions commandLatencyPublisherOptions = DefaultEventPublisherOptions.create();
        private boolean sharedCommandLatencyCollector;
        private int computationThreadPoolSize = DEFAULT_COMPUTATION_THREADS;
        private DnsResolver dnsResolver = DnsResolvers.UNRESOLVED;
        private EventBus eventBus;
        private EventExecutorGroup eventExecutorGroup;
        private boolean sharedEventExecutor;
        private boolean sharedEventLoopGroupProvider;
        private EventLoopGroupProvider eventLoopGroupProvider;
        private int ioThreadPoolSize = DEFAULT_IO_THREADS;
        private NettyCustomizer nettyCustomizer = DEFAULT_NETTY_CUSTOMIZER;
        private SocketAddressResolver socketAddressResolver;
        private Supplier<Delay> reconnectDelay = DEFAULT_RECONNECT_DELAY;
        private boolean sharedTimer;
        private Timer timer;
        private Tracing tracing = Tracing.disabled();

        private Builder() {
        }

        @Override
        public Builder commandLatencyPublisherOptions(EventPublisherOptions commandLatencyPublisherOptions) {
            LettuceAssert.notNull((Object)commandLatencyPublisherOptions, "EventPublisherOptions must not be null");
            this.commandLatencyPublisherOptions = commandLatencyPublisherOptions;
            return this;
        }

        @Override
        public Builder commandLatencyCollectorOptions(CommandLatencyCollectorOptions commandLatencyCollectorOptions) {
            LettuceAssert.notNull((Object)commandLatencyCollectorOptions, "CommandLatencyCollectorOptions must not be null");
            this.commandLatencyCollectorOptions = commandLatencyCollectorOptions;
            return this;
        }

        @Override
        public Builder commandLatencyCollector(CommandLatencyCollector commandLatencyCollector) {
            LettuceAssert.notNull((Object)commandLatencyCollector, "CommandLatencyCollector must not be null");
            this.sharedCommandLatencyCollector = true;
            this.commandLatencyCollector = commandLatencyCollector;
            return this;
        }

        @Override
        public Builder computationThreadPoolSize(int computationThreadPoolSize) {
            LettuceAssert.isTrue(computationThreadPoolSize > 0, "Computation thread pool size must be greater zero");
            this.computationThreadPoolSize = computationThreadPoolSize;
            return this;
        }

        @Override
        public Builder dnsResolver(DnsResolver dnsResolver) {
            LettuceAssert.notNull((Object)dnsResolver, "DnsResolver must not be null");
            this.dnsResolver = dnsResolver;
            return this;
        }

        @Override
        public Builder eventBus(EventBus eventBus) {
            LettuceAssert.notNull((Object)eventBus, "EventBus must not be null");
            this.eventBus = eventBus;
            return this;
        }

        @Override
        public Builder eventLoopGroupProvider(EventLoopGroupProvider eventLoopGroupProvider) {
            LettuceAssert.notNull((Object)eventLoopGroupProvider, "EventLoopGroupProvider must not be null");
            this.sharedEventLoopGroupProvider = true;
            this.eventLoopGroupProvider = eventLoopGroupProvider;
            return this;
        }

        @Override
        public Builder eventExecutorGroup(EventExecutorGroup eventExecutorGroup) {
            LettuceAssert.notNull((Object)eventExecutorGroup, "EventExecutorGroup must not be null");
            this.sharedEventExecutor = true;
            this.eventExecutorGroup = eventExecutorGroup;
            return this;
        }

        @Override
        public Builder nettyCustomizer(NettyCustomizer nettyCustomizer) {
            LettuceAssert.notNull((Object)nettyCustomizer, "NettyCustomizer must not be null");
            this.nettyCustomizer = nettyCustomizer;
            return this;
        }

        @Override
        public Builder ioThreadPoolSize(int ioThreadPoolSize) {
            LettuceAssert.isTrue(ioThreadPoolSize > 0, "I/O thread pool size must be greater zero");
            this.ioThreadPoolSize = ioThreadPoolSize;
            return this;
        }

        @Override
        public Builder reconnectDelay(Delay reconnectDelay) {
            LettuceAssert.notNull((Object)reconnectDelay, "Delay must not be null");
            LettuceAssert.isTrue(!(reconnectDelay instanceof Delay.StatefulDelay), "Delay must be a stateless instance.");
            return this.reconnectDelay(() -> reconnectDelay);
        }

        @Override
        public Builder reconnectDelay(Supplier<Delay> reconnectDelay) {
            LettuceAssert.notNull(reconnectDelay, "Delay must not be null");
            this.reconnectDelay = reconnectDelay;
            return this;
        }

        @Override
        public ClientResources.Builder socketAddressResolver(SocketAddressResolver socketAddressResolver) {
            LettuceAssert.notNull((Object)socketAddressResolver, "SocketAddressResolver must not be null");
            this.socketAddressResolver = socketAddressResolver;
            return this;
        }

        @Override
        public Builder timer(Timer timer) {
            LettuceAssert.notNull((Object)timer, "Timer must not be null");
            this.sharedTimer = true;
            this.timer = timer;
            return this;
        }

        @Override
        public Builder tracing(Tracing tracing) {
            LettuceAssert.notNull((Object)tracing, "Tracing must not be null");
            this.tracing = tracing;
            return this;
        }

        @Override
        public DefaultClientResources build() {
            return new DefaultClientResources(this);
        }
    }
}

