/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.cluster.topology;

import io.lettuce.core.RedisURI;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.cluster.topology.Requests;
import io.lettuce.core.cluster.topology.TimedAsyncCommand;
import io.lettuce.core.codec.StringCodec;
import io.lettuce.core.internal.ExceptionFactory;
import io.lettuce.core.output.StatusOutput;
import io.lettuce.core.protocol.Command;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CommandKeyword;
import io.lettuce.core.protocol.CommandType;
import io.lettuce.core.resource.ClientResources;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.time.Duration;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

class Connections {
    private static final InternalLogger LOG = InternalLoggerFactory.getInstance(Connections.class);
    private final ClientResources clientResources;
    private final Map<RedisURI, StatefulRedisConnection<String, String>> connections;
    private volatile boolean closed = false;

    public Connections(ClientResources clientResources, Map<RedisURI, StatefulRedisConnection<String, String>> connections) {
        this.clientResources = clientResources;
        this.connections = connections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnection(RedisURI redisURI, StatefulRedisConnection<String, String> connection) {
        if (this.closed) {
            connection.closeAsync();
            return;
        }
        Map<RedisURI, StatefulRedisConnection<String, String>> map = this.connections;
        synchronized (map) {
            if (this.closed) {
                connection.closeAsync();
                return;
            }
            this.connections.put(redisURI, connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Map<RedisURI, StatefulRedisConnection<String, String>> map = this.connections;
        synchronized (map) {
            return this.connections.isEmpty();
        }
    }

    public Requests requestTopology(long timeout, TimeUnit timeUnit) {
        return this.doRequest(() -> {
            CommandArgs<String, String> args = new CommandArgs<String, String>(StringCodec.UTF8).add(CommandKeyword.NODES);
            Command command = new Command(CommandType.CLUSTER, new StatusOutput<String, String>(StringCodec.UTF8), args);
            return new TimedAsyncCommand(command);
        }, timeout, timeUnit);
    }

    public Requests requestClients(long timeout, TimeUnit timeUnit) {
        return this.doRequest(() -> {
            Command command = new Command(CommandType.INFO, new StatusOutput<String, String>(StringCodec.UTF8), new CommandArgs<String, String>(StringCodec.UTF8).add("CLIENTS"));
            return new TimedAsyncCommand(command);
        }, timeout, timeUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Requests doRequest(Supplier<TimedAsyncCommand<String, String, String>> commandFactory, long timeout, TimeUnit timeUnit) {
        Requests requests = new Requests();
        Duration timeoutDuration = Duration.ofNanos(timeUnit.toNanos(timeout));
        Map<RedisURI, StatefulRedisConnection<String, String>> map = this.connections;
        synchronized (map) {
            for (Map.Entry<RedisURI, StatefulRedisConnection<String, String>> entry : this.connections.entrySet()) {
                TimedAsyncCommand<String, String, String> timedCommand = commandFactory.get();
                this.clientResources.timer().newTimeout(it -> timedCommand.completeExceptionally(ExceptionFactory.createTimeoutException(timeoutDuration)), timeout, timeUnit);
                entry.getValue().dispatch(timedCommand);
                requests.addRequest(entry.getKey(), timedCommand);
            }
        }
        return requests;
    }

    public Connections retainAll(Set<RedisURI> connectionsToRetain) {
        LinkedHashSet<RedisURI> keys = new LinkedHashSet<RedisURI>(this.connections.keySet());
        for (RedisURI key : keys) {
            if (connectionsToRetain.contains(key)) continue;
            this.connections.remove(key);
        }
        return this;
    }
}

