/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.ChannelGroupListener;
import io.lettuce.core.ClientOptions;
import io.lettuce.core.ConnectionEventTrigger;
import io.lettuce.core.ConnectionEvents;
import io.lettuce.core.RedisChannelHandler;
import io.lettuce.core.RedisURI;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.protocol.CommandEncoder;
import io.lettuce.core.protocol.CommandHandler;
import io.lettuce.core.protocol.ConnectionInitializer;
import io.lettuce.core.protocol.ConnectionWatchdog;
import io.lettuce.core.protocol.Endpoint;
import io.lettuce.core.protocol.ReconnectionListener;
import io.lettuce.core.protocol.RedisHandshakeHandler;
import io.lettuce.core.resource.ClientResources;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.group.ChannelGroup;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import reactor.core.publisher.Mono;

public class ConnectionBuilder {
    private Mono<SocketAddress> socketAddressSupplier;
    private ConnectionEvents connectionEvents;
    private RedisChannelHandler<?, ?> connection;
    private Endpoint endpoint;
    private Supplier<CommandHandler> commandHandlerSupplier;
    private ChannelGroup channelGroup;
    private Bootstrap bootstrap;
    private ClientOptions clientOptions;
    private Duration timeout;
    private ClientResources clientResources;
    private ConnectionInitializer connectionInitializer;
    private ReconnectionListener reconnectionListener = ReconnectionListener.NO_OP;
    private ConnectionWatchdog connectionWatchdog;

    public static ConnectionBuilder connectionBuilder() {
        return new ConnectionBuilder();
    }

    public void apply(RedisURI redisURI) {
        this.timeout(redisURI.getTimeout());
    }

    protected List<ChannelHandler> buildHandlers() {
        LettuceAssert.assertState(this.channelGroup != null, "ChannelGroup must be set");
        LettuceAssert.assertState(this.connectionEvents != null, "ConnectionEvents must be set");
        LettuceAssert.assertState(this.connection != null, "Connection must be set");
        LettuceAssert.assertState(this.clientResources != null, "ClientResources must be set");
        LettuceAssert.assertState(this.endpoint != null, "Endpoint must be set");
        LettuceAssert.assertState(this.connectionInitializer != null, "ConnectionInitializer must be set");
        ArrayList<ChannelHandler> handlers = new ArrayList<ChannelHandler>();
        this.connection.setOptions(this.clientOptions);
        handlers.add((ChannelHandler)new ChannelGroupListener(this.channelGroup, this.clientResources.eventBus()));
        handlers.add((ChannelHandler)new CommandEncoder());
        handlers.add(this.getHandshakeHandler());
        handlers.add((ChannelHandler)this.commandHandlerSupplier.get());
        handlers.add((ChannelHandler)new ConnectionEventTrigger(this.connectionEvents, this.connection, this.clientResources.eventBus()));
        if (this.clientOptions.isAutoReconnect()) {
            handlers.add((ChannelHandler)this.createConnectionWatchdog());
        }
        return handlers;
    }

    protected ChannelHandler getHandshakeHandler() {
        return new RedisHandshakeHandler(this.connectionInitializer, this.clientResources, this.timeout);
    }

    protected ConnectionWatchdog createConnectionWatchdog() {
        if (this.connectionWatchdog != null) {
            return this.connectionWatchdog;
        }
        LettuceAssert.assertState(this.bootstrap != null, "Bootstrap must be set for autoReconnect=true");
        LettuceAssert.assertState(this.socketAddressSupplier != null, "SocketAddressSupplier must be set for autoReconnect=true");
        ConnectionWatchdog watchdog = new ConnectionWatchdog(this.clientResources.reconnectDelay(), this.clientOptions, this.bootstrap, this.clientResources.timer(), this.clientResources.eventExecutorGroup(), this.socketAddressSupplier, this.reconnectionListener, this.connection, this.clientResources.eventBus());
        this.endpoint.registerConnectionWatchdog(watchdog);
        this.connectionWatchdog = watchdog;
        return watchdog;
    }

    public ChannelInitializer<Channel> build(SocketAddress socketAddress) {
        return new PlainChannelInitializer(this::buildHandlers, this.clientResources);
    }

    public ConnectionBuilder socketAddressSupplier(Mono<SocketAddress> socketAddressSupplier) {
        this.socketAddressSupplier = socketAddressSupplier;
        return this;
    }

    public Mono<SocketAddress> socketAddress() {
        LettuceAssert.assertState(this.socketAddressSupplier != null, "SocketAddressSupplier must be set");
        return this.socketAddressSupplier;
    }

    public ConnectionBuilder timeout(Duration timeout) {
        this.timeout = timeout;
        return this;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public ConnectionBuilder reconnectionListener(ReconnectionListener reconnectionListener) {
        LettuceAssert.notNull((Object)reconnectionListener, "ReconnectionListener must not be null");
        this.reconnectionListener = reconnectionListener;
        return this;
    }

    public ConnectionBuilder clientOptions(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        return this;
    }

    public ConnectionBuilder connectionEvents(ConnectionEvents connectionEvents) {
        this.connectionEvents = connectionEvents;
        return this;
    }

    public ConnectionBuilder connection(RedisChannelHandler<?, ?> connection) {
        this.connection = connection;
        return this;
    }

    public ConnectionBuilder channelGroup(ChannelGroup channelGroup) {
        this.channelGroup = channelGroup;
        return this;
    }

    public ConnectionBuilder commandHandler(Supplier<CommandHandler> supplier) {
        this.commandHandlerSupplier = supplier;
        return this;
    }

    public ConnectionBuilder bootstrap(Bootstrap bootstrap) {
        this.bootstrap = bootstrap;
        return this;
    }

    public ConnectionBuilder endpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public ConnectionBuilder clientResources(ClientResources clientResources) {
        this.clientResources = clientResources;
        return this;
    }

    public ConnectionBuilder connectionInitializer(ConnectionInitializer connectionInitializer) {
        this.connectionInitializer = connectionInitializer;
        return this;
    }

    public RedisChannelHandler<?, ?> connection() {
        return this.connection;
    }

    public Bootstrap bootstrap() {
        return this.bootstrap;
    }

    public ClientOptions clientOptions() {
        return this.clientOptions;
    }

    public ClientResources clientResources() {
        return this.clientResources;
    }

    public Endpoint endpoint() {
        return this.endpoint;
    }

    static class PlainChannelInitializer
    extends ChannelInitializer<Channel> {
        private final Supplier<List<ChannelHandler>> handlers;
        private final ClientResources clientResources;

        PlainChannelInitializer(Supplier<List<ChannelHandler>> handlers, ClientResources clientResources) {
            this.handlers = handlers;
            this.clientResources = clientResources;
        }

        protected void initChannel(Channel channel) {
            this.doInitialize(channel);
        }

        private void doInitialize(Channel channel) {
            for (ChannelHandler handler : this.handlers.get()) {
                channel.pipeline().addLast(new ChannelHandler[]{handler});
            }
            this.clientResources.nettyCustomizer().afterChannelInitialized(channel);
        }
    }
}

