/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CommandKeyword;

public class XAddArgs {
    private String id;
    private Long maxlen;
    private boolean approximateTrimming;
    private boolean nomkstream;

    public XAddArgs id(String id) {
        LettuceAssert.notNull((Object)id, "Id must not be null");
        this.id = id;
        return this;
    }

    public XAddArgs maxlen(long maxlen) {
        LettuceAssert.isTrue(maxlen > 0L, "Maxlen must be greater 0");
        this.maxlen = maxlen;
        return this;
    }

    public XAddArgs approximateTrimming() {
        return this.approximateTrimming(true);
    }

    public XAddArgs approximateTrimming(boolean approximateTrimming) {
        this.approximateTrimming = approximateTrimming;
        return this;
    }

    public XAddArgs nomkstream() {
        return this.nomkstream(true);
    }

    public XAddArgs nomkstream(boolean nomkstream) {
        this.nomkstream = nomkstream;
        return this;
    }

    public <K, V> void build(CommandArgs<K, V> args) {
        if (this.maxlen != null) {
            args.add(CommandKeyword.MAXLEN);
            if (this.approximateTrimming) {
                args.add("~");
            }
            args.add(this.maxlen);
        }
        if (this.nomkstream) {
            args.add(CommandKeyword.NOMKSTREAM);
        }
        if (this.id != null) {
            args.add(this.id);
        } else {
            args.add("*");
        }
    }

    public static class Builder {
        private Builder() {
        }

        public static XAddArgs maxlen(long count) {
            return new XAddArgs().maxlen(count);
        }

        public static XAddArgs nomkstream() {
            return new XAddArgs().nomkstream();
        }
    }
}

