/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.models.command;

import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.models.command.CommandDetail;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CommandDetailParser {
    public static final int COMMAND_INFO_SIZE = 6;
    protected static final Map<String, CommandDetail.Flag> FLAG_MAPPING;
    protected static final Map<String, CommandDetail.AclCategory> ACL_CATEGORY_MAPPING;

    private CommandDetailParser() {
    }

    public static List<CommandDetail> parse(List<?> commandOutput) {
        LettuceAssert.notNull(commandOutput, "CommandOutput must not be null");
        ArrayList<CommandDetail> result = new ArrayList<CommandDetail>();
        for (Object o : commandOutput) {
            Collection collection;
            if (!(o instanceof Collection) || (collection = (Collection)o).size() < 6) continue;
            CommandDetail commandDetail = CommandDetailParser.parseCommandDetail(collection);
            result.add(commandDetail);
        }
        return Collections.unmodifiableList(result);
    }

    private static CommandDetail parseCommandDetail(Collection<?> collection) {
        Iterator<?> iterator = collection.iterator();
        String name = (String)iterator.next();
        int arity = Math.toIntExact(CommandDetailParser.getLongFromIterator(iterator, 0L));
        Object flags = iterator.next();
        int firstKey = Math.toIntExact(CommandDetailParser.getLongFromIterator(iterator, 0L));
        int lastKey = Math.toIntExact(CommandDetailParser.getLongFromIterator(iterator, 0L));
        int keyStepCount = Math.toIntExact(CommandDetailParser.getLongFromIterator(iterator, 0L));
        Object categories = iterator.hasNext() ? iterator.next() : null;
        Set<CommandDetail.Flag> parsedFlags = CommandDetailParser.parseFlags(flags);
        Set<CommandDetail.AclCategory> parsedAclCategories = CommandDetailParser.parseAclCategories(categories);
        return new CommandDetail(name, arity, parsedFlags, firstKey, lastKey, keyStepCount, parsedAclCategories);
    }

    private static Set<CommandDetail.Flag> parseFlags(Object flags) {
        HashSet<CommandDetail.Flag> result = new HashSet<CommandDetail.Flag>();
        if (flags instanceof Collection) {
            Collection collection = (Collection)flags;
            for (Object o : collection) {
                CommandDetail.Flag flag = FLAG_MAPPING.get(o);
                if (flag == null) continue;
                result.add(flag);
            }
        }
        return Collections.unmodifiableSet(result);
    }

    private static Set<CommandDetail.AclCategory> parseAclCategories(Object aclCategories) {
        HashSet<CommandDetail.AclCategory> result = new HashSet<CommandDetail.AclCategory>();
        if (aclCategories instanceof Collection) {
            Collection collection = (Collection)aclCategories;
            for (Object o : collection) {
                CommandDetail.AclCategory aclCategory = ACL_CATEGORY_MAPPING.get(o);
                if (aclCategory == null) continue;
                result.add(aclCategory);
            }
        }
        return Collections.unmodifiableSet(result);
    }

    private static long getLongFromIterator(Iterator<?> iterator, long defaultValue) {
        if (iterator.hasNext()) {
            Object object = iterator.next();
            if (object instanceof String) {
                return Long.parseLong((String)object);
            }
            if (object instanceof Number) {
                return ((Number)object).longValue();
            }
        }
        return defaultValue;
    }

    static {
        HashMap<String, CommandDetail.Flag> flagMap = new HashMap<String, CommandDetail.Flag>();
        flagMap.put("admin", CommandDetail.Flag.ADMIN);
        flagMap.put("asking", CommandDetail.Flag.ASKING);
        flagMap.put("denyoom", CommandDetail.Flag.DENYOOM);
        flagMap.put("fast", CommandDetail.Flag.FAST);
        flagMap.put("loading", CommandDetail.Flag.LOADING);
        flagMap.put("noscript", CommandDetail.Flag.NOSCRIPT);
        flagMap.put("movablekeys", CommandDetail.Flag.MOVABLEKEYS);
        flagMap.put("pubsub", CommandDetail.Flag.PUBSUB);
        flagMap.put("random", CommandDetail.Flag.RANDOM);
        flagMap.put("readonly", CommandDetail.Flag.READONLY);
        flagMap.put("skip_monitor", CommandDetail.Flag.SKIP_MONITOR);
        flagMap.put("sort_for_script", CommandDetail.Flag.SORT_FOR_SCRIPT);
        flagMap.put("stale", CommandDetail.Flag.STALE);
        flagMap.put("write", CommandDetail.Flag.WRITE);
        FLAG_MAPPING = Collections.unmodifiableMap(flagMap);
        HashMap<String, CommandDetail.AclCategory> aclCategoriesMap = new HashMap<String, CommandDetail.AclCategory>();
        aclCategoriesMap.put("@keyspace", CommandDetail.AclCategory.KEYSPACE);
        aclCategoriesMap.put("@read", CommandDetail.AclCategory.READ);
        aclCategoriesMap.put("@write", CommandDetail.AclCategory.WRITE);
        aclCategoriesMap.put("@set", CommandDetail.AclCategory.SET);
        aclCategoriesMap.put("@sortedset", CommandDetail.AclCategory.SORTEDSET);
        aclCategoriesMap.put("@list", CommandDetail.AclCategory.LIST);
        aclCategoriesMap.put("@hash", CommandDetail.AclCategory.HASH);
        aclCategoriesMap.put("@string", CommandDetail.AclCategory.STRING);
        aclCategoriesMap.put("@bitmap", CommandDetail.AclCategory.BITMAP);
        aclCategoriesMap.put("@hyperloglog", CommandDetail.AclCategory.HYPERLOGLOG);
        aclCategoriesMap.put("@geo", CommandDetail.AclCategory.GEO);
        aclCategoriesMap.put("@stream", CommandDetail.AclCategory.STREAM);
        aclCategoriesMap.put("@pubsub", CommandDetail.AclCategory.PUBSUB);
        aclCategoriesMap.put("@admin", CommandDetail.AclCategory.ADMIN);
        aclCategoriesMap.put("@fast", CommandDetail.AclCategory.FAST);
        aclCategoriesMap.put("@slow", CommandDetail.AclCategory.SLOW);
        aclCategoriesMap.put("@blocking", CommandDetail.AclCategory.BLOCKING);
        aclCategoriesMap.put("@dangerous", CommandDetail.AclCategory.DANGEROUS);
        aclCategoriesMap.put("@connection", CommandDetail.AclCategory.CONNECTION);
        aclCategoriesMap.put("@transaction", CommandDetail.AclCategory.TRANSACTION);
        aclCategoriesMap.put("@scripting", CommandDetail.AclCategory.SCRIPTING);
        ACL_CATEGORY_MAPPING = Collections.unmodifiableMap(aclCategoriesMap);
    }
}

