/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.cluster;

import io.lettuce.core.AbstractRedisClient;
import io.lettuce.core.ClientOptions;
import io.lettuce.core.ConnectionState;
import io.lettuce.core.ReadFrom;
import io.lettuce.core.RedisChannelHandler;
import io.lettuce.core.RedisChannelWriter;
import io.lettuce.core.RedisException;
import io.lettuce.core.RedisURI;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.cluster.AsyncClusterConnectionProvider;
import io.lettuce.core.cluster.ClusterClientOptions;
import io.lettuce.core.cluster.ClusterDistributionChannelWriter;
import io.lettuce.core.cluster.ClusterFutureSyncInvocationHandler;
import io.lettuce.core.cluster.ClusterPushHandler;
import io.lettuce.core.cluster.RedisAdvancedClusterAsyncCommandsImpl;
import io.lettuce.core.cluster.RedisAdvancedClusterReactiveCommandsImpl;
import io.lettuce.core.cluster.api.StatefulRedisClusterConnection;
import io.lettuce.core.cluster.api.async.RedisAdvancedClusterAsyncCommands;
import io.lettuce.core.cluster.api.async.RedisClusterAsyncCommands;
import io.lettuce.core.cluster.api.push.RedisClusterPushListener;
import io.lettuce.core.cluster.api.reactive.RedisAdvancedClusterReactiveCommands;
import io.lettuce.core.cluster.api.sync.NodeSelection;
import io.lettuce.core.cluster.api.sync.NodeSelectionCommands;
import io.lettuce.core.cluster.api.sync.RedisAdvancedClusterCommands;
import io.lettuce.core.cluster.models.partitions.Partitions;
import io.lettuce.core.cluster.models.partitions.RedisClusterNode;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.json.JsonParser;
import io.lettuce.core.protocol.CommandArgsAccessor;
import io.lettuce.core.protocol.CommandType;
import io.lettuce.core.protocol.CompleteableCommand;
import io.lettuce.core.protocol.ConnectionIntent;
import io.lettuce.core.protocol.RedisCommand;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public class StatefulRedisClusterConnectionImpl<K, V>
extends RedisChannelHandler<K, V>
implements StatefulRedisClusterConnection<K, V> {
    private final ClusterPushHandler pushHandler;
    protected final RedisCodec<K, V> codec;
    protected final Mono<JsonParser> parser;
    protected final RedisAdvancedClusterCommands<K, V> sync;
    protected final RedisAdvancedClusterAsyncCommandsImpl<K, V> async;
    protected final RedisAdvancedClusterReactiveCommandsImpl<K, V> reactive;
    private final ClusterConnectionState connectionState = new ClusterConnectionState();
    private volatile Partitions partitions;

    public StatefulRedisClusterConnectionImpl(RedisChannelWriter writer, ClusterPushHandler pushHandler, RedisCodec<K, V> codec, Duration timeout, Mono<JsonParser> parser) {
        super(writer, timeout);
        this.pushHandler = pushHandler;
        this.codec = codec;
        this.parser = parser;
        this.async = this.newRedisAdvancedClusterAsyncCommandsImpl();
        this.sync = this.newRedisAdvancedClusterCommandsImpl();
        this.reactive = this.newRedisAdvancedClusterReactiveCommandsImpl();
    }

    protected RedisAdvancedClusterReactiveCommandsImpl<K, V> newRedisAdvancedClusterReactiveCommandsImpl() {
        return new RedisAdvancedClusterReactiveCommandsImpl<K, V>(this, this.codec, this.parser);
    }

    protected RedisAdvancedClusterCommands<K, V> newRedisAdvancedClusterCommandsImpl() {
        return (RedisAdvancedClusterCommands)this.clusterSyncHandler(RedisAdvancedClusterCommands.class);
    }

    protected <T> T clusterSyncHandler(Class<?> ... interfaces) {
        return (T)Proxy.newProxyInstance(AbstractRedisClient.class.getClassLoader(), interfaces, this.syncInvocationHandler());
    }

    protected RedisAdvancedClusterAsyncCommandsImpl<K, V> newRedisAdvancedClusterAsyncCommandsImpl() {
        return new RedisAdvancedClusterAsyncCommandsImpl<K, V>(this, this.codec, this.parser);
    }

    @Override
    public RedisAdvancedClusterCommands<K, V> sync() {
        return this.sync;
    }

    protected InvocationHandler syncInvocationHandler() {
        return new ClusterFutureSyncInvocationHandler(this, RedisClusterAsyncCommands.class, NodeSelection.class, NodeSelectionCommands.class, this.async());
    }

    @Override
    public RedisAdvancedClusterAsyncCommands<K, V> async() {
        return this.async;
    }

    @Override
    public RedisAdvancedClusterReactiveCommands<K, V> reactive() {
        return this.reactive;
    }

    @Override
    public void addListener(RedisClusterPushListener listener) {
        this.pushHandler.addListener(listener);
    }

    @Override
    public void removeListener(RedisClusterPushListener listener) {
        this.pushHandler.removeListener(listener);
    }

    private RedisURI lookup(String nodeId) {
        for (RedisClusterNode partition : this.partitions) {
            if (!partition.getNodeId().equals(nodeId)) continue;
            return partition.getUri();
        }
        return null;
    }

    @Override
    public StatefulRedisConnection<K, V> getConnection(String nodeId, ConnectionIntent connectionIntent) {
        RedisURI redisURI = this.lookup(nodeId);
        if (redisURI == null) {
            throw new RedisException("NodeId " + nodeId + " does not belong to the cluster");
        }
        return this.getClusterDistributionChannelWriter().getClusterConnectionProvider().getConnection(connectionIntent, nodeId);
    }

    @Override
    public CompletableFuture<StatefulRedisConnection<K, V>> getConnectionAsync(String nodeId, ConnectionIntent connectionIntent) {
        RedisURI redisURI = this.lookup(nodeId);
        if (redisURI == null) {
            throw new RedisException("NodeId " + nodeId + " does not belong to the cluster");
        }
        AsyncClusterConnectionProvider provider = (AsyncClusterConnectionProvider)((Object)this.getClusterDistributionChannelWriter().getClusterConnectionProvider());
        return provider.getConnectionAsync(connectionIntent, nodeId);
    }

    @Override
    public StatefulRedisConnection<K, V> getConnection(String host, int port, ConnectionIntent connectionIntent) {
        return this.getClusterDistributionChannelWriter().getClusterConnectionProvider().getConnection(connectionIntent, host, port);
    }

    @Override
    public CompletableFuture<StatefulRedisConnection<K, V>> getConnectionAsync(String host, int port, ConnectionIntent connectionIntent) {
        AsyncClusterConnectionProvider provider = (AsyncClusterConnectionProvider)((Object)this.getClusterDistributionChannelWriter().getClusterConnectionProvider());
        return provider.getConnectionAsync(connectionIntent, host, port);
    }

    @Override
    public void activated() {
        super.activated();
        this.async.clusterMyId().thenAccept(this.connectionState::setNodeId);
    }

    ClusterDistributionChannelWriter getClusterDistributionChannelWriter() {
        return (ClusterDistributionChannelWriter)super.getChannelWriter();
    }

    @Override
    public <T> RedisCommand<K, V, T> dispatch(RedisCommand<K, V, T> command) {
        return super.dispatch(this.preProcessCommand(command));
    }

    @Override
    public Collection<RedisCommand<K, V, ?>> dispatch(Collection<? extends RedisCommand<K, V, ?>> commands) {
        ArrayList commandsToSend = new ArrayList(commands.size());
        for (RedisCommand<K, V, ?> command : commands) {
            commandsToSend.add(this.preProcessCommand(command));
        }
        return super.dispatch(commandsToSend);
    }

    private <T> RedisCommand<K, V, T> preProcessCommand(RedisCommand<K, V, T> command) {
        RedisCommand<K, V, Object> local = command;
        if (local.getType().toString().equals(CommandType.AUTH.name())) {
            local = this.attachOnComplete(local, status -> {
                if (status.equals("OK")) {
                    List<char[]> args = CommandArgsAccessor.getCharArrayArguments(command.getArgs());
                    if (!args.isEmpty()) {
                        this.connectionState.setUserNamePassword(args);
                    } else {
                        List<String> stringArgs = CommandArgsAccessor.getStringArguments(command.getArgs());
                        this.connectionState.setUserNamePassword(stringArgs.stream().map(String::toCharArray).collect(Collectors.toList()));
                    }
                }
            });
        }
        if (local.getType().toString().equals(CommandType.READONLY.name())) {
            local = this.attachOnComplete(local, status -> {
                if (status.equals("OK")) {
                    this.connectionState.setReadOnly(true);
                }
            });
        }
        if (local.getType().toString().equals(CommandType.READWRITE.name())) {
            local = this.attachOnComplete(local, status -> {
                if (status.equals("OK")) {
                    this.connectionState.setReadOnly(false);
                }
            });
        }
        return local;
    }

    private <T> RedisCommand<K, V, T> attachOnComplete(RedisCommand<K, V, T> command, Consumer<T> consumer) {
        if (command instanceof CompleteableCommand) {
            CompleteableCommand completeable = (CompleteableCommand)((Object)command);
            completeable.onComplete(consumer);
        }
        return command;
    }

    public void setPartitions(Partitions partitions) {
        LettuceAssert.notNull((Object)partitions, "Partitions must not be null");
        this.partitions = partitions;
        String nodeId = this.connectionState.getNodeId();
        if (nodeId != null && this.expireStaleConnections() && partitions.getPartitionByNodeId(nodeId) == null) {
            this.getClusterDistributionChannelWriter().disconnectDefaultEndpoint();
        }
        this.getClusterDistributionChannelWriter().setPartitions(partitions);
    }

    @Override
    public Partitions getPartitions() {
        return this.partitions;
    }

    @Override
    public void setReadFrom(ReadFrom readFrom) {
        LettuceAssert.notNull((Object)readFrom, "ReadFrom must not be null");
        this.getClusterDistributionChannelWriter().setReadFrom(readFrom);
    }

    @Override
    public ReadFrom getReadFrom() {
        return this.getClusterDistributionChannelWriter().getReadFrom();
    }

    ConnectionState getConnectionState() {
        return this.connectionState;
    }

    private boolean expireStaleConnections() {
        ClusterClientOptions options = this.getClusterClientOptions();
        return options == null || options.isCloseStaleConnections();
    }

    private ClusterClientOptions getClusterClientOptions() {
        ClientOptions options = this.getOptions();
        return options instanceof ClusterClientOptions ? (ClusterClientOptions)options : null;
    }

    static class ClusterConnectionState
    extends ConnectionState {
        private volatile String nodeId;

        ClusterConnectionState() {
        }

        @Override
        protected void setUserNamePassword(List<char[]> args) {
            super.setUserNamePassword(args);
        }

        @Override
        protected void setDb(int db) {
            super.setDb(db);
        }

        @Override
        protected void setReadOnly(boolean readOnly2) {
            super.setReadOnly(readOnly2);
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }
    }
}

