/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.ClientOptions;
import io.lettuce.core.ConnectionState;
import io.lettuce.core.RedisAsyncCommandsImpl;
import io.lettuce.core.RedisAuthenticationHandler;
import io.lettuce.core.RedisChannelHandler;
import io.lettuce.core.RedisChannelWriter;
import io.lettuce.core.RedisReactiveCommandsImpl;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.async.RedisAsyncCommands;
import io.lettuce.core.api.push.PushListener;
import io.lettuce.core.api.reactive.RedisReactiveCommands;
import io.lettuce.core.api.sync.RedisCommands;
import io.lettuce.core.cluster.api.sync.RedisClusterCommands;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.codec.StringCodec;
import io.lettuce.core.json.JsonParser;
import io.lettuce.core.output.MultiOutput;
import io.lettuce.core.output.StatusOutput;
import io.lettuce.core.protocol.AsyncCommand;
import io.lettuce.core.protocol.Command;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CommandArgsAccessor;
import io.lettuce.core.protocol.CommandKeyword;
import io.lettuce.core.protocol.CommandType;
import io.lettuce.core.protocol.CompleteableCommand;
import io.lettuce.core.protocol.PushHandler;
import io.lettuce.core.protocol.RedisCommand;
import io.lettuce.core.protocol.TransactionalCommand;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public class StatefulRedisConnectionImpl<K, V>
extends RedisChannelHandler<K, V>
implements StatefulRedisConnection<K, V> {
    protected final RedisCodec<K, V> codec;
    protected final RedisCommands<K, V> sync;
    protected final RedisAsyncCommandsImpl<K, V> async;
    protected final RedisReactiveCommandsImpl<K, V> reactive;
    private final ConnectionState state = new ConnectionState();
    private final PushHandler pushHandler;
    private final Mono<JsonParser> parser;
    protected MultiOutput<K, V> multi;
    private RedisAuthenticationHandler<K, V> authHandler = RedisAuthenticationHandler.createDefaultAuthenticationHandler();

    public StatefulRedisConnectionImpl(RedisChannelWriter writer, PushHandler pushHandler, RedisCodec<K, V> codec, Duration timeout) {
        this(writer, pushHandler, codec, timeout, ClientOptions.DEFAULT_JSON_PARSER);
    }

    public StatefulRedisConnectionImpl(RedisChannelWriter writer, PushHandler pushHandler, RedisCodec<K, V> codec, Duration timeout, Mono<JsonParser> parser) {
        super(writer, timeout);
        this.pushHandler = pushHandler;
        this.codec = codec;
        this.parser = parser;
        this.async = this.newRedisAsyncCommandsImpl();
        this.sync = this.newRedisSyncCommandsImpl();
        this.reactive = this.newRedisReactiveCommandsImpl();
    }

    public RedisCodec<K, V> getCodec() {
        return this.codec;
    }

    @Override
    public RedisAsyncCommands<K, V> async() {
        return this.async;
    }

    protected RedisCommands<K, V> newRedisSyncCommandsImpl() {
        return (RedisCommands)this.syncHandler(this.async(), RedisCommands.class, RedisClusterCommands.class);
    }

    protected RedisAsyncCommandsImpl<K, V> newRedisAsyncCommandsImpl() {
        return new RedisAsyncCommandsImpl<K, V>(this, this.codec, this.parser);
    }

    @Override
    public RedisReactiveCommands<K, V> reactive() {
        return this.reactive;
    }

    protected RedisReactiveCommandsImpl<K, V> newRedisReactiveCommandsImpl() {
        return new RedisReactiveCommandsImpl<K, V>(this, this.codec, this.parser);
    }

    @Override
    public RedisCommands<K, V> sync() {
        return this.sync;
    }

    @Override
    public void addListener(PushListener listener) {
        this.pushHandler.addListener(listener);
    }

    @Override
    public void removeListener(PushListener listener) {
        this.pushHandler.removeListener(listener);
    }

    @Override
    public boolean isMulti() {
        return this.multi != null;
    }

    @Override
    public <T> RedisCommand<K, V, T> dispatch(RedisCommand<K, V, T> command) {
        RedisCommand<K, V, T> toSend = this.preProcessCommand(command);
        RedisCommand<K, V, T> result = super.dispatch(toSend);
        RedisCommand<K, V, T> finalCommand = this.postProcessCommand(result);
        return finalCommand;
    }

    @Override
    public Collection<RedisCommand<K, V, ?>> dispatch(Collection<? extends RedisCommand<K, V, ?>> commands) {
        Collection<RedisCommand<K, V, ?>> sentCommands = this.preProcessCommands(commands);
        Collection<RedisCommand<K, V, ?>> dispatchedCommands = super.dispatch(sentCommands);
        return this.postProcessCommands(dispatchedCommands);
    }

    protected Collection<RedisCommand<K, V, ?>> postProcessCommands(Collection<RedisCommand<K, V, ?>> commands) {
        this.authHandler.postProcess(commands);
        return commands;
    }

    protected <T> RedisCommand<K, V, T> postProcessCommand(RedisCommand<K, V, T> command) {
        this.authHandler.postProcess(command);
        return command;
    }

    protected Collection<RedisCommand<K, V, ?>> preProcessCommands(Collection<? extends RedisCommand<K, V, ?>> commands) {
        ArrayList sentCommands = new ArrayList(commands.size());
        commands.forEach(o -> {
            RedisCommand preprocessed = this.preProcessCommand((RedisCommand)o);
            sentCommands.add(preprocessed);
        });
        return sentCommands;
    }

    protected <T> RedisCommand<K, V, T> preProcessCommand(RedisCommand<K, V, T> command) {
        RedisCommand<K, V, Object> local = command;
        String commandType = command.getType().toString();
        if (commandType.equals(CommandType.AUTH.name())) {
            local = this.attachOnComplete(local, status -> {
                if ("OK".equals(status)) {
                    List<char[]> args = CommandArgsAccessor.getCharArrayArguments(command.getArgs());
                    if (!args.isEmpty()) {
                        this.state.setUserNamePassword(args);
                    } else {
                        List<String> strings = CommandArgsAccessor.getStringArguments(command.getArgs());
                        this.state.setUserNamePassword(strings.stream().map(String::toCharArray).collect(Collectors.toList()));
                    }
                }
            });
        }
        if (commandType.equals(CommandType.SELECT.name())) {
            local = this.attachOnComplete(local, status -> {
                Long db;
                if ("OK".equals(status) && (db = CommandArgsAccessor.getFirstInteger(command.getArgs())) != null) {
                    this.state.setDb(db.intValue());
                }
            });
        }
        if (commandType.equals(CommandType.READONLY.name())) {
            local = this.attachOnComplete(local, status -> {
                if ("OK".equals(status)) {
                    this.state.setReadOnly(true);
                }
            });
        }
        if (commandType.equals(CommandType.READWRITE.name())) {
            local = this.attachOnComplete(local, status -> {
                if ("OK".equals(status)) {
                    this.state.setReadOnly(false);
                }
            });
        }
        if (commandType.equals(CommandType.DISCARD.name()) && this.multi != null) {
            this.multi.cancel();
            this.multi = null;
        }
        if (commandType.equals(CommandType.EXEC.name())) {
            MultiOutput<K, V> multiOutput = this.multi;
            this.multi = null;
            if (multiOutput == null) {
                multiOutput = new MultiOutput<K, V>(this.codec);
            }
            local.setOutput(multiOutput);
        }
        if (this.multi != null && !commandType.equals(CommandType.MULTI.name()) && !commandType.equals(CommandType.WATCH.name())) {
            local = new TransactionalCommand<K, V, Object>(local);
            this.multi.add(local);
        }
        if (commandType.equals(CommandType.MULTI.name())) {
            this.authHandler.startTransaction();
            MultiOutput<K, V> multiOutput = this.multi = this.multi == null ? new MultiOutput<K, V>(this.codec) : this.multi;
            if (command instanceof CompleteableCommand) {
                ((CompleteableCommand)((Object)command)).onComplete((ignored, e) -> {
                    if (e != null) {
                        this.multi = null;
                        this.authHandler.endTransaction();
                    }
                });
            }
        }
        return local;
    }

    private <T> RedisCommand<K, V, T> attachOnComplete(RedisCommand<K, V, T> command, Consumer<T> consumer) {
        if (command instanceof CompleteableCommand) {
            CompleteableCommand completeable = (CompleteableCommand)((Object)command);
            completeable.onComplete(consumer);
        }
        return command;
    }

    @Deprecated
    public void setClientName(String clientName) {
        CommandArgs<String, String> args = new CommandArgs<String, String>(StringCodec.UTF8).add(CommandKeyword.SETNAME).addValue(clientName);
        AsyncCommand async = new AsyncCommand(new Command(CommandType.CLIENT, new StatusOutput<String, String>(StringCodec.UTF8), args));
        this.state.setClientName(clientName);
        this.dispatch(async);
    }

    public ConnectionState getConnectionState() {
        return this.state;
    }

    @Override
    public void activated() {
        super.activated();
        this.authHandler.subscribe();
    }

    @Override
    public void deactivated() {
        this.authHandler.unsubscribe();
        super.deactivated();
    }

    public void setAuthenticationHandler(RedisAuthenticationHandler<K, V> handler) {
        if (handler != null) {
            this.authHandler = handler;
        }
    }
}

