/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.output;

import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.output.CommandOutput;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class ValueDoubleMapOutput<K, V>
extends CommandOutput<K, V, Map<V, Double>> {
    private static final InternalLogger LOG = InternalLoggerFactory.getInstance(ValueDoubleMapOutput.class);
    private boolean outputError = false;
    private boolean hasKey;
    private V key;

    public ValueDoubleMapOutput(RedisCodec<K, V> codec) {
        super(codec, null);
    }

    @Override
    public void set(ByteBuffer bytes) {
        if (this.outputError) {
            return;
        }
        if (!this.hasKey) {
            this.key = bytes == null ? null : this.codec.decodeValue(bytes);
            this.hasKey = true;
            return;
        }
        try {
            Double value = Double.parseDouble(this.decodeString(bytes));
            ((Map)this.output).put(this.key, value);
            this.key = null;
            this.hasKey = false;
        }
        catch (NumberFormatException e) {
            LOG.warn("Unable to fallback to parsing double from string, discarding the result");
            this.output = new HashMap(0);
            this.outputError = true;
        }
    }

    @Override
    public void set(double number) {
        if (this.outputError) {
            return;
        }
        if (this.hasKey) {
            ((Map)this.output).put(this.key, number);
            this.key = null;
            this.hasKey = false;
            return;
        }
        LOG.warn("Expected bytes but got double, discarding the result");
        this.output = new HashMap(0);
        this.outputError = true;
    }

    @Override
    public void multi(int count) {
        if (this.output == null) {
            this.output = new LinkedHashMap(count / 2, 1.0f);
        }
    }
}

