/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.output;

import io.lettuce.core.codec.StringCodec;
import io.lettuce.core.output.CommandOutput;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class ReplayOutput<K, V>
extends CommandOutput<K, V, List<Signal>> {
    public ReplayOutput() {
        super(StringCodec.ASCII, new ArrayList());
    }

    @Override
    public void set(ByteBuffer bytes) {
        ((List)this.output).add(new BulkString(bytes));
    }

    @Override
    public void set(long integer) {
        ((List)this.output).add(new Integer(integer));
    }

    @Override
    public void set(double number) {
        ((List)this.output).add(new Double(number));
    }

    @Override
    public void setError(ByteBuffer error) {
        error.mark();
        ((List)this.output).add(new ErrorBytes(error));
        error.reset();
        super.setError(error);
    }

    @Override
    public void setError(String error) {
        ((List)this.output).add(new ErrorString(error));
        super.setError(error);
    }

    @Override
    public void complete(int depth) {
        ((List)this.output).add(new Complete(depth));
    }

    @Override
    public void multi(int count) {
        ((List)this.output).add(new Multi(count));
    }

    public void replay(CommandOutput<?, ?, ?> target) {
        for (Signal signal : (List)this.output) {
            signal.replay(target);
        }
    }

    static class Complete
    extends Signal {
        final int depth;

        public Complete(int depth) {
            this.depth = depth;
        }

        @Override
        protected void replay(CommandOutput<?, ?, ?> target) {
            target.complete(this.depth);
        }
    }

    static class Multi
    extends Signal {
        final int count;

        Multi(int count) {
            this.count = count;
        }

        @Override
        protected void replay(CommandOutput<?, ?, ?> target) {
            target.multi(this.count);
        }
    }

    static class ErrorString
    extends Signal {
        final String message;

        ErrorString(String message) {
            this.message = message;
        }

        @Override
        protected void replay(CommandOutput<?, ?, ?> target) {
            target.setError(this.message);
        }
    }

    public static class ErrorBytes
    extends BulkStringSupport {
        ErrorBytes(ByteBuffer message) {
            super(message);
        }

        @Override
        protected void replay(CommandOutput<?, ?, ?> target) {
            target.setError(this.message);
        }
    }

    static class Double
    extends Signal {
        final double message;

        Double(double message) {
            this.message = message;
        }

        @Override
        protected void replay(CommandOutput<?, ?, ?> target) {
            target.set(this.message);
        }
    }

    static class Integer
    extends Signal {
        final long message;

        Integer(long message) {
            this.message = message;
        }

        @Override
        protected void replay(CommandOutput<?, ?, ?> target) {
            target.set(this.message);
        }
    }

    public static class BulkString
    extends BulkStringSupport {
        BulkString(ByteBuffer message) {
            super(message);
        }

        @Override
        protected void replay(CommandOutput<?, ?, ?> target) {
            target.set(this.message);
        }
    }

    static abstract class BulkStringSupport
    extends Signal {
        final ByteBuffer message;

        BulkStringSupport(ByteBuffer message) {
            if (message != null) {
                this.message = ByteBuffer.allocate(message.remaining());
                this.message.put(message);
                this.message.rewind();
            } else {
                this.message = null;
            }
        }
    }

    public static abstract class Signal {
        protected abstract void replay(CommandOutput<?, ?, ?> var1);
    }
}

