/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.RedisURI;

class ConnectionMetadata {
    private volatile String clientName;
    private volatile String libraryName;
    private volatile String libraryVersion;
    private volatile boolean sslEnabled;

    public ConnectionMetadata() {
    }

    public ConnectionMetadata(RedisURI uri) {
        this.apply(uri);
    }

    public void apply(RedisURI redisURI) {
        this.setClientName(redisURI.getClientName());
        this.setLibraryName(redisURI.getLibraryName());
        this.setLibraryVersion(redisURI.getLibraryVersion());
        this.setSslEnabled(redisURI.isSsl());
    }

    public void apply(ConnectionMetadata metadata) {
        this.setClientName(metadata.getClientName());
        this.setLibraryName(metadata.getLibraryName());
        this.setLibraryVersion(metadata.getLibraryVersion());
        this.setSslEnabled(metadata.isSslEnabled());
    }

    protected void setClientName(String clientName) {
        this.clientName = clientName;
    }

    String getClientName() {
        return this.clientName;
    }

    void setLibraryName(String libraryName) {
        this.libraryName = libraryName;
    }

    String getLibraryName() {
        return this.libraryName;
    }

    void setLibraryVersion(String libraryVersion) {
        this.libraryVersion = libraryVersion;
    }

    String getLibraryVersion() {
        return this.libraryVersion;
    }

    boolean isSslEnabled() {
        return this.sslEnabled;
    }

    void setSslEnabled(boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
    }
}

