/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.codecs.util;

import io.lighty.codecs.util.ConverterUtils;
import io.lighty.codecs.util.exception.DeserializationException;
import io.lighty.codecs.util.exception.SerializationException;
import java.io.Reader;
import java.io.Writer;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack;

public interface NodeConverter {
    default public Writer serializeData(SchemaNodeIdentifier.Absolute schemaNodeIdentifier, NormalizedNode normalizedNode) throws SerializationException {
        SchemaInferenceStack.Inference inference = SchemaInferenceStack.of((EffectiveModelContext)this.getModelContext(), (SchemaNodeIdentifier.Absolute)schemaNodeIdentifier).toInference();
        return this.serializeData(inference, normalizedNode);
    }

    default public Writer serializeData(NormalizedNode normalizedNode) throws SerializationException {
        return this.serializeData(SchemaInferenceStack.of((EffectiveModelContext)this.getModelContext()).toInference(), normalizedNode);
    }

    default public Writer serializeData(YangInstanceIdentifier yangInstanceIdentifier, NormalizedNode normalizedNode) throws SerializationException {
        SchemaInferenceStack.Inference inference = ConverterUtils.toInference(yangInstanceIdentifier, this.getModelContext());
        return this.serializeData(inference, normalizedNode);
    }

    public Writer serializeData(SchemaInferenceStack.Inference var1, NormalizedNode var2) throws SerializationException;

    default public Writer serializeRpc(SchemaNodeIdentifier.Absolute schemaNodeIdentifier, NormalizedNode normalizedNode) throws SerializationException {
        SchemaInferenceStack.Inference inference = SchemaInferenceStack.of((EffectiveModelContext)this.getModelContext(), (SchemaNodeIdentifier.Absolute)schemaNodeIdentifier).toInference();
        return this.serializeRpc(inference, normalizedNode);
    }

    default public Writer serializeRpc(YangInstanceIdentifier yangInstanceIdentifier, NormalizedNode normalizedNode) throws SerializationException {
        SchemaInferenceStack.Inference inference = ConverterUtils.toInference(yangInstanceIdentifier, this.getModelContext());
        return this.serializeRpc(inference, normalizedNode);
    }

    public Writer serializeRpc(SchemaInferenceStack.Inference var1, NormalizedNode var2) throws SerializationException;

    default public NormalizedNode deserialize(SchemaNodeIdentifier.Absolute schemaNodeIdentifier, Reader inputData) throws DeserializationException {
        return this.deserialize(SchemaInferenceStack.of((EffectiveModelContext)this.getModelContext(), (SchemaNodeIdentifier.Absolute)schemaNodeIdentifier).toInference(), inputData);
    }

    default public NormalizedNode deserialize(Reader inputData) throws DeserializationException {
        return this.deserialize(SchemaInferenceStack.of((EffectiveModelContext)this.getModelContext()).toInference(), inputData);
    }

    default public NormalizedNode deserialize(YangInstanceIdentifier yangInstanceIdentifier, Reader inputData) throws DeserializationException {
        SchemaInferenceStack.Inference inference = ConverterUtils.toInference(yangInstanceIdentifier, this.getModelContext());
        return this.deserialize(inference, inputData);
    }

    public NormalizedNode deserialize(SchemaInferenceStack.Inference var1, Reader var2) throws DeserializationException;

    public EffectiveModelContext getModelContext();
}

