/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.codecs.util;

import com.google.common.base.Preconditions;
import io.lighty.codecs.util.NodeConverter;
import io.lighty.codecs.util.exception.DeserializationException;
import io.lighty.codecs.util.exception.SerializationException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.opendaylight.yangtools.yang.common.XMLNamespace;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeWriter;
import org.opendaylight.yangtools.yang.data.codec.xml.XMLStreamNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.codec.xml.XmlParserStream;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.NormalizationResultHolder;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.EffectiveStatementInference;
import org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlNodeConverter
implements NodeConverter {
    private static final Logger LOG = LoggerFactory.getLogger(XmlNodeConverter.class);
    private static final XMLInputFactory XML_IN_FACTORY = XMLInputFactory.newInstance();
    private static final XMLOutputFactory XML_OUT_FACTORY = XMLOutputFactory.newFactory();
    private final EffectiveModelContext effectiveModelContext;

    public XmlNodeConverter(EffectiveModelContext effectiveModelContext) {
        this.effectiveModelContext = effectiveModelContext;
    }

    @Override
    public Writer serializeData(SchemaInferenceStack.Inference inference, NormalizedNode normalizedNode) throws SerializationException {
        StringWriter stringWriter;
        block10: {
            XMLStreamWriter xmlStreamWriter;
            StringWriter writer = new StringWriter();
            try {
                xmlStreamWriter = XML_OUT_FACTORY.createXMLStreamWriter(writer);
            }
            catch (FactoryConfigurationError | XMLStreamException e) {
                throw new SerializationException(e);
            }
            NormalizedNodeStreamWriter nnStreamWriter = XMLStreamNormalizedNodeStreamWriter.create((XMLStreamWriter)xmlStreamWriter, (EffectiveStatementInference)inference);
            NormalizedNodeWriter nnWriter = NormalizedNodeWriter.forStreamWriter((NormalizedNodeStreamWriter)nnStreamWriter);
            try {
                nnWriter.write(normalizedNode);
                stringWriter = writer;
                if (nnWriter == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (nnWriter != null) {
                        try {
                            nnWriter.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new SerializationException(e);
                }
            }
            nnWriter.close();
        }
        return stringWriter;
    }

    @Override
    public Writer serializeRpc(SchemaInferenceStack.Inference inference, NormalizedNode normalizedNode) throws SerializationException {
        StringWriter stringWriter;
        block11: {
            XMLStreamWriter xmlStreamWriter;
            Preconditions.checkState((boolean)(normalizedNode instanceof ContainerNode), (Object)"RPC input/output to serialize is expected to be a ContainerNode");
            StringWriter writer = new StringWriter();
            try {
                xmlStreamWriter = XML_OUT_FACTORY.createXMLStreamWriter(writer);
            }
            catch (FactoryConfigurationError | XMLStreamException e) {
                throw new SerializationException(e);
            }
            XMLNamespace namespace = normalizedNode.name().getNodeType().getNamespace();
            String localName = normalizedNode.name().getNodeType().getLocalName();
            NormalizedNodeStreamWriter nnStreamWriter = XMLStreamNormalizedNodeStreamWriter.create((XMLStreamWriter)xmlStreamWriter, (EffectiveStatementInference)inference);
            NormalizedNodeWriter nnWriter = NormalizedNodeWriter.forStreamWriter((NormalizedNodeStreamWriter)nnStreamWriter);
            try {
                xmlStreamWriter.writeStartElement("", localName, namespace.toString());
                xmlStreamWriter.writeDefaultNamespace(namespace.toString());
                for (NormalizedNode child : ((ContainerNode)normalizedNode).body()) {
                    nnWriter.write(child);
                }
                xmlStreamWriter.writeEndElement();
                stringWriter = writer;
                if (nnWriter == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (nnWriter != null) {
                        try {
                            nnWriter.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | XMLStreamException e) {
                    throw new SerializationException(e);
                }
            }
            nnWriter.close();
        }
        return stringWriter;
    }

    @Override
    public NormalizedNode deserialize(SchemaInferenceStack.Inference inference, Reader inputData) throws DeserializationException {
        XMLStreamReader reader;
        try {
            reader = XML_IN_FACTORY.createXMLStreamReader(inputData);
        }
        catch (XMLStreamException e) {
            throw new DeserializationException(e);
        }
        NormalizationResultHolder result = new NormalizationResultHolder();
        NormalizedNodeStreamWriter streamWriter = ImmutableNormalizedNodeStreamWriter.from((NormalizationResultHolder)result);
        try {
            NormalizedNode normalizedNode;
            block17: {
                XmlParserStream xmlParser = XmlParserStream.create((NormalizedNodeStreamWriter)streamWriter, (EffectiveStatementInference)inference);
                try {
                    xmlParser.parse(reader);
                    normalizedNode = result.getResult().data();
                    if (xmlParser == null) break block17;
                }
                catch (Throwable throwable) {
                    try {
                        if (xmlParser != null) {
                            try {
                                xmlParser.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | XMLStreamException e) {
                        throw new DeserializationException(e);
                    }
                }
                xmlParser.close();
            }
            return normalizedNode;
        }
        finally {
            try {
                reader.close();
            }
            catch (XMLStreamException e) {
                LOG.warn("Failed to close XML stream", (Throwable)e);
            }
        }
    }

    @Override
    public EffectiveModelContext getModelContext() {
        return this.effectiveModelContext;
    }

    static {
        XML_OUT_FACTORY.setProperty("javax.xml.stream.isRepairingNamespaces", true);
    }
}

