/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.core.common;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SocketAnalyzer {
    private static final Logger LOG = LoggerFactory.getLogger(SocketAnalyzer.class);
    private static final int SOCKET_PORT_WAIT_TIME = 500;

    private SocketAnalyzer() {
    }

    public static Boolean awaitPortAvailable(int port, long timeout, TimeUnit timeUnit) throws InterruptedException {
        long expectedEndTime = System.nanoTime() + timeUnit.toNanos(timeout);
        while (System.nanoTime() <= expectedEndTime) {
            Boolean bl;
            LOG.debug("Check if port {} is available", (Object)port);
            ServerSocket serverSocket = new ServerSocket(port);
            try {
                LOG.debug("Port {} available", (Object)port);
                bl = true;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        serverSocket.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.info("Port {} is not available - Awaiting port availability 1s", (Object)port);
                    Thread.sleep(500L);
                }
            }
            serverSocket.close();
            return bl;
        }
        return false;
    }
}

