/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.core.common.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.opendaylight.yangtools.binding.meta.YangModuleInfo;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.common.XMLNamespace;

public final class ModuleId {
    private final String usedBy;
    private final XMLNamespace nameSpace;
    private final String name;
    private final Revision revision;

    @JsonCreator
    public ModuleId(@JsonProperty(value="usedBy") String usedBy, @JsonProperty(value="nameSpace") String nameSpace, @JsonProperty(value="name") String name, @JsonProperty(value="revision") String revision) {
        this(usedBy, nameSpace, name, (Revision)Revision.ofNullable((String)revision).orElse(null));
    }

    public ModuleId(String nameSpace, String name, String revision) {
        this(nameSpace, name, (Revision)Revision.ofNullable((String)revision).orElse(null));
    }

    public ModuleId(String usedBy, String nameSpace, String name, Revision revision) {
        this(usedBy, XMLNamespace.of((String)nameSpace), name, revision);
    }

    public ModuleId(String nameSpace, String name, Revision revision) {
        this(null, XMLNamespace.of((String)nameSpace), name, revision);
    }

    public ModuleId(String usedBy, XMLNamespace nameSpace, String name, Revision revision) {
        this.usedBy = usedBy;
        this.nameSpace = nameSpace;
        this.name = name;
        this.revision = revision;
    }

    public String getName() {
        return this.name;
    }

    public Revision getRevision() {
        return this.revision;
    }

    public XMLNamespace getNameSpace() {
        return this.nameSpace;
    }

    public String getUsedBy() {
        return this.usedBy;
    }

    public QName getQName() {
        return QName.create((XMLNamespace)this.nameSpace, (Revision)this.revision, (String)this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ModuleId)) {
            return false;
        }
        ModuleId moduleId = (ModuleId)obj;
        return Objects.equals(this.name, moduleId.name) && Objects.equals(this.revision, moduleId.revision) && Objects.equals(this.nameSpace, moduleId.nameSpace);
    }

    public int hashCode() {
        return Objects.hash(this.nameSpace, this.name, this.revision);
    }

    public static ModuleId from(String nameSpace, String name, String revision) {
        return new ModuleId(nameSpace, name, revision);
    }

    public static ModuleId from(YangModuleInfo yangModuleInfo) {
        QName name = yangModuleInfo.getName();
        return new ModuleId(name.getNamespace().toString(), name.getLocalName(), name.getRevision().orElse(null));
    }

    public String toString() {
        return String.valueOf(this.nameSpace) + ":" + this.name + "@" + (this.revision != null ? this.revision.toString() : "");
    }
}

