/*
 * Decompiled with CFR 0.152.
 */
package io.lighty.core.common.models;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.lighty.core.common.models.ModuleId;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import org.opendaylight.yangtools.binding.meta.YangModelBindingProvider;
import org.opendaylight.yangtools.binding.meta.YangModuleInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class YangModuleUtils {
    private static final Logger LOG = LoggerFactory.getLogger(YangModuleUtils.class);
    private static final String ADDING_MODULE_INTO_KNOWN_MODULES = "Adding [{}] module into known modules";

    private YangModuleUtils() {
        throw new UnsupportedOperationException("do not instantiate utility class");
    }

    public static Set<YangModuleInfo> getAllModelsFromClasspath() {
        HashSet<YangModuleInfo> moduleInfos = new HashSet<YangModuleInfo>();
        ServiceLoader<YangModelBindingProvider> yangProviderLoader = ServiceLoader.load(YangModelBindingProvider.class);
        for (YangModelBindingProvider yangModelBindingProvider : yangProviderLoader) {
            moduleInfos.add(yangModelBindingProvider.getModuleInfo());
            LOG.info(ADDING_MODULE_INTO_KNOWN_MODULES, (Object)yangModelBindingProvider.getModuleInfo());
        }
        return Collections.unmodifiableSet(moduleInfos);
    }

    public static Set<YangModuleInfo> filterTopLevelModels(Set<YangModuleInfo> models) {
        HashSet<YangModuleInfo> result = new HashSet<YangModuleInfo>();
        for (YangModuleInfo yangModuleInfo : models) {
            if (YangModuleUtils.isDependentModel(models, yangModuleInfo)) continue;
            result.add(yangModuleInfo);
        }
        return result;
    }

    public static Set<YangModuleInfo> filterUniqueModels(Collection<YangModuleInfo> models) {
        HashMap<ModuleId, YangModuleInfo> result = new HashMap<ModuleId, YangModuleInfo>();
        for (YangModuleInfo yangModuleInfo : models) {
            result.put(ModuleId.from(yangModuleInfo), yangModuleInfo);
            for (YangModuleInfo yangModuleInfoDep : YangModuleUtils.filterUniqueModels(yangModuleInfo.getImportedModules())) {
                result.put(ModuleId.from(yangModuleInfoDep), yangModuleInfoDep);
            }
        }
        return new HashSet<YangModuleInfo>(result.values());
    }

    public static Set<YangModuleInfo> getModelsFromClasspath(Set<ModuleId> filter) {
        HashMap<ModuleId, YangModuleInfo> resolvedModules = new HashMap<ModuleId, YangModuleInfo>();
        ServiceLoader<YangModelBindingProvider> yangProviderLoader = ServiceLoader.load(YangModelBindingProvider.class);
        for (ModuleId moduleId : filter) {
            Set<YangModuleInfo> filteredSet = YangModuleUtils.filterYangModelBindingProviders(moduleId, yangProviderLoader);
            for (YangModuleInfo yangModuleInfo : filteredSet) {
                resolvedModules.put(ModuleId.from(yangModuleInfo), yangModuleInfo);
                LOG.info(ADDING_MODULE_INTO_KNOWN_MODULES, (Object)yangModuleInfo);
                YangModuleUtils.addDependencies(resolvedModules, yangModuleInfo.getImportedModules());
            }
        }
        return Collections.unmodifiableSet(resolvedModules.values().stream().collect(Collectors.toSet()));
    }

    private static void addDependencies(Map<ModuleId, YangModuleInfo> resolvedModules, Collection<YangModuleInfo> importedModules) {
        for (YangModuleInfo yangModuleInfo : importedModules) {
            resolvedModules.put(ModuleId.from(yangModuleInfo), yangModuleInfo);
            LOG.info(ADDING_MODULE_INTO_KNOWN_MODULES, (Object)yangModuleInfo);
            YangModuleUtils.addDependencies(resolvedModules, yangModuleInfo.getImportedModules());
        }
    }

    private static Set<YangModuleInfo> filterYangModelBindingProviders(ModuleId moduleId, ServiceLoader<YangModelBindingProvider> yangProviderLoader) {
        HashSet<YangModuleInfo> filteredSet = new HashSet<YangModuleInfo>();
        for (YangModelBindingProvider yangModelBindingProvider : yangProviderLoader) {
            if (!moduleId.getQName().equals((Object)yangModelBindingProvider.getModuleInfo().getName())) continue;
            filteredSet.add(yangModelBindingProvider.getModuleInfo());
        }
        return filteredSet;
    }

    private static boolean isDependentModel(Set<YangModuleInfo> models, YangModuleInfo yangModuleInfo) {
        for (YangModuleInfo moduleInfo : models) {
            if (!YangModuleUtils.hasDependency(moduleInfo, yangModuleInfo)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasDependency(YangModuleInfo superiorModel, YangModuleInfo dependency) {
        for (YangModuleInfo moduleInfo : superiorModel.getImportedModules()) {
            if (moduleInfo.getName().equals((Object)dependency.getName())) {
                return true;
            }
            YangModuleUtils.hasDependency(moduleInfo, dependency);
        }
        return false;
    }

    public static ArrayNode generateJSONModelSetConfiguration(Set<YangModuleInfo> models) {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode arrayNode = mapper.createArrayNode();
        for (YangModuleInfo yangModuleInfo : models) {
            ObjectNode modelObject = mapper.createObjectNode();
            ModuleId moduleId = ModuleId.from(yangModuleInfo);
            modelObject.put("nameSpace", moduleId.getNameSpace().toString());
            modelObject.put("name", moduleId.getName());
            if (moduleId.getRevision() != null) {
                modelObject.put("revision", moduleId.getRevision().toString());
            }
            arrayNode.add((JsonNode)modelObject);
        }
        return arrayNode;
    }
}

